/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormEngine;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraph;
import org.eclipse.hyades.test.ui.internal.editor.form.base.IParagraphSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormEngineLayout
extends Layout {
    public Point computeSize(Composite composite, int n, int n2, boolean bl) {
        FormEngine formEngine = (FormEngine)composite;
        int n3 = n;
        if (n3 != -1) {
            n3 -= formEngine.marginWidth * 2;
        }
        Point point = this.computeTextSize(formEngine, n3);
        int n4 = point.x + 2 * formEngine.marginWidth;
        int n5 = point.y + 2 * formEngine.marginHeight;
        Point point2 = new Point(n4, n5);
        return point2;
    }

    private Point computeTextSize(FormEngine formEngine, int n) {
        IParagraph[] iParagraphArray = formEngine.model.getParagraphs();
        GC gC = new GC((Drawable)formEngine);
        gC.setFont(formEngine.getFont());
        Locator locator = new Locator();
        int n2 = n != -1 ? n : 0;
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = 0;
        while (n4 < iParagraphArray.length) {
            IParagraph iParagraph = iParagraphArray[n4];
            if (n4 > 0 && formEngine.paragraphsSeparated && iParagraph.getAddVerticalSpace()) {
                locator.y += formEngine.getParagraphSpacing(n3);
            }
            locator.rowHeight = 0;
            locator.indent = iParagraph.getIndent();
            locator.x = iParagraph.getIndent();
            IParagraphSegment[] iParagraphSegmentArray = iParagraph.getSegments();
            if (iParagraphSegmentArray.length > 0) {
                int n5 = 0;
                while (n5 < iParagraphSegmentArray.length) {
                    IParagraphSegment iParagraphSegment = iParagraphSegmentArray[n5];
                    iParagraphSegment.advanceLocator(gC, n, locator, formEngine.objectTable);
                    n2 = Math.max(n2, locator.width);
                    ++n5;
                }
                locator.y += locator.rowHeight;
            } else {
                locator.y += n3;
            }
            ++n4;
        }
        gC.dispose();
        return new Point(n2, locator.y);
    }

    protected void layout(Composite composite, boolean bl) {
    }
}

