/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import java.text.BreakIterator;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ITextSegment;
import org.eclipse.hyades.test.ui.internal.editor.form.base.Locator;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ParagraphSegment;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class TextSegment
extends ParagraphSegment
implements ITextSegment {
    private Color color;
    private String fontId;
    private String text;
    protected boolean underline;
    private boolean wrapAllowed = true;
    protected Vector areaRectangles = new Vector();

    public TextSegment(String string, String string2) {
        this.text = this.cleanup(string);
        this.fontId = string2;
    }

    private String cleanup(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\n' || c == '\r' || c == '\f') {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setWordWrapAllowed(boolean bl) {
        this.wrapAllowed = bl;
    }

    public boolean isWordWrapAllowed() {
        return this.wrapAllowed;
    }

    public boolean isSelectable() {
        return false;
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        if (this.fontId == null) {
            return JFaceResources.getDefaultFont();
        }
        return JFaceResources.getFontRegistry().get(this.fontId);
    }

    public String getText() {
        return this.text;
    }

    void setText(String string) {
        this.text = this.cleanup(string);
    }

    void setColor(Color color) {
        this.color = color;
    }

    void setFontId(String string) {
        this.fontId = string;
    }

    public boolean contains(int n, int n2) {
        int n3 = 0;
        while (n3 < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n3);
            if (areaRectangle.contains(n, n2)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public Rectangle getBounds() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n5);
            if (n5 == 0) {
                n2 = areaRectangle.rect.y;
            }
            n = Math.min(areaRectangle.rect.x, n);
            n3 = Math.max(areaRectangle.rect.width, n3);
            n4 += areaRectangle.rect.height;
            ++n5;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void advanceLocator(GC gC, int n, Locator locator, Hashtable hashtable) {
        Point point;
        String string;
        Font font = null;
        if (this.fontId != null) {
            font = gC.getFont();
            gC.setFont(this.getFont());
        }
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        if (n == -1 || !this.wrapAllowed) {
            Point point2 = gC.textExtent(this.text);
            if (locator.x + point2.x > n) {
                locator.x = this.isSelectable() ? locator.indent + 1 : locator.indent;
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
            }
            int n3 = point2.x;
            if (this.isSelectable()) {
                n3 += 2;
            }
            locator.x += n3;
            locator.width = n3;
            locator.height = point2.y;
            locator.rowHeight = Math.max(locator.rowHeight, point2.y);
            return;
        }
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.text);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Point point3 = null;
        int n7 = breakIterator.first();
        while (n7 != -1) {
            string = this.text.substring(n4, n7);
            point = gC.textExtent(string);
            if (locator.x + point.x > n) {
                String string2 = this.text.substring(n4, n5);
                if (point3 == null) {
                    point3 = gC.textExtent(string2);
                }
                int n8 = locator.x + point3.x;
                if (this.isSelectable()) {
                    n8 += 2;
                }
                n4 = n5;
                locator.rowHeight = Math.max(locator.rowHeight, point3.y);
                locator.x = this.isSelectable() ? locator.indent + 1 : locator.indent;
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
                n6 = Math.max(n6, n8);
            }
            n5 = n7;
            point3 = point;
            n7 = breakIterator.next();
        }
        string = this.text.substring(n4, n5);
        point = gC.textExtent(string);
        int n9 = point.x;
        if (this.isSelectable()) {
            n9 += 2;
        }
        locator.x += n9;
        locator.width = n6;
        locator.height = n2;
        locator.rowHeight = Math.max(locator.rowHeight, point.y);
        if (font != null) {
            gC.setFont(font);
        }
    }

    public void paint(GC gC, int n, Locator locator, Hashtable hashtable, boolean bl) {
        String string;
        int n2;
        Point point;
        String string2;
        Font font = null;
        Color color = null;
        this.areaRectangles.clear();
        if (this.fontId != null) {
            font = gC.getFont();
            gC.setFont(this.getFont());
        }
        if (this.color != null) {
            color = gC.getForeground();
            gC.setForeground(this.color);
        }
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.getDescent();
        if (!this.wrapAllowed) {
            Point point2 = gC.textExtent(this.text);
            int n5 = point2.x;
            if (this.isSelectable()) {
                n5 += 2;
            }
            if (locator.x + n5 > n) {
                locator.resetCaret();
                if (this.isSelectable()) {
                    ++locator.x;
                }
                locator.y += locator.rowHeight;
                locator.rowHeight = 0;
            }
            gC.drawString(this.text, locator.x, locator.y);
            if (this.underline) {
                int n6 = locator.y + n3 - n4 + 1;
                gC.drawLine(locator.x, n6, locator.x + point2.x, n6);
            }
            Rectangle rectangle = new Rectangle(locator.x - 1, locator.y, point2.x + 2, n3 - n4 + 3);
            this.areaRectangles.add(new AreaRectangle(rectangle, 0, -1));
            if (bl) {
                if (this.color != null) {
                    gC.setForeground(color);
                }
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            locator.x += n5;
            locator.width = n5;
            locator.height = n3;
            locator.rowHeight = Math.max(locator.rowHeight, point2.y);
            if (font != null) {
                gC.setFont(font);
            }
            if (color != null) {
                gC.setForeground(color);
            }
            return;
        }
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(this.text);
        int n7 = 0;
        int n8 = 0;
        int n9 = breakIterator.first();
        while (n9 != -1) {
            if (n9 != 0) {
                string2 = this.text.substring(n7, n9);
                point = gC.textExtent(string2);
                n2 = point.x;
                if (this.isSelectable()) {
                    n2 += 2;
                }
                if (locator.x + n2 > n) {
                    string = this.text.substring(n7, n8);
                    gC.drawString(string, locator.x, locator.y, true);
                    Point point3 = gC.textExtent(string);
                    int n10 = point3.x;
                    if (this.isSelectable()) {
                        n10 += 2;
                    }
                    if (this.underline) {
                        int n11 = locator.y + n3 - n4 + 1;
                        gC.drawLine(locator.x, n11, locator.x + n10, n11);
                    }
                    Rectangle rectangle = new Rectangle(locator.x - 1, locator.y, point3.x + 2, n3 - n4 + 3);
                    if (bl) {
                        if (this.color != null) {
                            gC.setForeground(color);
                        }
                        gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        if (this.color != null) {
                            gC.setForeground(this.color);
                        }
                    }
                    this.areaRectangles.add(new AreaRectangle(rectangle, n7, n8));
                    locator.rowHeight = Math.max(locator.rowHeight, point3.y);
                    locator.resetCaret();
                    if (this.isSelectable()) {
                        ++locator.x;
                    }
                    locator.y += locator.rowHeight;
                    locator.rowHeight = 0;
                    n7 = n8;
                }
                n8 = n9;
            }
            n9 = breakIterator.next();
        }
        string2 = this.text.substring(n7, n8);
        gC.drawString(string2, locator.x, locator.y, true);
        point = gC.textExtent(string2);
        n2 = point.x;
        if (this.isSelectable()) {
            n2 += 2;
        }
        string = new Rectangle(locator.x - 1, locator.y, point.x + 2, n3 - n4 + 3);
        this.areaRectangles.add(new AreaRectangle((Rectangle)string, n7, n8));
        if (this.underline) {
            int n12 = locator.y + n3 - n4 + 1;
            gC.drawLine(locator.x, n12, locator.x + point.x, n12);
        }
        if (bl) {
            if (this.color != null) {
                gC.setForeground(color);
            }
            gC.drawFocus(((Rectangle)string).x, ((Rectangle)string).y, ((Rectangle)string).width, ((Rectangle)string).height);
        }
        locator.x += n2;
        locator.rowHeight = Math.max(locator.rowHeight, point.y);
        if (font != null) {
            gC.setFont(font);
        }
        if (color != null) {
            gC.setForeground(color);
        }
    }

    public void paintFocus(GC gC, Color color, Color color2, boolean bl) {
        if (this.areaRectangles == null) {
            return;
        }
        int n = 0;
        while (n < this.areaRectangles.size()) {
            AreaRectangle areaRectangle = (AreaRectangle)this.areaRectangles.get(n);
            Rectangle rectangle = areaRectangle.rect;
            if (bl) {
                gC.setBackground(color);
                gC.setForeground(color2);
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                gC.setForeground(color);
                gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            }
            ++n;
        }
    }

    class AreaRectangle {
        Rectangle rect;
        int from;
        int to;

        public AreaRectangle(Rectangle rectangle, int n, int n2) {
            this.rect = rectangle;
            this.from = n;
            this.to = n2;
        }

        public boolean contains(int n, int n2) {
            return this.rect.contains(n, n2);
        }

        public String getText() {
            if (this.from == 0 && this.to == -1) {
                return TextSegment.this.getText();
            }
            if (this.from > 0 && this.to == -1) {
                return TextSegment.this.getText().substring(this.from);
            }
            return TextSegment.this.getText().substring(this.from, this.to);
        }
    }
}

