/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.recorder.RecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.execution.recorder.http.ui.wizards.HttpRecorderFileSelectPage;
import org.eclipse.hyades.internal.execution.recorder.Recorder;
import org.eclipse.hyades.internal.execution.recorder.RecorderException;
import org.eclipse.hyades.internal.execution.recorder.RecorderFactory;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.views.RecorderControlView;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.RecorderWizard;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestSuiteLocationSelectionPage;
import org.eclipse.jface.wizard.IWizardPage;

public class HttpRecorderLaunchWizard
extends RecorderWizard {
    private HttpRecorderFileSelectPage fileSelectPage;
    private TestSuiteLocationSelectionPage testLocationPage;

    public void run(IProgressMonitor iProgressMonitor) {
        if (RecorderFactory.getInstance().getActiveRecorder() != null) {
            RecorderPlugin.reportExceptionToUser((Exception)((Object)new RecorderException(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"))), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.UNABLE_TO_START_RECORDER_MESSAGE"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.ANOTHER_RECODER_ACTIVE_ERROR"), (String)HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDER_ERROR"));
            return;
        }
        Recorder recorder = null;
        try {
            Object object;
            File file;
            String string = "port," + HttpRecorderPlugin.getPreference("default_proxy_port");
            String string2 = this.fileSelectPage.getSelectedFilePath();
            HttpRecorderPlugin.storePreference("recording_path", string2);
            recorder = HttpRecorderPlugin.getDefault().getRecorder();
            recorder.setConfigParams(string);
            recorder.setRecordingPath(string2);
            recorder.setScriptgenID(HttpRecorderPlugin.getPreference("default_test_generator"));
            if (this.testLocationPage != null) {
                recorder.setTestPath(this.testLocationPage.getSelectedFilePath());
            }
            URL uRL = Platform.resolve((URL)new URL(HttpRecorderPlugin.getDefault().getDescriptor().getInstallURL(), "testkeys"));
            String string3 = uRL.toString();
            if (uRL.getProtocol().equals("file")) {
                string3 = uRL.getFile();
            }
            if ((file = new File(string3)).exists() && ((File)(object = new File("C:\\testkeys"))).createNewFile()) {
                try {
                    int n;
                    FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[256];
                    while ((n = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object = HttpRecorderPlugin.getPreference("application_under_test");
            recorder.setApplicationAdapterID((String)object);
            if (!((String)object).equalsIgnoreCase("-1")) {
                RecorderAppAdapterFactory.getInstance().getClient(HttpRecorderPlugin.getPreference("application_under_test")).setInitString(string);
            }
            recorder.Record();
        }
        catch (Exception exception) {
            if (recorder != null) {
                recorder.setActive(false);
            }
            exception.printStackTrace();
            RecorderControlView.getInstance().addMessage(HttpRecorderPlugin.getResourceString("HttpRecorderLaunchWizard.RECORDING_ABORTED_DUE_TO_EXCEPTION_MESSAGE") + exception.getMessage());
        }
    }

    public void addPages() {
        this.fileSelectPage = new HttpRecorderFileSelectPage();
        this.addPage((IWizardPage)this.fileSelectPage);
        if (!HttpRecorderPlugin.getPreference("default_test_generator").equalsIgnoreCase("-1")) {
            this.testLocationPage = new TestSuiteLocationSelectionPage();
            this.addPage((IWizardPage)this.testLocationPage);
        }
    }
}

