/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.testgen.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.execution.testgen.TestgenPlugin;
import org.eclipse.hyades.internal.execution.testgen.TestGenerator;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestGeneratorSelectorPage;
import org.eclipse.hyades.internal.execution.testgen.ui.wizards.TestSuiteLocationSelectionPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesNewWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;

public class RunTestGenWizard
extends HyadesNewWizard
implements INewWizard,
IRunnableWithProgress {
    private TestSuiteLocationSelectionPage testFileSelectionPage;
    private TestGeneratorSelectorPage generatorSelectorPage;
    private IFile selectedRecModelFile;

    public RunTestGenWizard(IFile iFile) {
        this.selectedRecModelFile = iFile;
    }

    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
    }

    protected boolean createObject(IFile iFile) throws Exception {
        return false;
    }

    public boolean performFinish() {
        String string = TestgenPlugin.getDefault().getPluginPreferences().getString("selected_generator");
        IConfigurationElement iConfigurationElement = TestGeneratorFactory.getInstance().getGeneratorConfigElement(string);
        if (iConfigurationElement == null) {
            System.out.println(TestgenPlugin.getResourceString("RunTestGenWizard.UNABLE_TO_LOAD_SELECTED_GENERATOR_ERROR_MSG"));
            return false;
        }
        try {
            TestGenerator testGenerator = (TestGenerator)iConfigurationElement.createExecutableExtension("class");
            testGenerator.initialize(this.selectedRecModelFile, this.testFileSelectionPage.getSelectedFilePath());
            Display.getDefault().asyncExec((Runnable)testGenerator);
            return true;
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
            return false;
        }
    }

    private void saveSettings() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 0;
        while (n < iWizardPageArray.length) {
            ((ITestGenWizardPage)iWizardPageArray[n]).saveSettings();
            ++n;
        }
    }

    public void addPages() {
        this.generatorSelectorPage = new TestGeneratorSelectorPage();
        this.addPage(this.generatorSelectorPage);
        this.testFileSelectionPage = new TestSuiteLocationSelectionPage();
        this.addPage(this.testFileSelectionPage);
    }

    public void dispose() {
    }
}

