/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentGenerator;
import org.w3c.dom.Document;

public abstract class GraphicDocumentGenerator
implements IGraphicDocumentGenerator,
Serializable {
    protected String graphicType;

    public String getGraphicType() {
        return this.graphicType;
    }

    public Document generateGraphicDocument(Document document) throws DataInputProcessingException {
        GraphicDocumentProperties graphicDocumentProperties = new GraphicDocumentProperties();
        graphicDocumentProperties.setDataDocument(document);
        return this.generateGraphicDocument(graphicDocumentProperties);
    }

    public String generateAndSerializeToString(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException, IOException {
        Document document = this.generateGraphicDocument(graphicDocumentProperties);
        return this.serializeGeneratedDocumentToString(document);
    }

    public boolean generateAndSerializeToFile(GraphicDocumentProperties graphicDocumentProperties, String string) throws DataInputProcessingException, IOException {
        Document document = this.generateGraphicDocument(graphicDocumentProperties);
        if (document != null) {
            return this.serializeGeneratedDocumentToFile(document, string);
        }
        return false;
    }

    public boolean serializeGeneratedDocumentToFile(Document document, String string) throws IOException {
        if (document == null) {
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        OutputFormat outputFormat = new OutputFormat(document);
        XMLSerializer xMLSerializer = new XMLSerializer((Writer)outputStreamWriter, outputFormat);
        xMLSerializer.serialize(document);
        outputStreamWriter.close();
        return true;
    }

    public String serializeGeneratedDocumentToString(Document document) throws IOException {
        if (document == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        new XMLSerializer((Writer)outputStreamWriter, null).serialize(document);
        return byteArrayOutputStream.toString();
    }

    public static byte[] serializeGeneratedDocumentToStream(Document document) {
        if (document == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            new XMLSerializer((Writer)outputStreamWriter, null).serialize(document);
        }
        catch (Exception exception) {
            System.out.println("Serialize to stream failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public abstract Document generateGraphicDocument(GraphicDocumentProperties var1) throws DataInputProcessingException;
}

