/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGLineChart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGAreaChart
extends SVGLineChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGAreaChart() {
        this.graphicType = "area";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        String[] stringArray;
        Object object;
        double d;
        double d2;
        double d3;
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        int n = 0;
        String[] stringArray2 = null;
        try {
            n = this.dataRetriever.getNumberOfDatasets(document);
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        String string = null;
        int n2 = 60;
        int n3 = n2 / 2;
        int n4 = 50;
        int n5 = 0;
        try {
            this.xAxis = this.dataRetriever.getDataRange(document, "S");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(document, "W");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 0 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            string = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        this.dataSets = new DataSet[n];
        int n6 = 0;
        while (n6 < n) {
            this.dataSets[n6] = this.dataRetriever.getDatasetWithPosition(document, Integer.toString(n6));
            ++n6;
        }
        stringArray2 = this.getLegendFlyOverLabels(this.dataSets);
        double d4 = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttributes);
        if (d4 > (d3 = (double)(graphicAttributes.getGraphicWidth() / 4))) {
            d4 = d3;
        }
        if ((d2 = this.getMaxLengthOfLegendLabel(graphicAttributes, this.dataSets)) > (d = (double)(graphicAttributes.getGraphicWidth() / 3))) {
            d2 = d;
        }
        if (graphicAttributes.isLegendSuppressed()) {
            d2 = 0.0;
        }
        n5 = (int)((double)graphicAttributes.getGraphicWidth() - (d2 + d4 + (double)n2));
        int n7 = this.getNumberOfAxisLabels(graphicAttributes, n5, this.xAxis);
        int n8 = (int)((double)graphicAttributes.getGraphicHeight() - (double)n4 * 2.5 - (double)(n7 * 10));
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.registerEventHandler(element, "onload", "init(evt)");
        this.addDefinitions(document2, graphicAttributes, n);
        this.addJavaScriptFunctions(document2, graphicAttributes, n, n2, n4, n5, n8);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                object = this.dataRetriever.getTimestamp(document);
                stringArray = GraphicAttributes.parseISO8601Date((String)object);
                this.addTimeStamp(document2, graphicAttributes, (String)(stringArray == null ? object : graphicAttributes.formatDate((Date)stringArray)));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        } else {
            n4 = super.resetGridOffsetForCenter(graphicAttributes.getGraphicHeight(), n8, 3.0);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        n2 = n3 + (int)d4;
        this.addGrid(document2, element, n5, n8, n2, n4, this.xAxis, this.yAxis);
        this.addAxisLabels(document2, graphicAttributes, element, n5, n8, n2, n4, this.xAxis, this.yAxis);
        this.addTitles(document2, graphicAttributes, element, n5, n8, n2, n4, this.xAxis, this.yAxis, n7, string);
        object = document2.createElement("g");
        this.addDataSets(document2, graphicAttributes, element, (Element)object, n5, n8, n2, n4, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttributes.isLegendSuppressed()) {
            try {
                stringArray = this.dataRetriever.getLegendLabels(document);
                this.addLegend(document2, graphicAttributes, (Element)object, stringArray, stringArray2, (int)d4 + n5 + n3, n4);
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        element.appendChild((Node)object);
        return document2;
    }

    protected Element addLegendItemGraphic(Document document, Element element, int n, int n2, int n3, int n4) {
        String[] stringArray = new String[]{"#legendcircleshape", "#legendsquareshape", "#legendhorizontalrectshape", "#legendverticalrectshape", "#legendtriangleshape", "#legenddiamondshape"};
        Element element2 = document.createElement("use");
        element2.setAttribute("xlink:href", "#legendsquareshapeWithoutLine");
        element2.setAttribute("x", Integer.toString(n3));
        element2.setAttribute("y", Integer.toString(n4 + n2 - 9));
        Element element3 = document.createElement("g");
        element3.setAttribute("id", "legendsquareshapeWithoutLine" + n);
        element3.setAttribute("class", "shape" + n);
        if (this.graphicType.equals("area")) {
            element3.setAttribute("onclick", "toggleVisibility('dataColour" + n + "');");
            element3.setAttribute("onmouseover", "ChangeOpacity('poly" + n + "', '0.6');");
            element3.setAttribute("onmouseout", "ChangeOpacity('poly" + n + "', '0.1');");
        }
        element3.appendChild(element2);
        element.appendChild(element3);
        element2 = document.createElement("use");
        element2.setAttribute("xlink:href", stringArray[n % stringArray.length]);
        element2.setAttribute("x", Integer.toString(n3));
        element2.setAttribute("y", Integer.toString(n4 + n2 - 8));
        element3 = document.createElement("g");
        element3.setAttribute("id", "shape" + n);
        element3.setAttribute("onclick", "toggleVisibility('dataColour" + n + "');");
        element3.setAttribute("onmouseover", "ChangeOpacity('poly" + n + "', '0.6');");
        element3.setAttribute("onmouseout", "ChangeOpacity('poly" + n + "', '0.1');");
        element3.setAttribute("class", "shape" + n);
        element3.appendChild(element2);
        return element3;
    }

    private void addDataSets(Document document, GraphicAttributes graphicAttributes, Element element, Element element2, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2, DataSet[] dataSetArray) throws DataInputProcessingException {
        double d = dataRange.getMinValue();
        double d2 = dataRange.getMaxValue();
        double d3 = dataRange2.getMinValue();
        double d4 = dataRange2.getMaxValue();
        if (d == d2 || d3 == d4) {
            return;
        }
        int n5 = 0;
        while (n5 < dataSetArray.length) {
            DataSet dataSet = dataSetArray[n5];
            DataPoint[] dataPointArray = dataSet.getDataPoints();
            double[] dArray = new double[dataPointArray.length];
            double[] dArray2 = new double[dataPointArray.length];
            int n6 = 0;
            while (n6 < dataPointArray.length) {
                dArray2[n6] = (double)n * (dataPointArray[n6].getValue1() - d) / (d2 - d);
                dArray[n6] = (double)n2 * (d4 - dataPointArray[n6].getValue2()) / (d4 - d3);
                ++n6;
            }
            this.addArea(document, element, dataPointArray, n5, dArray2, dArray, n, n2, n3, n4);
            String string = "dataValues anchorAtMiddle";
            Element element3 = document.createElement("g");
            element3.setAttribute("id", "textbox" + n5);
            element3.setAttribute("class", string);
            element3.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
            element3.setAttribute("visibility", "hidden");
            element3.setAttribute("onclick", "toggleVisibility('textbox" + n5 + "');");
            element2.appendChild(element3);
            this.addTextBoxes(document, graphicAttributes, element3, n5, dArray2, dArray, dataPointArray, n, n2);
            ++n5;
        }
    }

    private void addArea(Document document, Element element, DataPoint[] dataPointArray, int n, double[] dArray, double[] dArray2, int n2, int n3, int n4, int n5) {
        double d;
        double d2;
        String[] stringArray = new String[]{"#circleshape", "#squareshape", "#horizontalrectshape", "#verticalrectshape", "#triangleshape", "#diamondshape"};
        double[] dArray3 = new double[]{5.6, 5.6, 5.6, 2.8, 5.6, 5.6};
        double[] dArray4 = new double[]{5.6, 5.6, 2.8, 5.6, 4.85, 5.6};
        int n6 = dArray.length;
        double d3 = 0.0;
        double d4 = 0.0;
        Element element2 = document.createElement("g");
        String string = dArray[0] + " " + n3;
        int n7 = 0;
        while (n7 < n6) {
            d2 = dArray[n7];
            d = dArray2[n7];
            string = string + ", " + d2 + " " + d;
            ++n7;
        }
        string = string + ", " + dArray[n6 - 1] + " " + n3;
        Element element3 = document.createElement("polygon");
        element3.setAttribute("id", "poly" + n);
        element3.setAttribute("points", string);
        element3.setAttribute("style", "fill-opacity: 0.1; stroke: black; stroke-width: 0;");
        element3.setAttribute("transform", "translate(" + n4 + "," + n5 + ")");
        element2.appendChild(element3);
        element2.setAttribute("id", "dataColour" + n);
        element2.setAttribute("class", "dataset" + n);
        element2.setAttribute("visibility", "visible");
        element2.setAttribute("onclick", "toggleVisibility('textbox" + n + "');");
        element.appendChild(element2);
        int n8 = n % stringArray.length;
        int n9 = 0;
        while (n9 < n6) {
            double d5;
            d2 = dArray[n9];
            d = dArray2[n9];
            if (n9 > 0) {
                Element element4 = document.createElement("polyline");
                String string2 = d3 + " " + d4 + "," + d2 + " " + d;
                element4.setAttribute("points", string2);
                if (dataPointArray[n9].getType() == 1 || dataPointArray[n9 - 1].getType() == 1) {
                    element4.setAttribute("style", "stroke-dasharray: 9, 5; stroke-width: 2;");
                }
                element4.setAttribute("transform", "translate(" + n4 + "," + n5 + ")");
                element2.appendChild(element4);
            }
            if ((d5 = d2 - dArray3[n8] / 2.0) <= 0.0) {
                d5 = 0.0;
            } else if (d5 + dArray3[n8] > (double)n2) {
                d5 = (double)n2 - dArray3[n8];
            }
            double d6 = d - dArray4[n8] / 2.0;
            if (d6 + dArray4[n8] > (double)n3) {
                d6 = (double)n3 - dArray4[n8];
            }
            Element element5 = document.createElement("use");
            if (dataPointArray[n9].getType() == 1) {
                element5.setAttribute("xlink:href", "#holeshape");
            } else {
                element5.setAttribute("xlink:href", stringArray[n8]);
            }
            element5.setAttribute("transform", "translate(" + ((double)n4 + d5) + "," + ((double)n5 + d6) + ")");
            element5.setAttribute("visibility", "visible");
            element2.appendChild(element5);
            d3 = d2;
            d4 = d;
            ++n9;
        }
    }

    protected GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setGraphicWidth("450");
        graphicAttributes.setPreferencesPage("prefs_area.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("495");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

