/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.ECMAScriptGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentGenerator;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentDefaults;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public abstract class SVGDocumentGenerator
extends GraphicDocumentGenerator
implements IGraphicDocumentStyle,
IGraphicDocumentDefaults,
Serializable {
    static final String SVG_VERSION = "-//W3C//DTD SVG 1.0//EN";
    static final String SVG_DTD = "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd";
    static final String SVG_XMLNS = "http://www.w3.org/1999/xlink";
    static final String JAVASCRIPT_VERSION = "text/ecmascript";
    protected final int TITLE_FONTSIZE_DELTA = 3;
    protected final int LABEL_FONTSIZE_DELTA = 2;

    protected Element addDefinitions(Document document, GraphicAttributes graphicAttributes) {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("defs");
        element.appendChild(element2);
        if (!graphicAttributes.isUserPreferencesSuppressed()) {
            this.definePreferenceIcon(document, element2);
        }
        if (!graphicAttributes.isLegendSuppressed()) {
            this.defineLegendGraphic(document, element2);
        }
        return element2;
    }

    protected void addOutline(Document document, GraphicAttributes graphicAttributes) {
        Element element = document.getDocumentElement();
        boolean bl = true;
        Element element2 = document.createElement("rect");
        element2.setAttribute("class", "st1, outline");
        element2.setAttribute("width", Integer.toString(graphicAttributes.getGraphicWidth() - 1));
        element2.setAttribute("height", Integer.toString(graphicAttributes.getGraphicHeight() - 1));
        element.appendChild(element2);
    }

    protected void addTitleBar(Document document, GraphicAttributes graphicAttributes) {
        Element element = document.getDocumentElement();
        boolean bl = false;
        if (graphicAttributes.getGraphicTitle() != null) {
            this.addTitle(document, graphicAttributes, element);
            if (!bl) {
                this.addTitleBarLine(document, graphicAttributes, element, 28);
                bl = true;
            }
        }
    }

    protected void addPreferenceIcon(Document document, GraphicAttributes graphicAttributes) {
        Element element = document.getDocumentElement();
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document, graphicAttributes, element);
        }
    }

    protected void addTimeStamp(Document document, GraphicAttributes graphicAttributes, String string) {
        if (string == null) {
            return;
        }
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("g");
        String string2 = graphicAttributes.getGraphicTimestampPrefix();
        if (string2 != null) {
            string = string2 + " " + string;
        }
        element2.setAttribute("id", "timeStamp");
        element2.setAttribute("class", "timeStamp");
        this.addLabel(document, graphicAttributes, element2, string, null, graphicAttributes.getGraphicWidth() - 5, graphicAttributes.getGraphicHeight() - 8, 0);
        element.appendChild(element2);
    }

    protected void addLegend(Document document, GraphicAttributes graphicAttributes, Element element, String[] stringArray, String[] stringArray2, int n, int n2) {
        Element element2;
        Element element3 = document.getDocumentElement();
        int n3 = stringArray.length;
        int n4 = 10;
        int n5 = 9;
        int n6 = 11;
        int n7 = 15;
        int n8 = n6 + 6;
        int n9 = 16;
        int n10 = 0;
        int n11 = n + n7;
        int n12 = n2 + n4;
        int n13 = n2 - n5 + 8;
        String string = graphicAttributes.getGraphicLegendTitle();
        if (string != null) {
            element2 = document.createElement("g");
            element2.setAttribute("id", "legendTitle");
            element2.setAttribute("class", "legendTitle");
            element3.appendChild(element2);
            this.addLabel(document, graphicAttributes, element2, string, null, n11, n12, n10);
            n13 = n2 + n4 + 7;
        }
        element2 = document.createElement("g");
        element2.setAttribute("id", "legendData");
        element2.setAttribute("class", "legendData");
        element3.appendChild(element2);
        int n14 = 0;
        int n15 = n13;
        while (n14 < n3) {
            Element element4 = this.addLegendItemGraphic(document, element3, n14, n5, n11, n15);
            if (this.graphicType.equals("line") || this.graphicType.equals("area") || this.graphicType.equals("scatter")) {
                element3.appendChild(element4);
            }
            this.addHoverText(document, graphicAttributes, n14, element, stringArray[n14], stringArray2[n14], n11 + n8, (n15 += n9) - 7, n10);
            ++n14;
        }
    }

    protected Element addLegendItemGraphic(Document document, Element element, int n, int n2, int n3, int n4) {
        Element element2 = document.createElement("use");
        element2.setAttribute("xlink:href", "#legendsquareshapeWithoutLine");
        element2.setAttribute("x", Integer.toString(n3));
        element2.setAttribute("y", Integer.toString(n4 + n2 - 9));
        Element element3 = document.createElement("g");
        element3.setAttribute("id", "legendsquareshapeWithoutLine" + n);
        element3.setAttribute("class", "shape" + n);
        if (this.graphicType.equals("line") || this.graphicType.equals("area") || this.graphicType.equals("scatter")) {
            element3.setAttribute("onclick", "toggleVisibility('dataColour" + n + "');");
            if (this.graphicType.equals("scatter")) {
                String[] stringArray = new String[]{"flyoverCircleshape", "flyoverSquareshape", "flyoverHorizontalrectshape", "flyoverVerticalrectshape", "flyoverTriangleshape", "flyoverDiamondshape"};
                element3.setAttribute("onmouseover", "setVisibility('" + stringArray[n % stringArray.length] + "' , 'visible');");
                element3.setAttribute("onmouseout", "setVisibility('" + stringArray[n % stringArray.length] + "' , 'hidden');");
            }
        }
        element3.appendChild(element2);
        element.appendChild(element3);
        return element3;
    }

    protected void addJavaScriptFunctions(Document document, GraphicAttributes graphicAttributes, int n, int n2, int n3, int n4, int n5) {
        boolean bl = !graphicAttributes.isLegendSuppressed();
        String string = graphicAttributes.getBrowserCookieName();
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("script");
        element2.setAttribute("type", JAVASCRIPT_VERSION);
        element.appendChild(element2);
        ECMAScriptGenerator eCMAScriptGenerator = new ECMAScriptGenerator();
        StringBuffer stringBuffer = new StringBuffer(eCMAScriptGenerator.generateGlobalVariables());
        if (graphicAttributes.getSvgFormatOnly()) {
            stringBuffer.append(eCMAScriptGenerator.generateClientSnifferVariables());
        } else {
            stringBuffer.append(eCMAScriptGenerator.generateNullClientSnifferVariables());
        }
        if (string != null) {
            stringBuffer.append(eCMAScriptGenerator.generateCookieFunctions());
            stringBuffer.append(eCMAScriptGenerator.generateStorePreferencesFunction(string));
            stringBuffer.append(eCMAScriptGenerator.generateGetPreferencesFunction(string));
        }
        stringBuffer.append(eCMAScriptGenerator.generateInitFunction(graphicAttributes.getUserPreferences(), graphicAttributes.getGraphicColorPalette(), graphicAttributes.getGraphicColorPaletteName(), graphicAttributes.getGraphicFont(), string, this.graphicType, n, n2, n3, n4, n5));
        stringBuffer.append(eCMAScriptGenerator.generateToggleVisibilityFunction(n, this.graphicType));
        stringBuffer.append(eCMAScriptGenerator.generateUpdateStylesFunction(n, string, this.graphicType, bl, graphicAttributes.getUserPreferencesUpdateVariableName(), n2, n3, n4, n5));
        if (bl) {
            stringBuffer.append(eCMAScriptGenerator.generateUpdateLegendStylesFunction(n, this.graphicType));
            stringBuffer.append(eCMAScriptGenerator.generateFunctionFlyOver());
        }
        stringBuffer.append(eCMAScriptGenerator.generateFunctionPrefFlyOver());
        stringBuffer.append(eCMAScriptGenerator.generateGetCurrentValuesFunction());
        stringBuffer.append(eCMAScriptGenerator.generateGetUserPreferencesFunction());
        stringBuffer.append(eCMAScriptGenerator.generateResetStylesFunction());
        stringBuffer.append(eCMAScriptGenerator.generateGetPalettesFunction());
        stringBuffer.append(eCMAScriptGenerator.generateChangeOpacity());
        String string2 = graphicAttributes.getPreferencesPage();
        if (string2 != null) {
            stringBuffer.append(eCMAScriptGenerator.generateOpenPreferencePageFunction(graphicAttributes.getResourcesFolder(), string2, this.graphicType, graphicAttributes.getPreferencesPageWidth(), graphicAttributes.getPreferencesPageHeight()));
            if (string2.indexOf("prefs_") == 0) {
                stringBuffer.append(eCMAScriptGenerator.generateUseNetscapePreferencePage(graphicAttributes.getResourcesFolder(), string2, this.graphicType, graphicAttributes.getPreferencesPageWidth(), graphicAttributes.getPreferencesPageHeight()));
            }
        }
        stringBuffer.append(eCMAScriptGenerator.generateInspectFunction());
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        element2.appendChild(cDATASection);
    }

    protected Element addLabel(Document document, GraphicAttributes graphicAttributes, Element element, String string, String string2, double d, double d2, int n) {
        Element element2 = this.createDOMTextElement(document, graphicAttributes.getGraphicFont(), string, string2, Double.toString(d), Double.toString(d2), n);
        element.appendChild(element2);
        return element2;
    }

    protected Element createDOMTextElement(Document document, String string, String string2, String string3, String string4, String string5, int n) {
        Element element = document.createElement("text");
        if (string3 != null) {
            element.setAttribute("class", string3);
        }
        element.setAttribute("font", string);
        element.setAttribute("x", string4);
        element.setAttribute("y", string5);
        if (n > 0 && n < 360) {
            element.setAttribute("transform", "rotate(" + n + "," + string4 + "," + string5 + ")");
        }
        element.appendChild(document.createTextNode(string2));
        return element;
    }

    protected Document createSvgDocument(DOMImplementation dOMImplementation, String string, String string2) {
        DocumentType documentType = dOMImplementation.createDocumentType("svg", SVG_VERSION, SVG_DTD);
        Document document = dOMImplementation.createDocument(null, "svg", documentType);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:xlink", SVG_XMLNS);
        element.setAttribute("width", string);
        element.setAttribute("height", string2);
        element.setAttribute("viewbox", "0 0 " + (Integer.parseInt(string) - 1) + " " + (Integer.parseInt(string2) - 1));
        return document;
    }

    protected void defineLegendGraphic(Document document, Element element) {
        Element element2 = document.createElement("g");
        Element element3 = document.createElement("rect");
        element2.setAttribute("id", "legendsquareshapeWithoutLine");
        element.appendChild(element2);
        element3.setAttribute("width", "8");
        element3.setAttribute("height", "8");
        element3.setAttribute("transform", "translate(3,2)");
        element2.appendChild(element3);
    }

    protected void definePreferenceIcon(Document document, Element element) {
        Element element2 = document.createElement("g");
        Element element3 = document.createElement("g");
        Element element4 = document.createElement("path");
        element2.setAttribute("id", "preferences");
        element.appendChild(element2);
        element3.setAttribute("id", "graph");
        element3.setAttribute("style", "fill-rule:nonzero;clip-rule:nonzero;fill:none;stroke:#999999;stroke-miterlimit:4;");
        element2.appendChild(element3);
        element4.setAttribute("d", "M2.042,4.811H0.5v18h21v-6.542");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M2.042,4.811H0.5");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M2.042,10.801H0.5");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M2.042,16.8H0.5");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M6.51,22.81v-18H3.521v18H6.51z");
        element4.setAttribute("style", "fill:#000099;");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M12.51,22.81v-11H9.521v11h2.989z");
        element4.setAttribute("style", "fill:#0066CC;");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M18.51,22.81v-5h-2.989v5h2.989z");
        element4.setAttribute("style", "fill:#99CCFF;");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M21.532,7.842l-5.145-5.248c-1.295,1.295-2.096,3.083-2.096,5.06c0,3.953,3.286,7.156,7.238,7.156l0.002-6.968z");
        element4.setAttribute("style", "fill:#0066CC;");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M21.557,14.81c3.952,0,7.047-3.11,7.047-7.063h-7.047v7.063z");
        element4.setAttribute("style", "fill:#0066CC;");
        element3.appendChild(element4);
        element4 = document.createElement("path");
        element4.setAttribute("d", "M28.604,7.654c0-3.953-3.204-7.156-7.156-7.156c-1.977,0-3.766,0.801-5.061,2.097l5.092,5.278h7.125");
        element4.setAttribute("style", "fill:#99CCFF;");
        element3.appendChild(element4);
    }

    protected void registerEventHandler(Element element, String string, String string2) {
        if (element != null) {
            element.setAttribute(string, string2);
        }
    }

    private void addTitleBarLine(Document document, GraphicAttributes graphicAttributes, Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        Element element2 = document.createElement("polyline");
        element2.setAttribute("class", "st1, keyline");
        stringBuffer.append("0 ");
        stringBuffer.append(n);
        stringBuffer.append(" ");
        stringBuffer.append(graphicAttributes.getGraphicWidth() - 1);
        stringBuffer.append(" ");
        stringBuffer.append(n);
        element2.setAttribute("points", stringBuffer.toString());
        element.appendChild(element2);
    }

    private void addPreferenceIcon(Document document, GraphicAttributes graphicAttributes, Element element) {
        int n = graphicAttributes.getGraphicWidth() - 33;
        Element element2 = document.createElement("use");
        element2.setAttribute("xlink:href", "#preferences");
        element2.setAttribute("x", Integer.toString(n));
        element2.setAttribute("y", Integer.toString(2));
        element2.setAttribute("id", "preferencesIconHoverBox");
        this.registerEventHandler(element2, "onclick", "openPreferencePage()");
        String string = graphicAttributes.getPreferencesIconText();
        if (string != null) {
            element2.setAttribute("onmouseover", "PrefFlyOver();");
            element2.setAttribute("onmouseout", "PrefFlyOut();");
        }
        element.appendChild(element2);
        if (string != null) {
            Element element3 = document.createElement("g");
            element3.setAttribute("id", "preferencesHoverText");
            element3.setAttribute("pointer-events", "none");
            element2 = document.createElement("rect");
            element2.setAttribute("id", "hoverBox");
            element2.setAttribute("width", "1");
            element2.setAttribute("height", "1");
            element2.setAttribute("fill", "#FFFFCC");
            element2.setAttribute("stroke", "black");
            element2.setAttribute("stroke-width", "1");
            element3.appendChild(element2);
            element2 = document.createElement("text");
            element2.setAttribute("id", "hoverBoxText");
            element2.setAttribute("x", Integer.toString(n + 15));
            element2.setAttribute("y", Integer.toString(32));
            element2.setAttribute("class", "timeStamp");
            element2.setAttribute("visibility", "hidden");
            element2.appendChild(document.createTextNode(string));
            element3.appendChild(element2);
            element.appendChild(element3);
        }
    }

    private void addTitle(Document document, GraphicAttributes graphicAttributes, Element element) {
        int n = 11;
        String string = graphicAttributes.getGraphicTitle();
        if (string != null) {
            String string2 = "graphTitle anchorAtStart";
            Element element2 = document.createElement("g");
            element2.setAttribute("id", "graphTitle");
            element2.setAttribute("class", string2);
            element.appendChild(element2);
            this.addLabel(document, graphicAttributes, element2, string, null, 10.0, n + 8, 0);
        }
    }

    protected Element addHoverText(Document document, GraphicAttributes graphicAttributes, int n, Element element, String string, String string2, double d, double d2, int n2) {
        Element element2 = this.createDOMTextElement(document, graphicAttributes.getGraphicFont(), string, null, Double.toString(d), Double.toString(d2), n2);
        int n3 = graphicAttributes.getGraphicWidth() - 15;
        element2.setAttribute("id", "legent" + n);
        element2.setAttribute("onmouseover", "FlyOver(" + n + ");");
        element2.setAttribute("onmouseout", "FlyOut(" + n + ");");
        element.appendChild(element2);
        if (string2 != null) {
            Element element3 = document.createElement("g");
            element3.setAttribute("id", "flyOverGroup" + n);
            element3.setAttribute("pointer-events", "none");
            element2 = document.createElement("rect");
            element2.setAttribute("id", "flyOverBox" + n);
            element2.setAttribute("width", "1");
            element2.setAttribute("height", "1");
            element2.setAttribute("fill", "#FFFFCC");
            element2.setAttribute("stroke", "gray");
            element2.setAttribute("stroke-width", "1");
            element3.appendChild(element2);
            element2 = document.createElement("text");
            element2.setAttribute("id", "flyOverText" + n);
            element2.setAttribute("x", Double.toString(n3));
            element2.setAttribute("y", Double.toString(d2));
            element2.setAttribute("class", "dataValues anchorAtEnd");
            element2.setAttribute("visibility", "hidden");
            element2.appendChild(document.createTextNode(string2));
            element3.appendChild(element2);
            element.appendChild(element3);
        }
        return element2;
    }

    public String[] getLegendFlyOverLabels(DataSet[] dataSetArray) {
        String[] stringArray = null;
        stringArray = new String[dataSetArray.length];
        int n = 0;
        while (n < dataSetArray.length) {
            stringArray[n] = dataSetArray[n].getFlyoverLabel();
            if (stringArray[n] == null) {
                stringArray[n] = "";
            }
            ++n;
        }
        return stringArray;
    }

    protected double getMaxLengthOfLegendLabel(GraphicAttributes graphicAttributes, DataSet[] dataSetArray) {
        int n = 0;
        String string = graphicAttributes.getGraphicLegendTitle();
        if (string != null && (n = string.length() - 2) < 0) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < dataSetArray.length) {
            int n3;
            DataSet dataSet = dataSetArray[n2];
            String string2 = dataSet.getLabel();
            if (string2 != null && n < (n3 = string2.length())) {
                n = n3;
            }
            ++n2;
        }
        return 16.0 + (double)n * 7.0;
    }
}

