/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui;

import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUI;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationDescriptorFilter;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.ui.PlatformUI;

public class TestUIExtension {
    public static final String GENERIC_TEST_SUITE_TYPE = "org.eclipse.hyades.testSuite.generic";
    public static final String GENERIC_TEST_SUITE_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.TestSuiteEditorPart";
    public static final String GENERIC_TEST_CASE_TYPE = "org.eclipse.hyades.testCase.generic";
    public static final String DEPLOYMENT_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DeploymentEditorPart";
    public static final String EXECUTION_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.ExecutionEditorPart";
    public static final String GENERIC_DATAPOOL_TYPE = "org.eclipse.hyades.datapool.generic";
    public static final String GENERIC_DATAPOOL_EDITOR_PART_ID = "org.eclipse.hyades.test.ui.editor.DatapoolEditorPart";
    private static IAssociationMappingRegistry testSuiteMappingRegistry;
    private static IAssociationMappingRegistry testCaseMappingRegistry;
    private static IAssociationMappingRegistry deploymentMappingRegistry;
    private static IAssociationMappingRegistry executionMappingRegistry;
    private static IAssociationMappingRegistry datapoolMappingRegistry;

    static void dispose() {
        if (testSuiteMappingRegistry != null) {
            testSuiteMappingRegistry.dispose();
        }
        if (testCaseMappingRegistry != null) {
            testCaseMappingRegistry.dispose();
        }
        if (deploymentMappingRegistry != null) {
            deploymentMappingRegistry.dispose();
        }
    }

    public static IAssociationMappingRegistry getTestSuiteMappingRegistry() {
        if (testSuiteMappingRegistry == null) {
            testSuiteMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            testSuiteMappingRegistry.initialize("testsuite", (IAssociationDescriptorFilter)new TestSuiteDescriptorFilter(), TestUIPlugin.getInstance().getPreferenceStore());
            testSuiteMappingRegistry.retrieveAssociationMapping("typeDescriptions", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("typeValidators", HyadesUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("generateWizards", TestUIPlugin.getID());
            testSuiteMappingRegistry.retrieveAssociationMapping("runWizards", TestUIPlugin.getID());
        }
        return testSuiteMappingRegistry;
    }

    public static IAssociationMappingRegistry getTestCaseMappingRegistry() {
        if (testCaseMappingRegistry == null) {
            testCaseMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            testCaseMappingRegistry.initialize("testcase", (IAssociationDescriptorFilter)new TestCaseDescriptorFilter(), TestUIPlugin.getInstance().getPreferenceStore());
            testCaseMappingRegistry.retrieveAssociationMapping("newTestCaseWizards", TestUIPlugin.getID());
            testCaseMappingRegistry.retrieveAssociationMapping("typeDescriptions", HyadesUIPlugin.getID());
            testCaseMappingRegistry.retrieveAssociationMapping("generateWizards", TestUIPlugin.getID());
            testCaseMappingRegistry.retrieveAssociationMapping("runWizards", TestUIPlugin.getID());
        }
        return testCaseMappingRegistry;
    }

    public static IAssociationMappingRegistry getDeploymentMappingRegistry() {
        if (deploymentMappingRegistry == null) {
            deploymentMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            deploymentMappingRegistry.initialize("deploy", (IAssociationDescriptorFilter)new DeploymentDescriptorFilter(), TestUIPlugin.getInstance().getPreferenceStore());
            deploymentMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return deploymentMappingRegistry;
    }

    public static IAssociationMappingRegistry getExecutionMappingRegistry() {
        if (executionMappingRegistry == null) {
            executionMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            executionMappingRegistry.initialize("execution", (IAssociationDescriptorFilter)new ExecutionDescriptorFilter(), TestUIPlugin.getInstance().getPreferenceStore());
            executionMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return executionMappingRegistry;
    }

    public static IAssociationMappingRegistry getDatapoolMappingRegistry() {
        if (datapoolMappingRegistry == null) {
            datapoolMappingRegistry = HyadesUI.createAssociationMappingRegistry();
            datapoolMappingRegistry.initialize("datapool", (IAssociationDescriptorFilter)new DatapoolDescriptorFilter(), TestUIPlugin.getInstance().getPreferenceStore());
            datapoolMappingRegistry.retrieveAssociationMapping("editorExtensions", HyadesUIPlugin.getID());
        }
        return datapoolMappingRegistry;
    }

    public static synchronized void registerTestSuiteType(String string) {
        if (string == null) {
            return;
        }
        IAssociationMapping iAssociationMapping = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeDescriptions");
        if (iAssociationMapping.getAssociationDescriptors(string).length == 0) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
            iAssociationDescriptor.setExtension("testsuite");
            iAssociationDescriptor.addType(string);
        }
    }

    public static synchronized void registerTestCaseType(String string) {
        if (string == null) {
            return;
        }
        IAssociationMapping iAssociationMapping = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping("typeDescriptions");
        if (iAssociationMapping.getAssociationDescriptors(string).length == 0) {
            IAssociationDescriptor iAssociationDescriptor = iAssociationMapping.createAssociationDescriptor();
            iAssociationDescriptor.setExtension("testcase");
            iAssociationDescriptor.addType(string);
        }
    }

    private static class DatapoolDescriptorFilter
    implements IAssociationDescriptorFilter {
        private DatapoolDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping iAssociationMapping, IAssociationDescriptor iAssociationDescriptor) {
            if (!"datapool".equals(iAssociationDescriptor.getExtension())) {
                return false;
            }
            String string = iAssociationMapping.getExtensionPoint();
            if ("editorExtensions".equals(string) && iAssociationDescriptor.getImageDescriptor() == null) {
                iAssociationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class ExecutionDescriptorFilter
    implements IAssociationDescriptorFilter {
        private ExecutionDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping iAssociationMapping, IAssociationDescriptor iAssociationDescriptor) {
            if (!"execution".equals(iAssociationDescriptor.getExtension())) {
                return false;
            }
            String string = iAssociationMapping.getExtensionPoint();
            if ("editorExtensions".equals(string) && iAssociationDescriptor.getImageDescriptor() == null) {
                iAssociationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class DeploymentDescriptorFilter
    implements IAssociationDescriptorFilter {
        private DeploymentDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping iAssociationMapping, IAssociationDescriptor iAssociationDescriptor) {
            if (!"deploy".equals(iAssociationDescriptor.getExtension())) {
                return false;
            }
            String string = iAssociationMapping.getExtensionPoint();
            if ("editorExtensions".equals(string) && iAssociationDescriptor.getImageDescriptor() == null) {
                iAssociationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
            }
            return true;
        }
    }

    private static class TestCaseDescriptorFilter
    implements IAssociationDescriptorFilter {
        private TestCaseDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping iAssociationMapping, IAssociationDescriptor iAssociationDescriptor) {
            boolean bl = "newTestCaseWizards".equals(iAssociationMapping.getExtensionPoint());
            boolean bl2 = "testcase".equals(iAssociationDescriptor.getExtension());
            return bl2 || bl;
        }
    }

    private static class TestSuiteDescriptorFilter
    implements IAssociationDescriptorFilter {
        private TestSuiteDescriptorFilter() {
        }

        public boolean isValid(IAssociationMapping iAssociationMapping, IAssociationDescriptor iAssociationDescriptor) {
            if (!"testsuite".equals(iAssociationDescriptor.getExtension())) {
                return false;
            }
            String string = iAssociationMapping.getExtensionPoint();
            if ("typeDescriptions".equals(string)) {
                if (iAssociationDescriptor.applyToAllTypes()) {
                    return false;
                }
                if (iAssociationDescriptor.types().length != 1) {
                    return false;
                }
            } else if ("editorExtensions".equals(string)) {
                if (iAssociationDescriptor.getImageDescriptor() == null) {
                    iAssociationDescriptor.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
                }
            } else if ("typeValidators".equals(string) ? iAssociationDescriptor.applyToAllTypes() : ("generateWizards".equals(string) ? iAssociationDescriptor.applyToAllTypes() : "runWizards".equals(string) && iAssociationDescriptor.applyToAllTypes())) {
                return false;
            }
            return true;
        }
    }
}

