/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.Vector;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.DPLVariable;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataPoolColumnDialog
extends Dialog
implements KeyListener,
SelectionListener {
    private static final String TAG_VARIABLES = "variables";
    private static final int HEIGHT = 80;
    private static final int WIDTH = 300;
    private Shell shell = null;
    private DPLDatapool datapool = null;
    private String title = null;
    private DPLVariable selectedVariable = null;
    private DPLVariable previousVariable = null;
    private Text nameField = null;
    private Text typeField = null;
    private Color nameFieldForeground = null;
    private Combo insertionVariables = null;
    private String name = null;
    private String type = null;
    private String insertionVariableID = null;

    public DataPoolColumnDialog(Shell shell, DPLDatapool dPLDatapool, DPLVariable dPLVariable, DPLVariable dPLVariable2, String string) {
        super(shell);
        this.shell = shell;
        this.datapool = dPLDatapool;
        this.title = string;
        this.selectedVariable = dPLVariable;
        this.previousVariable = dPLVariable2;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.enableOK();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        this.getShell().setText(this.title);
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 80;
        gridData.widthHint = 300;
        composite2.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(TestUIPlugin.getString("DATA_COL_DLG_NAME"));
        this.nameField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 200;
        this.nameField.setLayoutData((Object)gridData);
        this.nameField.addKeyListener((KeyListener)this);
        this.nameFieldForeground = this.nameField.getForeground();
        Label label2 = new Label(composite2, 0);
        label2.setText(TestUIPlugin.getString("DATA_COL_DLG_TYPE"));
        this.typeField = new Text(composite2, 2052);
        gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        this.typeField.setLayoutData((Object)gridData);
        this.typeField.addKeyListener((KeyListener)this);
        DPLVariable[] dPLVariableArray = this.getVariables(null);
        if (this.selectedVariable != null) {
            this.name = this.selectedVariable.getName();
            this.nameField.setText(this.name);
            this.nameField.setSelection(this.name.length() + 1);
            if (this.selectedVariable.getType() != null) {
                this.type = this.selectedVariable.getType();
                this.typeField.setText(this.type);
                this.typeField.setSelection(this.type.length() + 1);
            }
        }
        String[] stringArray = this.getVariableLabels(dPLVariableArray);
        Label label3 = new Label(composite2, 0);
        if (this.title.equals(TestUIPlugin.getString("DATA_COL_DLG_TITLE_INS"))) {
            label3.setText(TestUIPlugin.getString("DATA_COL_DLG_INS"));
        } else {
            label3.setText(TestUIPlugin.getString("DATA_COL_DLG_MOVE"));
        }
        this.insertionVariables = new Combo(composite2, 12);
        this.insertionVariables.setItems(stringArray);
        this.insertionVariables.setData(TAG_VARIABLES, (Object)dPLVariableArray);
        this.insertionVariables.setLayoutData((Object)new GridData(256));
        this.insertionVariables.addSelectionListener((SelectionListener)this);
        if (this.previousVariable != null) {
            int n = this.findVariableIndexInCombo(dPLVariableArray, this.previousVariable);
            this.insertionVariables.select(n);
            this.insertionVariableID = dPLVariableArray[n].getId();
        } else {
            this.insertionVariables.select(this.insertionVariables.getItemCount() - 1);
            this.insertionVariableID = new String();
        }
        return composite2;
    }

    private boolean enableOK() {
        if (this.nameField.getText().length() > 0) {
            if (this.isNameUnique(this.nameField.getText())) {
                this.nameField.setForeground(this.nameFieldForeground);
                this.getButton(0).setEnabled(true);
                return true;
            }
            Display display = Display.getDefault();
            Color color = display.getSystemColor(3);
            this.nameField.setForeground(color);
        }
        this.getButton(0).setEnabled(false);
        return false;
    }

    private DPLVariable[] getVariables(String string) {
        Object object;
        int n = this.datapool.getVariables().size();
        Vector<DPLVariable> vector = new Vector<DPLVariable>();
        int n2 = 0;
        while (n2 < n) {
            DPLVariable dPLVariable = (DPLVariable)this.datapool.getVariables().get(n2);
            object = dPLVariable.getId();
            if (!((String)object).equals(string)) {
                vector.add(dPLVariable);
            }
            ++n2;
        }
        int n3 = vector.size();
        object = new DPLVariable[n3];
        vector.toArray((T[])object);
        return object;
    }

    private String[] getVariableLabels(DPLVariable[] dPLVariableArray) {
        if (dPLVariableArray == null) {
            return null;
        }
        int n = dPLVariableArray.length;
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            DPLVariable dPLVariable = dPLVariableArray[n2];
            stringArray[n2] = dPLVariable.getName() + TestUIPlugin.getString("DATA_EDT_DIVIDER") + dPLVariable.getType();
            ++n2;
        }
        stringArray[n] = TestUIPlugin.getString("DATA_COL_DLG_HEAD_VAR");
        return stringArray;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getInsertionVariableID() {
        return this.insertionVariableID;
    }

    private int findVariableIndexInCombo(DPLVariable[] dPLVariableArray, DPLVariable dPLVariable) {
        if (dPLVariableArray == null || dPLVariable == null) {
            return -1;
        }
        int n = 0;
        while (n < dPLVariableArray.length) {
            if (dPLVariableArray[n].equals(dPLVariable)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private boolean isNameUnique(String string) {
        if (this.datapool == null) {
            return true;
        }
        int n = 0;
        while (n < this.datapool.getVariables().size()) {
            DPLVariable dPLVariable = (DPLVariable)this.datapool.getVariables().get(n);
            if (!dPLVariable.equals(this.selectedVariable) && string.equals(dPLVariable.getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        DPLVariable[] dPLVariableArray;
        Combo combo = (Combo)selectionEvent.widget;
        int n = combo.getSelectionIndex();
        if (n < (dPLVariableArray = (DPLVariable[])combo.getData(TAG_VARIABLES)).length) {
            DPLVariable dPLVariable = dPLVariableArray[n];
            this.insertionVariableID = dPLVariable.getId();
        } else {
            this.insertionVariableID = new String();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.nameField != null) {
            this.name = this.nameField.getText();
        }
        if (this.typeField != null) {
            this.type = this.typeField.getText();
        }
        this.enableOK();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

