/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SectionForm
extends AbstractSectionForm
implements PaintListener {
    private Composite control;
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    protected int widthHint = -1;
    protected int heightHint = -1;

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(this.factory.getBackgroundColor());
        composite2.setForeground(this.factory.getForegroundColor());
        composite2.addPaintListener((PaintListener)this);
        composite2.setLayout((Layout)new FormLayout());
        composite2.setMenu(composite.getMenu());
        Composite composite3 = this.factory.createComposite(composite2);
        this.createFormClient(composite3);
        this.control = composite2;
        return composite2;
    }

    protected void createFormClient(Composite composite) {
        this.factory.createComposite(composite);
    }

    public Control getControl() {
        return this.control;
    }

    protected int getTitleHeight() {
        int n = 0;
        if (this.headingImage != null && !SWT.getPlatform().equals("motif")) {
            n = this.headingImage.getBounds().height;
        }
        GC gC = new GC((Drawable)this.control);
        gC.setFont(this.titleFont);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        gC.dispose();
        int n3 = n2 + this.TITLE_VMARGIN + this.TITLE_VMARGIN;
        return Math.max(n3, n);
    }

    private void paint(Control control, GC gC) {
        Rectangle rectangle = control.getBounds();
        int n = this.getTitleHeight();
        if (this.headingImage != null) {
            Rectangle rectangle2 = this.headingImage.getBounds();
            int n2 = rectangle.width - rectangle2.width;
            int n3 = 0;
            n2 = 0;
            if (this.headingBackground != null) {
                gC.setBackground(this.headingBackground);
                gC.fillRectangle(0, 0, rectangle.width, n);
            }
            if (!SWT.getPlatform().equals("motif")) {
                gC.drawImage(this.headingImage, n2, n3);
            }
            if (this.headingForeground != null) {
                gC.setForeground(this.headingForeground);
            } else {
                gC.setForeground(this.factory.getForegroundColor());
            }
            gC.setFont(this.titleFont);
            gC.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        } else {
            gC.setFont(this.titleFont);
            gC.setBackground(this.factory.getColor("__default__header__"));
            gC.setForeground(this.factory.getForegroundColor());
            gC.drawText(this.getHeadingText(), this.TITLE_HMARGIN, this.TITLE_VMARGIN, true);
        }
    }

    public final void paintControl(PaintEvent paintEvent) {
        if (!this.headingVisible) {
            return;
        }
        GC gC = paintEvent.gc;
        Control control = (Control)paintEvent.widget;
        this.paint(control, gC);
    }

    public void setHeadingVisible(boolean bl) {
        super.setHeadingVisible(bl);
        if (this.control != null) {
            this.control.layout(true);
        }
    }

    public void setHeadingText(String string) {
        super.setHeadingText(string);
        if (this.control != null) {
            this.control.layout(true);
            this.control.redraw();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.titleFont = JFaceResources.getHeaderFont();
        if (this.control != null) {
            this.control.layout(true);
            this.control.redraw();
        }
    }

    class FormLayout
    extends Layout {
        FormLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Control control = composite.getChildren()[0];
            Point point = control.computeSize(SectionForm.this.widthHint, SectionForm.this.heightHint, bl);
            if (SectionForm.this.headingVisible) {
                point.y += SectionForm.this.getTitleHeight();
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Control control = composite.getChildren()[0];
            int n = SectionForm.this.headingVisible ? SectionForm.this.getTitleHeight() : 0;
            control.setBounds(rectangle.x, rectangle.y + n, rectangle.width, rectangle.height - n);
        }
    }
}

