/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.recorder.http.ui.preferences;

import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.local.appadapters.RecorderAppAdapterFactory;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.testgen.TestGeneratorFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class HttpRecorderPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text hostName;
    private Text hostPort;
    private Button autoStartAppBtn;
    private Combo recordedAppAdapterCombo;
    private Combo testGeneratorsCombo;
    private Text proxyPort;
    private Button autoStartTestGenBtn;

    public HttpRecorderPreferencePage() {
        this.setPreferenceStore(HttpRecorderPlugin.getDefault().getPreferenceStore());
        this.initializeDefaults();
    }

    private void initializeDefaults() {
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = null;
        try {
            this.setTitle(HttpRecorderPlugin.getResourceString("HTTP_PROXY_RECORD_OPTIONS_TITLE"));
            composite2 = new Composite(composite, 0);
            WorkbenchHelp.setHelp((Control)composite2, (String)"org.eclipse.hyades.execution.recorder.http.HttpRecorderPreferencePage");
            composite2.setLayoutData((Object)new GridData(768));
            RecorderUIUtility.assignGridLayout((Composite)composite2, (int)2, (boolean)false);
            this.createApplicationOptionsGroup(composite2);
            this.createTestGenOptionsGroup(composite2);
            this.createRecorderProxyGroup(composite2);
        }
        catch (RecorderUIUtility.RecorderHarnessUIException recorderHarnessUIException) {
            recorderHarnessUIException.printStackTrace();
        }
        this.setControl((Control)composite);
        return composite;
    }

    private void createRecorderProxyGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.PROXY_RECORDER_LOCAL_PORT_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.proxyPort = RecorderUIUtility.createEditControl((Composite)composite, (String)HttpRecorderPlugin.getPreference("default_proxy_port"), null);
        RecorderUIUtility.layoutControlInGrid((Control)this.proxyPort, (int)1, (int)768);
    }

    private void createApplicationOptionsGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.APPLICATION_ADAPTER_SELECTOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.recordedAppAdapterCombo = new Combo(composite, 12);
        RecorderAppAdapterFactory recorderAppAdapterFactory = RecorderAppAdapterFactory.getInstance();
        String[] stringArray = recorderAppAdapterFactory.getAdapterIDs();
        int n = 0;
        while (n < stringArray.length) {
            String string = recorderAppAdapterFactory.getAdapterName(stringArray[n]);
            this.recordedAppAdapterCombo.add(string);
            if (stringArray[n].compareToIgnoreCase(HttpRecorderPlugin.getPreference("application_under_test")) == 0) {
                this.recordedAppAdapterCombo.select(n);
            }
            ++n;
        }
        this.recordedAppAdapterCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        if (this.recordedAppAdapterCombo.getSelectionIndex() == -1) {
            this.recordedAppAdapterCombo.select(this.recordedAppAdapterCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
        }
        RecorderUIUtility.layoutControlInGrid((Control)this.recordedAppAdapterCombo, (int)1, (int)768);
        RecorderUIUtility.layoutControlInGrid((Control)this.recordedAppAdapterCombo, (int)1, (int)768);
    }

    private void createTestGenOptionsGroup(Composite composite) throws RecorderUIUtility.RecorderHarnessUIException {
        Label label = RecorderUIUtility.createLabel((Composite)composite, (String)HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.TEST_GENERATOR_LABEL"), null);
        RecorderUIUtility.layoutControlInGrid((Control)label, (int)1, (int)128);
        this.testGeneratorsCombo = new Combo(composite, 12);
        TestGeneratorFactory testGeneratorFactory = TestGeneratorFactory.getInstance();
        int n = 0;
        while (n < testGeneratorFactory.getGeneratorIDs().length) {
            String string = testGeneratorFactory.getGeneratorName(testGeneratorFactory.getGeneratorIDs()[n]);
            this.testGeneratorsCombo.add(string);
            if (testGeneratorFactory.getGeneratorIDs()[n].compareToIgnoreCase(HttpRecorderPlugin.getPreference("default_test_generator")) == 0) {
                this.testGeneratorsCombo.select(n);
            }
            ++n;
        }
        this.testGeneratorsCombo.add(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT"));
        if (this.testGeneratorsCombo.getSelectionIndex() == -1) {
            this.testGeneratorsCombo.select(this.testGeneratorsCombo.indexOf(HttpRecorderPlugin.getResourceString("HttpRecorderPreferencePage.NONE_SELECTED_TEXT")));
        }
        RecorderUIUtility.layoutControlInGrid((Control)this.testGeneratorsCombo, (int)1, (int)768);
        RecorderUIUtility.layoutControlInGrid((Control)this.testGeneratorsCombo, (int)1, (int)768);
    }

    public void updateControls() {
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    protected void performApply() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        String string = RecorderAppAdapterFactory.getInstance().getAdapterIDByIndex(this.recordedAppAdapterCombo.getSelectionIndex());
        if (string != null) {
            iPreferenceStore.setValue("application_under_test", string);
        } else {
            iPreferenceStore.setValue("application_under_test", "-1");
        }
        String string2 = TestGeneratorFactory.getInstance().getGeneratorIDByIndex(this.testGeneratorsCombo.getSelectionIndex());
        if (string2 != null) {
            iPreferenceStore.setValue("default_test_generator", string2);
        } else {
            iPreferenceStore.setValue("default_test_generator", "-1");
        }
        iPreferenceStore.setValue("default_proxy_port", this.proxyPort.getText());
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    class SelectionChangeHandler
    implements SelectionListener {
        SelectionChangeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            HttpRecorderPreferencePage.this.updateControls();
        }
    }
}

