/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.wizard.RunWizard;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.misc.ResourceAndContainerGroup;

public class RunDestinationPage
extends WizardPage
implements Listener {
    private ResourceAndContainerGroup containerSelectionGroup;
    private IContainer initialContainer;

    public RunDestinationPage() {
        super("location");
        this.setTitle(TestUIPlugin.getString((String)"RUN_WTITLE"));
        this.setDescription(TestUIPlugin.getString((String)"RUN_LDESC"));
    }

    public void setInitialDestination(IContainer iContainer) {
        this.initialContainer = iContainer;
    }

    public void createControl(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createFill());
        this.containerSelectionGroup = new ResourceAndContainerGroup(composite2, (Listener)this, TestUIPlugin.getString((String)"LOCATION_OUTPUT_LABEL"), "file", true, gridData.heightHint);
        this.containerSelectionGroup.setResource(((RunWizard)this.getWizard()).getExecutionResultInitialName());
        if (this.initialContainer != null) {
            this.containerSelectionGroup.setContainerFullPath(this.initialContainer.getFullPath());
        }
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestCommonPlugin.getID() + ".addb0003"));
        WorkbenchHelp.setHelp((Control)composite2, (String)(TestCommonPlugin.getID() + ".addb0004"));
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    public String getExecutionResultName() {
        return this.containerSelectionGroup.getResource().trim();
    }

    public IPath getContainerPath() {
        return this.containerSelectionGroup.getContainerFullPath();
    }

    protected boolean validatePage() {
        IPath iPath = this.containerSelectionGroup.getContainerFullPath();
        if (iPath == null || iPath.segmentCount() == 0) {
            this.setErrorMessage(TestUIPlugin.getString((String)"RUN_LOC_NOCONT"));
            return false;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(iPath.segment(0)) == null) {
            this.setErrorMessage(TestUIPlugin.getString((String)"RUN_LOC_NOCONT"));
            return false;
        }
        String string = this.getExecutionResultName();
        if (string.length() == 0) {
            this.setErrorMessage(TestUIPlugin.getString((String)"RUN_LOC_EMPTY_NAME"));
            return false;
        }
        if (string.indexOf("\\") >= 0 || string.indexOf("/") >= 0) {
            this.setErrorMessage(TestUIPlugin.getString((String)"RUN_LOC_INVALID_NAME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

