/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.control;

import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.edit.datapool.IDatapoolCell;
import org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass;
import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.edit.datapool.IDatapoolSuggestedType;
import org.eclipse.hyades.edit.datapool.IDatapoolVariable;
import org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord;
import org.eclipse.hyades.test.ui.datapool.DatapoolPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.DeleteRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.EditRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertColumnAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowAction;
import org.eclipse.hyades.test.ui.datapool.internal.action.InsertRowGroupAction;
import org.eclipse.hyades.test.ui.datapool.internal.control.DatapoolTableUtil;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DataPoolColumnDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DataPoolRowDialog;
import org.eclipse.hyades.test.ui.datapool.internal.dialog.DataPoolRowGroupDialog;
import org.eclipse.hyades.test.ui.datapool.internal.interfaces.IDatapoolPart;
import org.eclipse.hyades.test.ui.datapool.internal.util.TypeChecker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class DatapoolTable
implements IMenuListener,
SelectionListener,
IDatapoolListener {
    private static final String START_LITERAL = "<Literal>";
    private static final String END_LITERAL = "</Literal>";
    private static final String TAG_DATA = "data";
    private static final String TAG_RECORD = "record";
    private static final String TAG_VARIABLE = "variable";
    private static final String TAG_VARIABLE_INDEX = "variableIndex";
    private static final String TAG_EQUIVALENCE_CLASS = "equivalenceClass";
    private static final int MAX_TABLE_WIDTH = 60000;
    private static final int MAX_TABLE_HEIGHT = 120000;
    private IDatapool datapool = null;
    private Table table = null;
    private DatapoolTableUtil tableUtil = null;
    private TableViewer viewer = null;
    private Composite parent = null;
    private Menu contextMenu = null;
    private TableCursor cursor = null;
    private ControlEditor controlEditor = null;
    private IDatapoolPart datapoolPart = null;
    private IDatapoolFactory datapoolFactory = null;
    private Text textEditor = null;
    boolean ignoreECNotification = false;
    private FocusListener focusListener;
    private ICellEditorListener cellEditorListener;
    private SelectionListener headerListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                return;
            }
            if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                DatapoolTable.this.textEditor.dispose();
            }
            TableColumn tableColumn = (TableColumn)selectionEvent.widget;
            DatapoolTable.this.editColumnAux(tableColumn);
        }
    };
    private ControlListener resizeListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            DatapoolTable.this.resetScrollBarSize(true);
        }
    };
    private ControlListener resizeColumnListener = new ControlAdapter(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed() && DatapoolTable.this.table.getSelectionIndex() >= 0) {
                DatapoolTable.this.cursor.setSelection(DatapoolTable.this.table.getSelectionIndex(), DatapoolTable.this.cursor.getColumn());
            }
            DatapoolTable.this.resetScrollBarSize(false);
        }
    };
    private InsertRowAction insertRowAction = null;
    private DeleteRowAction deleteRowAction = null;
    private EditRowAction editRowAction = null;
    private InsertColumnAction insertColumnAction = null;
    private DeleteColumnAction deleteColumnAction = null;
    private EditColumnAction editColumnAction = null;
    private InsertRowGroupAction insertRowGroupAction = null;
    private DeleteRowGroupAction deleteRowGroupAction = null;
    private EditRowGroupAction editRowGroupAction = null;

    public DatapoolTable(Composite composite, IDatapoolPart iDatapoolPart, IDatapool iDatapool, IDatapoolFactory iDatapoolFactory) {
        if (composite == null || iDatapool == null || iDatapoolPart == null || iDatapoolFactory == null) {
            return;
        }
        this.datapool = iDatapool;
        this.parent = composite;
        this.datapoolFactory = iDatapoolFactory;
        this.setWaitCursor();
        this.datapoolPart = iDatapoolPart;
        this.createTable(composite);
        this.tableUtil = new DatapoolTableUtil(this.table);
        MenuManager menuManager = new MenuManager("#DatapoolEditor");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(this.contextMenu);
        this.table.addSelectionListener((SelectionListener)this);
        this.makeActions();
        iDatapool.addDatapoolListener((IDatapoolListener)this);
        try {
            composite.getParent().getParent().addControlListener(this.resizeListener);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.unsetWaitCursor();
    }

    private void createTable(Composite composite) {
        this.table = new Table(composite, 67584);
        this.viewer = new TableViewer(this.table);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 60000;
        gridData.heightHint = 120000;
        this.table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, false));
        this.table.setLayout((Layout)tableLayout);
        if (this.isWithoutColumns()) {
            this.makeHeaderColumn();
        } else {
            this.makeColumns();
        }
        if (!this.isWithoutRows()) {
            this.makeRows();
        }
        this.createCursor();
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 262144 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (keyEvent.keyCode == 131072 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 262144 && (keyEvent.stateMask & 0x40000) != 0) {
                    return;
                }
                if (keyEvent.keyCode != 131072 && (keyEvent.stateMask & 0x20000) != 0) {
                    return;
                }
                if (DatapoolTable.this.table.getItemCount() != 0) {
                    TableItem[] tableItemArray = DatapoolTable.this.table.getSelection();
                    TableItem tableItem = tableItemArray.length == 0 ? DatapoolTable.this.table.getItem(DatapoolTable.this.table.getTopIndex()) : tableItemArray[0];
                    DatapoolTable.this.table.showItem(tableItem);
                    if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                        DatapoolTable.this.cursor.setSelection(tableItem, 0);
                        DatapoolTable.this.cursor.setVisible(true);
                        DatapoolTable.this.cursor.setFocus();
                    }
                }
            }
        });
    }

    private void createCursor() {
        if (this.datapool.getEquivalenceClassCount() == 0) {
            return;
        }
        this.cursor = new TableCursor(this.table, 0);
        this.controlEditor = new ControlEditor((Composite)this.cursor);
        this.controlEditor.grabHorizontal = true;
        this.controlEditor.grabVertical = true;
        this.cursor.setMenu(this.contextMenu);
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                    return;
                }
                if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                    DatapoolTable.this.textEditor.dispose();
                }
                DatapoolTable.this.table.setSelection(new TableItem[]{DatapoolTable.this.cursor.getRow()});
                DatapoolTable.this.setScrollBars();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                    return;
                }
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n = DatapoolTable.this.cursor.getColumn();
                if (n == 0) {
                    DatapoolTable.this.editRowAux(DatapoolTable.this.cursor.getRow());
                    return;
                }
                DatapoolTable.this.textEditor.setText(tableItem.getText(n));
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.textEditor.addFocusListener((FocusListener)new TableCellFocusAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }
        });
        this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                    return;
                }
                if (keyEvent.keyCode == 0x1000009 && (keyEvent.stateMask & 0x40000) != 0) {
                    int n2 = DatapoolTable.this.cursor.getColumn();
                    if (n2 == 0) {
                        DatapoolTable.this.insertRowGroup();
                    }
                    if (n2 > 0) {
                        DatapoolTable.this.insertColumn();
                    }
                    return;
                }
                if (keyEvent.keyCode == 127 && (keyEvent.stateMask & 0x40000) != 0) {
                    int n3 = DatapoolTable.this.cursor.getColumn();
                    if (n3 == 0) {
                        DatapoolTable.this.deleteRowGroup();
                    }
                    if (n3 > 0) {
                        DatapoolTable.this.deleteColumn();
                    }
                    return;
                }
                if (keyEvent.keyCode == 27 || keyEvent.keyCode == 13 || keyEvent.keyCode == 65536 || keyEvent.keyCode == 0x1000006 || keyEvent.keyCode == 0x1000005 || keyEvent.keyCode == 0x1000007 || keyEvent.keyCode == 0x1000008 || keyEvent.keyCode == 262144 || keyEvent.keyCode == 131072 || (keyEvent.stateMask & 0x40000) != 0 || (keyEvent.stateMask & 0x10000) != 0 || keyEvent.keyCode == 0x100000A || keyEvent.keyCode >= 0x100000C && keyEvent.keyCode <= 0x1000015) {
                    return;
                }
                if (keyEvent.keyCode == 0x1000009) {
                    n = DatapoolTable.this.cursor.getColumn();
                    if (n == 0) {
                        DatapoolTable.this.insertRow();
                    }
                    if (n <= 0) {
                        return;
                    }
                }
                if (keyEvent.keyCode == 127) {
                    n = DatapoolTable.this.cursor.getColumn();
                    if (n == 0) {
                        DatapoolTable.this.deleteRow();
                    }
                    if (n > 0) {
                        DatapoolTable.this.clearCell();
                    }
                    return;
                }
                if (keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                    int n4;
                    if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                        DatapoolTable.this.textEditor.dispose();
                    }
                    n = DatapoolTable.this.cursor.getColumn();
                    int n5 = DatapoolTable.this.table.getSelectionIndex();
                    if (keyEvent.keyCode == 0x1000004 && n > (n4 = DatapoolTable.this.tableUtil.getColumnCount()) - 1) {
                        DatapoolTable.this.cursor.setSelection(n5, n - 1);
                    }
                    return;
                }
                n = keyEvent.character;
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n6 = DatapoolTable.this.cursor.getColumn();
                if (n6 == 0) {
                    DatapoolTable.this.editRowAux(DatapoolTable.this.cursor.getRow());
                    return;
                }
                if (keyEvent.keyCode == 8) {
                    DatapoolTable.this.textEditor.setText(new String());
                } else if (keyEvent.keyCode == 0x100000B) {
                    DatapoolTable.this.textEditor.setText(tableItem.getText(n6));
                } else {
                    DatapoolTable.this.textEditor.setText(String.valueOf((char)n));
                }
                DatapoolTable.this.textEditor.setSelection(DatapoolTable.this.textEditor.getText().length() + 1);
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n6));
                DatapoolTable.this.textEditor.addFocusListener((FocusListener)new TableCellFocusAdaptor(DatapoolTable.this.textEditor, tableItem, n6));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }
        });
        this.cursor.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                    return;
                }
                DatapoolTable.this.textEditor = new Text((Composite)DatapoolTable.this.cursor, 0);
                TableItem tableItem = DatapoolTable.this.cursor.getRow();
                int n = DatapoolTable.this.cursor.getColumn();
                if (n == 0) {
                    DatapoolTable.this.editRowAux(tableItem);
                    return;
                }
                DatapoolTable.this.textEditor.setText(tableItem.getText(n));
                DatapoolTable.this.textEditor.setSelection(DatapoolTable.this.textEditor.getText().length() + 1);
                DatapoolTable.this.textEditor.addKeyListener((KeyListener)new TableCellKeyAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.textEditor.addFocusListener((FocusListener)new TableCellFocusAdaptor(DatapoolTable.this.textEditor, tableItem, n));
                DatapoolTable.this.controlEditor.setEditor((Control)DatapoolTable.this.textEditor);
                DatapoolTable.this.textEditor.setFocus();
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    DatapoolTable.this.contextMenu.setEnabled(true);
                    DatapoolTable.this.contextMenu.setVisible(true);
                }
                if (mouseEvent.button != 1) {
                    return;
                }
                if (DatapoolTable.this.textEditor != null && !DatapoolTable.this.textEditor.isDisposed()) {
                    DatapoolTable.this.textEditor.dispose();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        if (this.table.getItemCount() > 0) {
            this.table.select(0);
            this.cursor.setSelection(0, 0);
        }
    }

    private void setWaitCursor() {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Cursor cursor = new Cursor((Device)display, 1);
        this.setDisplayCursor(cursor);
    }

    private void unsetWaitCursor() {
        this.setDisplayCursor(null);
    }

    private void setDisplayCursor(Cursor cursor) {
        if (this.parent == null) {
            return;
        }
        Display display = this.parent.getShell().getDisplay();
        Shell[] shellArray = display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            shellArray[n].setCursor(cursor);
            ++n;
        }
    }

    private void applyEditingValue(String string) {
        if (this.cursor != null && this.cursor.getColumn() > 0) {
            TableItem tableItem = this.cursor.getRow();
            int n = this.cursor.getColumn();
            if (tableItem == null || tableItem.isDisposed()) {
                return;
            }
            IDatapoolCell[] iDatapoolCellArray = (IDatapoolCell[])tableItem.getData(TAG_DATA);
            IDatapoolCell iDatapoolCell = iDatapoolCellArray[this.cursor.getColumn() - 1];
            if (iDatapoolCell == null) {
                return;
            }
            if (string.equals(iDatapoolCell.getStringValue())) {
                if (this.textEditor != null && !this.textEditor.isDisposed()) {
                    this.textEditor.dispose();
                }
                return;
            }
            iDatapoolCell.setCellValue((Object)string);
            tableItem.setText(this.cursor.getColumn(), string);
            this.cursor.setSelection(this.table.getSelectionIndex(), this.cursor.getColumn());
            this.datapoolPart.markDirty();
            if (this.textEditor != null && !this.textEditor.isDisposed()) {
                this.textEditor.dispose();
            }
        }
    }

    private void makeColumns() {
        this.makeHeaderColumn();
        int n = 0;
        while (n < this.datapool.getVariableCount()) {
            TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)this.datapool.getVariable(n);
            tableColumn.setResizable(true);
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
            String string = new String();
            if (iDatapoolSuggestedType != null) {
                // empty if block
            }
            string = iDatapoolSuggestedType.getSuggestedClassName();
            tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
            tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
            tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
            tableColumn.setWidth(100);
            tableColumn.addSelectionListener(this.headerListener);
            tableColumn.addControlListener(this.resizeColumnListener);
            ++n;
        }
    }

    private void makeHeaderColumn() {
        TableColumn tableColumn = new TableColumn(this.table, 0, 0);
        tableColumn.setResizable(true);
        tableColumn.setWidth(100);
        tableColumn.setData(TAG_VARIABLE, null);
        tableColumn.addControlListener(this.resizeColumnListener);
    }

    private void makeRows() {
        int n = 0;
        while (n < this.datapool.getEquivalenceClassCount()) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
            int n2 = 0;
            while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
                IDatapoolCell iDatapoolCell;
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
                int n3 = iDatapoolRecord.getCellCount();
                String[] stringArray = new String[this.datapool.getVariableCount() + 1];
                IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.datapool.getVariableCount()];
                stringArray[0] = iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2);
                int n4 = 0;
                while (n4 < n3) {
                    iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
                    IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapoolCell.getCellVariable();
                    int n5 = this.findColumnIndex(iDatapoolVariable.getName());
                    String string = new String();
                    if (iDatapoolCell.getStringValue() != null) {
                        string = iDatapoolCell.getStringValue();
                    }
                    stringArray[n5] = string;
                    iDatapoolCellArray[n5 - 1] = iDatapoolCell;
                    ++n4;
                }
                iDatapoolCell = new TableItem(this.table, 0);
                iDatapoolCell.setText(stringArray);
                iDatapoolCell.setData(TAG_DATA, (Object)iDatapoolCellArray);
                iDatapoolCell.setData(TAG_RECORD, (Object)iDatapoolRecord);
                iDatapoolCell.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
                ++n2;
            }
            ++n;
        }
    }

    private boolean isWithoutRows() {
        if (this.datapool.getEquivalenceClassCount() > 0) {
            if (this.datapool.getEquivalenceClassCount() == 1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(0);
                return iDatapoolEquivalenceClass.getRecordCount() == 0;
            }
            return false;
        }
        return true;
    }

    private boolean isWithoutColumns() {
        return this.datapool.getVariableCount() == 0;
    }

    private int findColumnIndex(String string) {
        int n = 0;
        while (n < this.table.getColumnCount()) {
            TableColumn tableColumn = this.table.getColumn(n);
            IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
            if (iDatapoolVariable != null && string.equals(iDatapoolVariable.getName())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void setScrollBars() {
        Point point = this.cursor.getLocation();
        Composite composite = this.parent.getParent().getParent();
        if (composite != null && composite instanceof ScrolledComposite) {
            int n = composite.getBounds().height;
            int n2 = composite.getBounds().width;
            int n3 = point.x - n2 + this.cursor.getBounds().width + 30;
            int n4 = point.y - n + this.cursor.getBounds().height + 53;
            ((ScrolledComposite)composite).setOrigin(n3, n4);
        }
    }

    private void resizeScrollBars() {
        try {
            Composite composite = this.parent.getParent().getParent();
            int n = composite.getHorizontalBar().getMaximum();
            int n2 = composite.getVerticalBar().getMaximum();
            int n3 = composite.getBounds().height;
            int n4 = composite.getBounds().width;
            int n5 = this.table.getBounds().width;
            int n6 = this.table.getBounds().height;
            int n7 = 0;
            int n8 = 68;
            int n9 = 0;
            while (n9 < this.table.getColumnCount()) {
                n7 += this.table.getColumn(n9).getWidth();
                ++n9;
            }
            int n10 = 0;
            while (n10 < this.table.getItemCount()) {
                TableItem tableItem = this.table.getItem(n10);
                n8 += tableItem.getBounds((int)0).height + 1;
                ++n10;
            }
            if (n7 < n4) {
                composite.getHorizontalBar().setVisible(false);
            } else {
                composite.getHorizontalBar().setVisible(true);
                if (n < 119) {
                    composite.getHorizontalBar().setMaximum(n7 - n4 + 44);
                } else {
                    composite.getHorizontalBar().setMaximum(n7 + 12);
                }
            }
            if (n8 < n3) {
                composite.getVerticalBar().setVisible(false);
            } else {
                composite.getVerticalBar().setVisible(true);
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n8 - n3 + 58);
                } else {
                    composite.getVerticalBar().setMaximum(n8 - 12);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void resetScrollBarSize(boolean bl) {
        try {
            Composite composite = this.table.getParent().getParent().getParent();
            int n = composite.getHorizontalBar().getMaximum();
            int n2 = composite.getVerticalBar().getMaximum();
            int n3 = composite.getBounds().height;
            int n4 = composite.getBounds().width;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.table.getColumnCount()) {
                n5 += this.table.getColumn(n7).getWidth();
                ++n7;
            }
            int n8 = 0;
            while (n8 < this.table.getItemCount()) {
                TableItem tableItem = this.table.getItem(n8);
                n6 += tableItem.getBounds((int)0).height + 1;
                ++n8;
            }
            if (n5 + 14 < n4) {
                n5 = 0;
            }
            if (n6 < n3) {
                n6 = 0;
            }
            if (bl) {
                composite.getHorizontalBar().setMaximum(n + n5 - 60000 - 26);
                composite.getVerticalBar().setMaximum(n2 + n6 - 120000 - 4);
            } else {
                if (n < 119) {
                    composite.getHorizontalBar().setMaximum(n5 - n4 + 44);
                } else {
                    composite.getHorizontalBar().setMaximum(n5 + 12);
                }
                if (n2 < 119) {
                    composite.getVerticalBar().setMaximum(n6 - n3 + 58);
                } else {
                    composite.getVerticalBar().setMaximum(n6 - 12);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        int n;
        int n2 = this.table.getSelectionIndex();
        if (this.cursor != null && !this.cursor.isDisposed() && (n = this.cursor.getColumn()) >= 0) {
            this.cursor.setSelection(n2, n);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void makeActions() {
        TableViewer tableViewer = this.viewer;
        this.insertRowAction = new InsertRowAction((ISelectionProvider)tableViewer, this);
        this.deleteRowAction = new DeleteRowAction((ISelectionProvider)tableViewer, this);
        this.editRowAction = new EditRowAction((ISelectionProvider)tableViewer, this);
        this.insertColumnAction = new InsertColumnAction((ISelectionProvider)tableViewer, this);
        this.deleteColumnAction = new DeleteColumnAction((ISelectionProvider)tableViewer, this);
        this.editColumnAction = new EditColumnAction((ISelectionProvider)tableViewer, this);
        this.insertRowGroupAction = new InsertRowGroupAction((ISelectionProvider)tableViewer, this);
        this.deleteRowGroupAction = new DeleteRowGroupAction((ISelectionProvider)tableViewer, this);
        this.editRowGroupAction = new EditRowGroupAction((ISelectionProvider)tableViewer, this);
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        MenuManager menuManager = (MenuManager)iMenuManager;
        menuManager.add((IAction)this.insertRowGroupAction);
        menuManager.add((IAction)this.deleteRowGroupAction);
        menuManager.add((IAction)this.editRowGroupAction);
        menuManager.add((IAction)this.insertRowAction);
        menuManager.add((IAction)this.deleteRowAction);
        menuManager.add((IAction)this.editRowAction);
        menuManager.add((IAction)this.insertColumnAction);
        menuManager.add((IAction)this.deleteColumnAction);
        menuManager.add((IAction)this.editColumnAction);
        int n = 0;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn() == 0 ? 0 : 1;
        }
        if (this.table.getSelectionIndex() == -1) {
            n = 2;
        }
        if (this.datapool.getEquivalenceClassCount() == 0) {
            n = 3;
        }
        if (this.datapool.getEquivalenceClassCount() == 0 && this.datapool.getVariableCount() == 0) {
            n = 4;
        }
        if (this.datapoolPart.isReadOnly()) {
            n = 5;
        }
        switch (n) {
            case 0: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                break;
            }
            case 1: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                break;
            }
            case 5: {
                this.insertRowAction.aboutToShow(false);
                this.deleteRowAction.aboutToShow(false);
                this.editRowAction.aboutToShow(false);
                this.insertRowGroupAction.aboutToShow(false);
                this.deleteRowGroupAction.aboutToShow(false);
                this.editRowGroupAction.aboutToShow(false);
                this.insertColumnAction.aboutToShow(false);
                this.deleteColumnAction.aboutToShow(false);
                this.editColumnAction.aboutToShow(false);
                break;
            }
            default: {
                this.insertRowAction.aboutToShow(true);
                this.deleteRowAction.aboutToShow(true);
                this.editRowAction.aboutToShow(true);
                this.insertRowGroupAction.aboutToShow(true);
                this.deleteRowGroupAction.aboutToShow(true);
                this.editRowGroupAction.aboutToShow(true);
                this.insertColumnAction.aboutToShow(true);
                this.deleteColumnAction.aboutToShow(true);
                this.editColumnAction.aboutToShow(true);
            }
        }
    }

    public void insertRowGroup() {
        DataPoolRowGroupDialog dataPoolRowGroupDialog;
        TableItem tableItem = null;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            tableItem = this.cursor.getRow();
        }
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        if (tableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        if ((dataPoolRowGroupDialog = new DataPoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, iDatapoolEquivalenceClass, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            String string = dataPoolRowGroupDialog.getName();
            if (string != null && string.length() != 0) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = this.datapool.constructEquivalenceClass();
                int n = dataPoolRowGroupDialog.getInsertionIndex();
                this.datapool.insertEquivalenceClass(iDatapoolEquivalenceClass2, n + 1);
                iDatapoolEquivalenceClass2.setName(string);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass2.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass2.insertRecord(iDatapoolRecord, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        this.datapool.removeEquivalenceClass(n);
        this.unsetWaitCursor();
    }

    public void editRowGroup() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowGroupAux(tableItem);
    }

    private void editRowGroupAux(TableItem tableItem) {
        DataPoolRowGroupDialog dataPoolRowGroupDialog;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = null;
        if (tableItem != null) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        }
        int n = -1;
        if (iDatapoolEquivalenceClass != null) {
            n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        }
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        if (n != -1 && n != 0) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n - 1);
        }
        if ((dataPoolRowGroupDialog = new DataPoolRowGroupDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, iDatapoolEquivalenceClass, iDatapoolEquivalenceClass2, DatapoolPlugin.getResourceString("DATA_ROW_GRP_DLG_TITLE_EDIT"))).open() == 0) {
            int n2;
            this.setWaitCursor();
            String string = dataPoolRowGroupDialog.getName();
            if (!iDatapoolEquivalenceClass.getName().equals(string)) {
                iDatapoolEquivalenceClass.setName(string);
            }
            if ((n2 = dataPoolRowGroupDialog.getInsertionIndex()) == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            this.datapool.moveEquivalenceClass(n, n2);
            this.unsetWaitCursor();
        }
    }

    public void insertRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        DataPoolRowDialog dataPoolRowDialog = new DataPoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, null, tableItem, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_INS"));
        if (dataPoolRowDialog.open() == 0) {
            this.setWaitCursor();
            int n = dataPoolRowDialog.getInsertionEquivalenceClassIndex();
            int n2 = dataPoolRowDialog.getInsertionRecordIndex();
            if (n != -1 && n2 != -1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, n2 + 1);
            } else {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
                org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = iDatapoolEquivalenceClass.constructRecord(this.createCells(this.datapool));
                iDatapoolEquivalenceClass.insertRecord(iDatapoolRecord, 0);
            }
            this.unsetWaitCursor();
        }
    }

    public void deleteRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.setWaitCursor();
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
        int n = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
        int n2 = this.getRecordIndex(iDatapoolEquivalenceClass, iDatapoolRecord);
        iDatapoolEquivalenceClass.removeRecord(n2);
        if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
            this.ignoreECNotification = true;
            this.datapool.removeEquivalenceClass(n);
        }
        this.unsetWaitCursor();
    }

    public void editRow() {
        TableItem tableItem = null;
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        tableItem = this.cursor.getRow();
        this.editRowAux(tableItem);
    }

    private void editRowAux(TableItem tableItem) {
        DataPoolRowDialog dataPoolRowDialog;
        int n = this.table.getSelectionIndex();
        TableItem tableItem2 = null;
        if (n != 0) {
            tableItem2 = this.table.getItem(n - 1);
        }
        if ((dataPoolRowDialog = new DataPoolRowDialog(Display.getCurrent().getActiveShell(), this.datapool, this.table, tableItem, tableItem2, DatapoolPlugin.getResourceString("DATA_ROW_DLG_TITLE_EDIT"))).open() == 0) {
            this.setWaitCursor();
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
            int n2 = this.datapool.getEquivalenceClassIndexById(iDatapoolEquivalenceClass.getId());
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)tableItem.getData(TAG_RECORD);
            int n3 = this.getRecordIndex(iDatapoolEquivalenceClass, iDatapoolRecord);
            int n4 = dataPoolRowDialog.getInsertionEquivalenceClassIndex();
            int n5 = dataPoolRowDialog.getInsertionRecordIndex();
            if (n2 == n4) {
                if (n3 != n5 + 1) {
                    if (n5 > n3) {
                        iDatapoolEquivalenceClass.moveRecord(n3, n5);
                    } else {
                        iDatapoolEquivalenceClass.moveRecord(n3, n5 + 1);
                    }
                }
            } else if (n4 != -1 && n5 != -1) {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
                iDatapoolEquivalenceClass.removeRecord(n3);
                iDatapoolEquivalenceClass2.insertRecord(iDatapoolRecord, n5 + 1);
                if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(n2);
                }
            } else {
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass3 = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
                iDatapoolEquivalenceClass.removeRecord(n3);
                iDatapoolEquivalenceClass3.insertRecord(iDatapoolRecord, 0);
                if (iDatapoolEquivalenceClass.getRecordCount() == 0) {
                    this.ignoreECNotification = true;
                    this.datapool.removeEquivalenceClass(n2);
                }
            }
            this.unsetWaitCursor();
        }
    }

    public void insertColumn() {
        DataPoolColumnDialog dataPoolColumnDialog;
        int n = -1;
        if (this.cursor != null && !this.cursor.isDisposed()) {
            n = this.cursor.getColumn();
        }
        TableColumn tableColumn = null;
        if (n > 0) {
            tableColumn = this.table.getColumn(n);
        }
        IDatapoolVariable iDatapoolVariable = null;
        if (tableColumn != null) {
            iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        }
        if ((dataPoolColumnDialog = new DataPoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, null, iDatapoolVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_INS"))).open() == 0) {
            this.setWaitCursor();
            IDatapoolVariable iDatapoolVariable2 = this.datapool.constructVariable();
            iDatapoolVariable2.setName(dataPoolColumnDialog.getName());
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable2.getSuggestedType();
            this.setVariableType(iDatapoolSuggestedType, dataPoolColumnDialog.getType());
            iDatapoolVariable2.setSuggestedType(iDatapoolSuggestedType);
            int n2 = this.findColumnIndex(dataPoolColumnDialog.getInsertionVariableName());
            if (n2 == -1) {
                n2 = 0;
            }
            this.datapool.insertVariable(iDatapoolVariable2, n2);
            this.unsetWaitCursor();
        }
    }

    public void deleteColumn() {
        if (this.cursor == null || this.cursor.isDisposed()) {
            return;
        }
        int n = this.cursor.getColumn();
        int n2 = this.table.getSelectionIndex();
        if (n < 1) {
            return;
        }
        this.setWaitCursor();
        TableColumn tableColumn = this.table.getColumn(n);
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        int n3 = this.datapool.getVariableIndexById(iDatapoolVariable.getId());
        this.datapool.removeVariable(n3);
        this.unsetWaitCursor();
    }

    public void editColumn() {
        int n = this.cursor.getColumn();
        TableColumn tableColumn = this.table.getColumn(n);
        this.editColumnAux(tableColumn);
    }

    private void editColumnAux(TableColumn tableColumn) {
        int n = this.table.indexOf(tableColumn);
        TableColumn tableColumn2 = null;
        if (n != 0) {
            tableColumn2 = this.table.getColumn(n - 1);
        }
        IDatapoolVariable iDatapoolVariable = null;
        if (tableColumn2 != null) {
            iDatapoolVariable = (IDatapoolVariable)tableColumn2.getData(TAG_VARIABLE);
        }
        IDatapoolVariable iDatapoolVariable2 = (IDatapoolVariable)tableColumn.getData(TAG_VARIABLE);
        DataPoolColumnDialog dataPoolColumnDialog = new DataPoolColumnDialog(Display.getCurrent().getActiveShell(), this.datapool, iDatapoolVariable2, iDatapoolVariable, DatapoolPlugin.getResourceString("DATA_COL_DLG_TITLE_EDIT"));
        if (dataPoolColumnDialog.open() == 0) {
            this.setWaitCursor();
            String string = dataPoolColumnDialog.getName();
            String string2 = dataPoolColumnDialog.getType();
            String string3 = dataPoolColumnDialog.getInsertionVariableID();
            String string4 = new String();
            if (iDatapoolVariable != null) {
                string4 = iDatapoolVariable.getId();
            }
            IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable2.getSuggestedType();
            if (string.equals(iDatapoolVariable2.getName()) && string2.equals(iDatapoolSuggestedType.getSuggestedClassName()) && string3.equals(string4)) {
                this.unsetWaitCursor();
                return;
            }
            iDatapoolVariable2.setName(dataPoolColumnDialog.getName());
            this.setVariableType(iDatapoolSuggestedType, dataPoolColumnDialog.getType());
            iDatapoolVariable2.setSuggestedType(iDatapoolSuggestedType);
            Integer n2 = (Integer)tableColumn.getData(TAG_VARIABLE_INDEX);
            int n3 = this.findColumnIndex(dataPoolColumnDialog.getInsertionVariableName());
            if (n3 == n - 1) {
                this.unsetWaitCursor();
                return;
            }
            if (n3 == -1) {
                this.datapool.moveVariable(n - 1, 0);
            } else if (n3 > n) {
                this.datapool.moveVariable(n - 1, n3 - 1);
            } else {
                this.datapool.moveVariable(n - 1, n3);
            }
            this.unsetWaitCursor();
        }
    }

    public void clearCell() {
        this.applyEditingValue(new String());
    }

    public void variableAdded(IDatapool iDatapool, int n) {
        int n2;
        TableColumn tableColumn = new TableColumn(this.table, 0, n + 1);
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n);
        tableColumn.setResizable(true);
        IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
        String string = new String();
        if (iDatapoolSuggestedType != null) {
            string = iDatapoolSuggestedType.getSuggestedClassName();
        }
        tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
        tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.setWidth(100);
        tableColumn.addSelectionListener(this.headerListener);
        tableColumn.addControlListener(this.resizeColumnListener);
        this.tableUtil.insertColumn(tableColumn, n);
        if (this.cursor != null && !this.cursor.isDisposed() && (n2 = this.table.getSelectionIndex()) >= 0) {
            this.table.setSelection(n2);
            this.cursor.setSelection(n2, n + 1);
            this.cursor.setFocus();
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void variableRemoved(IDatapool iDatapool, int n) {
        this.tableUtil.deleteColumn(n + 1);
        if (this.cursor != null && !this.cursor.isDisposed()) {
            if (n > 0) {
                int n2 = this.table.getSelectionIndex();
                if (n2 >= 0) {
                    this.table.select(n2);
                    this.cursor.setSelection(n2, n);
                    this.resizeScrollBars();
                    this.setScrollBars();
                }
            } else {
                this.table.deselectAll();
            }
        }
        this.datapoolPart.markDirty();
    }

    public void variableMoved(IDatapool iDatapool, int n, int n2) {
        int n3;
        this.tableUtil.moveColumn(n + 1, n2 + 1);
        if (this.cursor != null && !this.cursor.isDisposed() && n2 > 0 && (n3 = this.table.getSelectionIndex()) >= 0) {
            this.table.select(n3);
            this.cursor.setSelection(n3, n2);
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void variableChanged(IDatapool iDatapool, int n) {
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n);
        int n2 = this.findColumnIndex(iDatapoolVariable.getName());
        TableColumn tableColumn = this.table.getColumn(n2);
        IDatapoolSuggestedType iDatapoolSuggestedType = (IDatapoolSuggestedType)iDatapoolVariable.getSuggestedType();
        String string = new String();
        if (iDatapoolSuggestedType != null) {
            // empty if block
        }
        string = iDatapoolSuggestedType.getSuggestedClassName();
        tableColumn.setText(iDatapoolVariable.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + string);
        tableColumn.setData(TAG_VARIABLE, (Object)iDatapoolVariable);
        tableColumn.setData(TAG_VARIABLE_INDEX, (Object)new Integer(n));
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassChanged(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        int n2 = 0;
        while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
            int n3 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n3);
            tableItem.setText(0, iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2));
            this.datapoolPart.markDirty();
            ++n2;
        }
    }

    public void equivalenceClassAdded(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = null;
        int n2 = 0;
        if (n > 0) {
            iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n - 1);
            n2 = this.findRowIndex(n - 1, iDatapoolEquivalenceClass2.getRecordCount() - 1) + 1;
        }
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            IDatapoolCell iDatapoolCell;
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n3);
            String[] stringArray = new String[this.table.getColumnCount()];
            IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.table.getColumnCount() - 1];
            stringArray[0] = iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n3);
            int n4 = 0;
            while (n4 < iDatapoolRecord.getCellCount()) {
                iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
                org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable iDatapoolVariable = iDatapoolCell.getCellVariable();
                int n5 = this.findColumnIndex(iDatapoolVariable.getName());
                stringArray[n5] = iDatapoolCell.getStringValue();
                iDatapoolCellArray[n5 - 1] = iDatapoolCell;
                ++n4;
            }
            iDatapoolCell = new TableItem(this.table, 0, n2 + n3);
            iDatapoolCell.setText(stringArray);
            iDatapoolCell.setData(TAG_DATA, (Object)iDatapoolCellArray);
            iDatapoolCell.setData(TAG_RECORD, (Object)iDatapoolRecord);
            iDatapoolCell.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
            ++n3;
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassRemoved(IDatapool iDatapool, int n) {
        if (this.ignoreECNotification) {
            this.ignoreECNotification = false;
            return;
        }
        int n2 = this.findRowIndex(n, 0);
        TableItem tableItem = this.table.getItem(n2);
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
        boolean bl = true;
        while (bl) {
            this.table.remove(n2);
            if (n2 < this.table.getItemCount()) {
                tableItem = this.table.getItem(n2);
                IDatapoolEquivalenceClass iDatapoolEquivalenceClass2 = (IDatapoolEquivalenceClass)tableItem.getData(TAG_EQUIVALENCE_CLASS);
                if (iDatapoolEquivalenceClass2.equals(iDatapoolEquivalenceClass)) continue;
                bl = false;
                continue;
            }
            bl = false;
        }
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n3 = this.table.getItemCount();
            if (n3 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n3 > n2) {
                this.table.setSelection(n2);
                this.cursor.setSelection(n2, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n3 > n2 - 1) {
                this.table.setSelection(n2 - 1);
                this.cursor.setSelection(n2 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void equivalenceClassMoved(IDatapool iDatapool, int n, int n2) {
        int n3;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass;
        if (n == n2) {
            return;
        }
        int n4 = 0;
        if (n2 != -1) {
            iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n2);
            n3 = iDatapoolEquivalenceClass.getRecordCount();
            if (n < n2) {
                --n3;
            }
            n4 = this.findRowIndex(n2, n3);
        }
        iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        n3 = iDatapoolEquivalenceClass.getRecordCount();
        int n5 = this.findRowIndex(n, 0);
        int n6 = 0;
        while (n6 < iDatapoolEquivalenceClass.getRecordCount()) {
            if (n > n2) {
                this.tableUtil.moveRow(n5 + n3 - 1, n4);
            } else {
                this.tableUtil.moveRow(n5, n4);
            }
            ++n6;
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n4);
            this.cursor.setSelection(n4, 0);
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void recordAdded(IDatapool iDatapool, int n, int n2) {
        org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable iDatapoolVariable;
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
        String[] stringArray = new String[this.table.getColumnCount()];
        IDatapoolCell[] iDatapoolCellArray = new IDatapoolCell[this.table.getColumnCount() - 1];
        stringArray[0] = iDatapoolEquivalenceClass.getName() + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n2);
        int n3 = 0;
        while (n3 < iDatapoolRecord.getCellCount()) {
            IDatapoolCell iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n3);
            iDatapoolVariable = iDatapoolCell.getCellVariable();
            int n4 = this.findColumnIndex(iDatapoolVariable.getName());
            stringArray[n4] = iDatapoolCell.getStringValue();
            iDatapoolCellArray[n4 - 1] = iDatapoolCell;
            ++n3;
        }
        int n5 = this.findRowIndex(n, n2);
        iDatapoolVariable = new TableItem(this.table, 0, n5);
        iDatapoolVariable.setText(stringArray);
        iDatapoolVariable.setData(TAG_DATA, (Object)iDatapoolCellArray);
        iDatapoolVariable.setData(TAG_RECORD, (Object)iDatapoolRecord);
        iDatapoolVariable.setData(TAG_EQUIVALENCE_CLASS, (Object)iDatapoolEquivalenceClass);
        this.repopulateRowLabels(n);
        if (this.table.getItemCount() == 1) {
            this.createCursor();
        }
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            this.table.setSelection(n5);
            this.cursor.setSelection(n5, 0);
            this.cursor.setFocus();
            this.resizeScrollBars();
            this.setScrollBars();
        }
        this.datapoolPart.markDirty();
    }

    public void recordRemoved(IDatapool iDatapool, int n, int n2) {
        int n3 = this.findRowIndex(n, n2);
        this.table.remove(n3);
        this.repopulateRowLabels(n);
        this.datapoolPart.markDirty();
        if (this.cursor != null && !this.cursor.isDisposed() && this.table != null) {
            int n4 = this.table.getItemCount();
            if (n4 == 0) {
                this.table.deselectAll();
                this.cursor.dispose();
                return;
            }
            if (n4 > n3) {
                this.table.setSelection(n3);
                this.cursor.setSelection(n3, 0);
                this.resizeScrollBars();
                this.setScrollBars();
                return;
            }
            if (n4 > n3 - 1) {
                this.table.setSelection(n3 - 1);
                this.cursor.setSelection(n3 - 1, 0);
                this.resizeScrollBars();
                this.setScrollBars();
            }
        }
    }

    public void recordMoved(IDatapool iDatapool, int n, int n2, int n3) {
        int n4 = this.findRowIndex(n, n2);
        int n5 = this.findRowIndex(n, n3);
        this.tableUtil.moveRow(n4, n5);
        this.repopulateRowLabels(n);
        this.datapoolPart.markDirty();
    }

    public void cellChanged(IDatapool iDatapool, int n, int n2, int n3) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
        IDatapoolVariable iDatapoolVariable = (IDatapoolVariable)iDatapool.getVariable(n3);
        IDatapoolCell iDatapoolCell = null;
        int n4 = 0;
        while (n4 < iDatapoolRecord.getCellCount()) {
            iDatapoolCell = (IDatapoolCell)iDatapoolRecord.getCell(n4);
            if (iDatapoolCell.getCellVariable().equals(iDatapoolVariable)) break;
            iDatapoolCell = null;
            ++n4;
        }
        if (iDatapoolCell != null) {
            String string = iDatapoolCell.getStringValue();
            int n5 = this.findRowIndex(n, n2);
            TableItem tableItem = this.table.getItem(n5);
            tableItem.setText(n + 1, string);
            this.cursor.setSelection(n5, n + 1);
            this.datapoolPart.markDirty();
        }
        this.datapoolPart.markDirty();
    }

    public void equivalenceClassReordered(IDatapool iDatapool, int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)iDatapool.getEquivalenceClass(n);
        int n2 = 0;
        while (n2 < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)iDatapoolEquivalenceClass.getRecord(n2);
            int n3 = this.findRowIndex(n, n2);
            int n4 = this.findRowIndex(n, iDatapoolRecord);
            this.tableUtil.swapRow(n4, n3);
            ++n2;
        }
        this.datapoolPart.markDirty();
    }

    public void recordChanged(IDatapool iDatapool, int n, int n2) {
    }

    public void save(IDatapool iDatapool) {
        this.datapoolFactory.save(iDatapool);
    }

    private int findRowIndex(int n, org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
        int n2 = this.findRowIndex(n, 0);
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord2 = (org.eclipse.hyades.edit.datapool.IDatapoolRecord)this.table.getItem(n2 + n3).getData(TAG_RECORD);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n2 + n3;
            }
            ++n3;
        }
        return -1;
    }

    private int findRowIndex(int n, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < n) {
            IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n4);
            n3 += iDatapoolEquivalenceClass.getRecordCount();
            ++n4;
        }
        return n3;
    }

    private void repopulateRowLabels(int n) {
        IDatapoolEquivalenceClass iDatapoolEquivalenceClass = (IDatapoolEquivalenceClass)this.datapool.getEquivalenceClass(n);
        String string = iDatapoolEquivalenceClass.getName();
        int n2 = this.findRowIndex(n, 0);
        int n3 = 0;
        while (n3 < iDatapoolEquivalenceClass.getRecordCount()) {
            if (this.table.getItemCount() > n2 + 1) {
                TableItem tableItem = this.table.getItem(n2 + n3);
                tableItem.setText(0, string + DatapoolPlugin.getResourceString("DATA_EDT_DIVIDER") + String.valueOf(n3));
            }
            ++n3;
        }
    }

    private int getRecordIndex(IDatapoolEquivalenceClass iDatapoolEquivalenceClass, org.eclipse.hyades.edit.datapool.IDatapoolRecord iDatapoolRecord) {
        int n = 0;
        while (n < iDatapoolEquivalenceClass.getRecordCount()) {
            IDatapoolRecord iDatapoolRecord2 = iDatapoolEquivalenceClass.getRecord(n);
            if (iDatapoolRecord2.equals(iDatapoolRecord)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private Object[] createCells(IDatapool iDatapool) {
        Object[] objectArray = new Object[iDatapool.getVariableCount()];
        int n = 0;
        while (n < iDatapool.getVariableCount()) {
            objectArray[n] = new String();
            ++n;
        }
        return objectArray;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    private void setVariableType(IDatapoolSuggestedType iDatapoolSuggestedType, String string) {
        if (iDatapoolSuggestedType == null) {
            return;
        }
        if (TypeChecker.getInstance().isBoolean(string)) {
            iDatapoolSuggestedType.setSuggestedType(2);
        } else if (TypeChecker.getInstance().isNumber(string)) {
            iDatapoolSuggestedType.setSuggestedType(1);
        } else if (TypeChecker.getInstance().isString(string)) {
            iDatapoolSuggestedType.setSuggestedType(0);
        } else if (TypeChecker.getInstance().isEnumeration(string)) {
            iDatapoolSuggestedType.setSuggestedType(3);
        } else {
            iDatapoolSuggestedType.setSuggestedType(4);
        }
        iDatapoolSuggestedType.setSuggestedClassName(string);
    }

    class TableCellKeyAdaptor
    implements KeyListener {
        private Text text = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellKeyAdaptor(Text text, TableItem tableItem, int n) {
            this.text = text;
            this.row = tableItem;
            this.column = n;
            if (tableItem != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(tableItem);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (DatapoolTable.this.datapoolPart.isReadOnly()) {
                return;
            }
            if (keyEvent.character == '\r' || keyEvent.keyCode == 0x1000002 || keyEvent.keyCode == 0x1000001 || keyEvent.keyCode == 0x1000003 || keyEvent.keyCode == 0x1000004) {
                this.row.setText(this.column, this.text.getText());
                DatapoolTable.this.applyEditingValue(this.text.getText());
            }
            if (DatapoolTable.this.cursor != null && !DatapoolTable.this.cursor.isDisposed()) {
                if (keyEvent.keyCode == 0x1000002 && this.rowIndex + 1 < DatapoolTable.this.table.getItemCount()) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex + 1, this.column);
                    DatapoolTable.this.table.setSelection(this.rowIndex + 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000001 && this.rowIndex > 0) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex - 1, this.column);
                    DatapoolTable.this.table.setSelection(this.rowIndex - 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000004 && this.column + 1 < DatapoolTable.this.table.getColumnCount()) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column + 1);
                    DatapoolTable.this.setScrollBars();
                }
                if (keyEvent.keyCode == 0x1000003 && this.column > 0) {
                    DatapoolTable.this.cursor.setSelection(this.rowIndex, this.column - 1);
                    DatapoolTable.this.setScrollBars();
                }
            }
            if (keyEvent.character == '\u001b') {
                this.text.dispose();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    class TableCellFocusAdaptor
    implements FocusListener {
        private Text text = null;
        private TableItem row = null;
        private int rowIndex = -1;
        private int column = -1;

        public TableCellFocusAdaptor(Text text, TableItem tableItem, int n) {
            this.text = text;
            this.row = tableItem;
            this.column = n;
            if (tableItem != null) {
                this.rowIndex = DatapoolTable.this.table.indexOf(tableItem);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            this.row.setText(this.column, this.text.getText());
            DatapoolTable.this.applyEditingValue(this.text.getText());
            this.text = null;
        }
    }
}

