/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ResourceSelectionDialog
extends Dialog
implements SelectionListener {
    private String fileExtension;
    private String title;
    private Button filterButton;
    private TreeViewer hostViewer;
    private HostsContentProvider contentProvider;
    private Image fileImage;
    private EObject[] selectedEObjects;

    public ResourceSelectionDialog(Shell shell, String string, String string2, Image image) {
        super(shell);
        this.title = string;
        this.fileExtension = string2;
        this.fileImage = image;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 300;
        gridData.widthHint = 250;
        composite2.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite2, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite2);
        this.hostViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.hostViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.hostViewer.expandToLevel(2);
        return composite2;
    }

    protected StructuredViewer createViewer(Composite composite) {
        Tree tree = new Tree(composite, 67586);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new HostsContentProvider();
        this.hostViewer = new TreeViewer(tree);
        this.hostViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.hostViewer.setLabelProvider((IBaseLabelProvider)new HostsLabelProvider(true, this.fileImage));
        this.contentProvider.setFilter(2);
        ViewerSorter viewerSorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] objectArray) {
                if (objectArray.length > 0) {
                    super.sort(viewer, objectArray);
                }
            }

            public int category(Object object) {
                if (object instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.hostViewer.setSorter(viewerSorter);
        return this.hostViewer;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection iSelection = this.hostViewer.getSelection();
            this.hostViewer.refresh();
            if (!iSelection.isEmpty()) {
                this.hostViewer.setSelection(iSelection, true);
            }
        }
        if (selectionEvent.widget == this.hostViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection iSelection = this.hostViewer.getSelection();
        if (iSelection != null && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            Vector<EObject> vector = new Vector<EObject>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof EObject)) continue;
                vector.add((EObject)e);
            }
            this.selectedEObjects = new EObject[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                this.selectedEObjects[n] = (EObject)vector.get(n);
                ++n;
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] iFileArray = new IFile[this.selectedEObjects.length];
        int n = 0;
        while (n < this.selectedEObjects.length) {
            iFileArray[n] = EMFUtil.getWorkspaceFile(this.selectedEObjects[n]);
            ++n;
        }
        return iFileArray;
    }

    private class HostsLabelProvider
    extends LabelProvider {
        private Hashtable ovelayCache;
        private boolean useImages;
        private Image image;
        static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

        public HostsLabelProvider(boolean bl, Image image) {
            this.useImages = bl;
            this.image = image;
            this.ovelayCache = new Hashtable();
        }

        public Image getImage(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (!this.useImages || object == null) {
                return null;
            }
            if (this.image != null) {
                return this.image;
            }
            if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = HostsLabelProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return iWorkbenchAdapter.getImageDescriptor(object).createImage();
            }
            return null;
        }

        public String getText(Object object) {
            IWorkbenchAdapter iWorkbenchAdapter;
            if (object == null) {
                return "";
            }
            String string = null;
            if (object instanceof EObject) {
                IFile iFile = EMFUtil.getWorkspaceFile((EObject)object);
                string = iFile.getName();
            } else if (object instanceof IAdaptable && (iWorkbenchAdapter = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = HostsLabelProvider.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                string = iWorkbenchAdapter.getLabel(object);
            }
            if (string == null) {
                string = object.toString();
            }
            return string;
        }

        public void dispose() {
            if (this.ovelayCache != null) {
                Iterator iterator = this.ovelayCache.values().iterator();
                while (iterator.hasNext()) {
                    Image image = (Image)iterator.next();
                    image.dispose();
                }
                this.ovelayCache.clear();
            }
            super.dispose();
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class HostsContentProvider
    implements ITreeContentProvider {
        public static final int FILTER_FOLDERS = 2;
        public static final int SHOW_ALL = 4;
        private int filter;
        private ArrayList list = new ArrayList();

        public int getFilter() {
            return this.filter;
        }

        public void setFilter(int n) {
            this.filter = n;
        }

        public void dispose() {
            this.list.clear();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public Object getParent(Object object) {
            if (object instanceof IResource) {
                return ((IResource)object).getParent();
            }
            if (object instanceof EObject) {
                EObject eObject = (EObject)object;
                switch (this.filter) {
                    case 4: {
                        IFile iFile = EMFUtil.getWorkspaceFile(eObject);
                        if (iFile == null) break;
                        return iFile.getParent();
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public Object[] getElements(Object object) {
            if (object instanceof IWorkspaceRoot) {
                if (this.getFilter() == 2) {
                    this.list.clear();
                    IProject[] iProjectArray = ((IWorkspaceRoot)object).getProjects();
                    int n = 0;
                    while (n < iProjectArray.length) {
                        Object[] objectArray = this.getChildren(iProjectArray[n]);
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            this.list.add(objectArray[n2]);
                            ++n2;
                        }
                        ++n;
                    }
                    return this.list.toArray();
                }
                return ((IWorkspaceRoot)object).getProjects();
            }
            return this.getChildren(object);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof IContainer) {
                UniqueEList uniqueEList = new UniqueEList();
                IResource[] iResourceArray = null;
                try {
                    iResourceArray = ((IContainer)object).members();
                }
                catch (CoreException coreException) {
                    TestUIPlugin.logError(coreException);
                    return new Object[0];
                }
                int n = 0;
                int n2 = iResourceArray.length;
                while (n < n2) {
                    Object[] objectArray;
                    if (iResourceArray[n].getType() != 1) {
                        if (this.filter == 2) {
                            objectArray = this.getChildren(iResourceArray[n]);
                            int n3 = 0;
                            while (n3 < objectArray.length) {
                                uniqueEList.add(objectArray[n3]);
                                ++n3;
                            }
                        } else {
                            uniqueEList.add(iResourceArray[n]);
                        }
                    } else {
                        objectArray = (Object[])iResourceArray[n];
                        if (objectArray.getFileExtension().equals(ResourceSelectionDialog.this.fileExtension)) {
                            EObject[] eObjectArray = EMFUtil.load(null, (IFile)iResourceArray[n]);
                            int n4 = 0;
                            while (n4 < eObjectArray.length) {
                                EObject eObject = eObjectArray[n4];
                                uniqueEList.add(eObject);
                                ++n4;
                            }
                        }
                    }
                    ++n;
                }
                return uniqueEList.toArray();
            }
            if (object instanceof Resource) {
                return ((Resource)object).getContents().toArray();
            }
            return new Object[0];
        }
    }
}

