/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.extension;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.IExtensibleEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.PropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ConfigurableObjectEditorExtension
extends BaseEditorExtension
implements IExtensibleEditorExtension {
    IConfigurationElement[] registeredExtensionElements;
    private Hashtable extensionPagesMap = new Hashtable();
    protected static final int PAGE_OVERVIEW = 0;
    private ConfigurableObjectOverviewForm overviewForm;
    private WidgetFactory widgetFactory;

    public ConfigurableObjectEditorExtension() {
        this.registeredExtensionElements = this.collectRegisteredExtensionElements();
    }

    protected IConfigurationElement[] collectRegisteredExtensionElements() {
        IExtensionPoint iExtensionPoint = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.hyades.test.ui.configurableObjectExtension");
        if (iExtensionPoint != null) {
            return iExtensionPoint.getConfigurationElements();
        }
        return new IConfigurationElement[0];
    }

    public void dispose() {
        this.overviewForm.dispose();
        Enumeration enumeration = this.extensionPagesMap.elements();
        while (enumeration.hasMoreElements()) {
            ((EditorForm)enumeration.nextElement()).dispose();
        }
        this.extensionPagesMap.clear();
        if (this.widgetFactory != null) {
            this.widgetFactory.dispose();
        }
        super.dispose();
    }

    public EObject getEditorObject() {
        return (EObject)this.getHyadesEditorPart().getEditorObject();
    }

    public void createPages() {
        IHyadesEditorPart iHyadesEditorPart = this.getHyadesEditorPart();
        this.widgetFactory = new WidgetFactory();
        this.overviewForm = this.createOverviewPage(this.widgetFactory);
        this.overviewForm.setRegisteredExtensions(this.registeredExtensionElements);
        this.getHyadesEditorPart().addPage(this.overviewForm.createControl());
        this.getHyadesEditorPart().setPageText(0, TestUIPlugin.getString("W_OVERVIEW"));
        this.overviewForm.updateTitle();
        this.createOtherStaticPages(this.widgetFactory);
        this.createExtensionPages(this.widgetFactory);
    }

    protected ConfigurableObjectOverviewForm createOverviewPage(WidgetFactory widgetFactory) {
        return new ConfigurableObjectOverviewForm(this, widgetFactory);
    }

    protected void createOtherStaticPages(WidgetFactory widgetFactory) {
    }

    protected void createExtensionPages(WidgetFactory widgetFactory) {
        EObject eObject = this.getEditorObject();
        EList eList = null;
        String string = null;
        if (eObject instanceof CFGLocation) {
            eList = ((CFGLocation)eObject).getPropertyGroups();
            string = "location";
        } else if (eObject instanceof CFGArtifact) {
            eList = ((CFGArtifact)eObject).getPropertyGroups();
            string = "artifact";
        } else if (eObject instanceof TPFDeployment) {
            eList = ((TPFDeployment)eObject).getPropertyGroups();
            string = "deployment";
        }
        if (eList == null || eList.isEmpty()) {
            return;
        }
        Iterator iterator = eList.iterator();
        CFGPropertyGroup cFGPropertyGroup = null;
        String string2 = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            cFGPropertyGroup = (CFGPropertyGroup)iterator.next();
            if (cFGPropertyGroup.getProperties().isEmpty()) continue;
            string2 = cFGPropertyGroup.getPropertyGroupID();
            int n = 0;
            while (n < this.registeredExtensionElements.length) {
                if (this.registeredExtensionElements[n].getAttribute("propertyGroupID").equals(string2)) {
                    this.addExtensionPage(this.registeredExtensionElements[n]);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            PropertyGroupForm propertyGroupForm = new PropertyGroupForm();
            propertyGroupForm.init(cFGPropertyGroup, this, this.widgetFactory);
            propertyGroupForm.setAppliesto(string);
            int n2 = this.getHyadesEditorPart().addPage(propertyGroupForm.createControl());
            this.getHyadesEditorPart().setPageText(n2, cFGPropertyGroup.getName());
            this.extensionPagesMap.put(new Integer(n2), propertyGroupForm);
            this.overviewForm.addSection(propertyGroupForm, n2);
        }
    }

    protected ConfigurableObjectOverviewForm getOverviewForm() {
        return this.overviewForm;
    }

    public void refreshContent(Object object) {
        this.overviewForm.load();
        this.overviewForm.updateTitle();
    }

    public IStructuredSelection getSelection() {
        int n = this.getHyadesEditorPart().getActivePage();
        if (n == 0) {
            return new StructuredSelection((Object)this.getEditorObject());
        }
        if (this.extensionPagesMap.containsKey(new Integer(n))) {
            return ((IPropertyGroupForm)this.extensionPagesMap.get(new Integer(n))).getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public boolean pageActivated(int n) {
        if (n == 0) {
            return this.overviewForm.activated();
        }
        if (this.extensionPagesMap.containsKey(new Integer(n))) {
            return ((EditorForm)this.extensionPagesMap.get(new Integer(n))).activated();
        }
        return false;
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) != this.getEditorObject() && !(object instanceof IConfigurationElement) && object instanceof CFGComparableProperty) {
            EObject eObject = ((CFGComparableProperty)object).eContainer();
            Enumeration enumeration = this.extensionPagesMap.elements();
            IPropertyGroupForm iPropertyGroupForm = null;
            while (enumeration.hasMoreElements()) {
                iPropertyGroupForm = (IPropertyGroupForm)enumeration.nextElement();
                if (iPropertyGroupForm.getPropertyGroup() != eObject) continue;
                iPropertyGroupForm.selectReveal((ISelection)iStructuredSelection);
                break;
            }
        }
    }

    public int addExtensionPage(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("propertyGroupID");
        Enumeration enumeration = this.extensionPagesMap.keys();
        IPropertyGroupForm iPropertyGroupForm = null;
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            iPropertyGroupForm = (IPropertyGroupForm)this.extensionPagesMap.get(n);
            if (!iPropertyGroupForm.getPropertyGroup().getPropertyGroupID().equals(string)) continue;
            return n;
        }
        IPropertyGroupForm iPropertyGroupForm2 = null;
        try {
            iPropertyGroupForm2 = (IPropertyGroupForm)iConfigurationElement.createExecutableExtension("class");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        iPropertyGroupForm2.init(this.getCFGPropertyGroup(iConfigurationElement), this, this.widgetFactory);
        iPropertyGroupForm2.setAppliesto(iConfigurationElement.getAttribute("appliesTo"));
        iPropertyGroupForm2.setControlType(iConfigurationElement.getAttribute("controlType"));
        int n = this.getHyadesEditorPart().addPage(iPropertyGroupForm2.createControl());
        this.getHyadesEditorPart().setPageText(n, iPropertyGroupForm2.getPropertyGroup().getName());
        this.extensionPagesMap.put(new Integer(n), iPropertyGroupForm2);
        this.overviewForm.addSection(iPropertyGroupForm2, n);
        return n;
    }

    private CFGPropertyGroup getCFGPropertyGroup(IConfigurationElement iConfigurationElement) {
        EObject eObject = this.getEditorObject();
        EList eList = null;
        if (eObject instanceof CFGLocation) {
            eList = ((CFGLocation)eObject).getPropertyGroups();
        } else if (eObject instanceof CFGArtifact) {
            eList = ((CFGArtifact)eObject).getPropertyGroups();
        } else if (eObject instanceof TPFDeployment) {
            eList = ((TPFDeployment)eObject).getPropertyGroups();
        }
        if (eList == null) {
            return null;
        }
        CFGPropertyGroup cFGPropertyGroup = null;
        String string = iConfigurationElement.getAttribute("propertyGroupID");
        String string2 = iConfigurationElement.getAttribute("name");
        String string3 = iConfigurationElement.getAttribute("description");
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            cFGPropertyGroup = (CFGPropertyGroup)iterator.next();
            if (string.equals(cFGPropertyGroup.getPropertyGroupID())) break;
            cFGPropertyGroup = null;
        }
        if (cFGPropertyGroup == null) {
            cFGPropertyGroup = Common_ConfigurationFactory.eINSTANCE.createCFGPropertyGroup();
            cFGPropertyGroup.setPropertyGroupID(string);
            cFGPropertyGroup.setName(string2);
            cFGPropertyGroup.setDescription(string3);
            eList.add(cFGPropertyGroup);
        }
        return cFGPropertyGroup;
    }
}

