/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.extension.DeploymentEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.ConfigurableObjectOverviewForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.util.DeploymentCompatibilityConverter;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class DeploymentForm
extends ConfigurableObjectOverviewForm {
    private int locationPageIndex;
    private NamedElementsSection locationsSection;

    public DeploymentForm(DeploymentEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory) {
        super(deploymentEditorExtension, widgetFactory);
        this.setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
    }

    public void dispose() {
        if (this.locationsSection != null) {
            this.locationsSection.dispose();
            this.locationsSection = null;
        }
        super.dispose();
    }

    public void setLocationPageIndex(int n) {
        this.locationPageIndex = n;
    }

    public Control createControl() {
        Control control = super.createControl();
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)(TestUIPlugin.getID() + ".depf0001"));
        return control;
    }

    protected void createEditorFormContents(Composite composite) {
        super.createEditorFormContents(composite);
        this.locationsSection = new NamedElementsSection((IEditorExtension)this.getBaseEditorExtension(), this.locationPageIndex);
        this.registerSection(this.locationsSection);
        this.locationsSection.createControl(this.getPropertyGroupSectionsContainer(), this.factory, TestUIPlugin.getString("W_LOCS"), TestUIPlugin.getString("EDT_LOC_DSC"));
    }

    protected void setGeneralInfoSectionHelp(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)(TestUIPlugin.getID() + ".depf0003"));
    }

    public void load() {
        super.load();
        boolean bl = false;
        TPFDeployment tPFDeployment = (TPFDeployment)this.getDataObject();
        if (!tPFDeployment.getLocations().isEmpty()) {
            boolean bl2 = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)TestUIPlugin.getString("DLG_UPGRADE_DEP"), (String)TestUIPlugin.getString("DLG_UPGRADE_DSC"));
            if (bl2) {
                try {
                    DeploymentCompatibilityConverter.convert(tPFDeployment);
                    this.getBaseEditorExtension().markDirty();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                bl = true;
            }
        }
        if (bl) {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Locations(), null);
        } else {
            this.locationsSection.initialize(this.getDataObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), null);
        }
    }

    public void openLocationEditor(CFGLocation cFGLocation) {
        IFile iFile = EMFUtil.getWorkspaceFile((EObject)cFGLocation);
        UIUtil.openEditor((IFile)iFile, (String)"org.eclipse.hyades.test.ui.editor.LocationEditorPart", (boolean)false);
    }
}

