/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddConfigPropertyAction;
import org.eclipse.hyades.test.ui.internal.dialog.ComparablePropertyInputDialog;
import org.eclipse.hyades.test.ui.internal.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.IPropertyGroupForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveDownChildrenAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveUpChildrenAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.internal.util.TestUIUtil;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class PropertyGroupForm
extends EditorForm
implements IPropertyGroupForm {
    private CFGPropertyGroup propertyGroup;
    private EditorSection mainSection;
    public static final String EDITOR_TYPE_ARTIFACT = "artifact";
    public static final String EDITOR_TYPE_LOCATION = "location";
    public static final String EDITOR_TYPE_DEPLOYMENT = "deployment";
    private String editorType = "location";
    public static final String CONTROL_TYPE_CUSTOM = "custom";
    public static final String CONTROL_TYPE_TABLE = "table";
    public static final String CONTROL_TYPE_TREE = "tree";
    public static final String CONTROL_TYPE_FIELDS = "fields";
    private String controlType = "table";
    private RemoveFeatureChildrenAction removeAction;

    public void init(CFGPropertyGroup cFGPropertyGroup, BaseEditorExtension baseEditorExtension, WidgetFactory widgetFactory) {
        this.propertyGroup = cFGPropertyGroup;
        super.init(baseEditorExtension, widgetFactory);
    }

    public void setAppliesto(String string) {
        this.editorType = string.equals(EDITOR_TYPE_DEPLOYMENT) ? EDITOR_TYPE_DEPLOYMENT : EDITOR_TYPE_LOCATION;
    }

    public void setControlType(String string) {
        this.controlType = string;
    }

    public CFGPropertyGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getAppliesTo() {
        return this.editorType;
    }

    public void dispose() {
        super.dispose();
    }

    protected EObject getEditorObject() {
        return ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getEditorObject();
    }

    protected void createEditorFormContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = this.createColumn(composite);
        Composite composite3 = this.createColumn(composite);
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            this.mainSection = this.createTreeSection(composite2);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            this.mainSection = this.createTableSection(composite2);
        } else if (this.controlType.equals(CONTROL_TYPE_FIELDS)) {
            // empty if block
        }
        if (this.mainSection != null) {
            this.registerSection(this.mainSection);
            this.mainSection.setHeaderText(this.propertyGroup.getName());
            this.mainSection.setCollapsable(true);
            Control control = this.mainSection.createControl(composite2, this.getWidgetFactory());
            control.setLayoutData((Object)new GridData(1810));
        }
    }

    protected EditorSection createTreeSection(Composite composite) {
        AddConfigPropertyAction addConfigPropertyAction = new AddConfigPropertyAction(this.propertyGroup, HyadesUIImages.INSTANCE.getImageDescriptor("location_obj.gif")){

            protected CFGComparableProperty[] addProperties() {
                return PropertyGroupForm.this.addProperties();
            }
        };
        return new EObjectTreeSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), (IAction)addConfigPropertyAction);
    }

    protected EditorSection createTableSection(Composite composite) {
        ExtensibleEObjectTableSection extensibleEObjectTableSection = new ExtensibleEObjectTableSection(this, (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), 3, this.createButtonActions());
        extensibleEObjectTableSection.setLabelProvider(new PropertyGroupTableLabelProvider());
        return extensibleEObjectTableSection;
    }

    protected IAction[] createButtonActions() {
        IAction[] iActionArray = new IAction[4];
        iActionArray[0] = new AddConfigPropertyAction(this.propertyGroup, HyadesUIImages.INSTANCE.getImageDescriptor("location_obj.gif")){

            protected CFGComparableProperty[] addProperties() {
                return PropertyGroupForm.this.addProperties();
            }
        };
        this.removeAction = new RemoveFeatureChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties(), false);
        iActionArray[1] = this.removeAction;
        iActionArray[2] = new MoveUpChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        iActionArray[3] = new MoveDownChildrenAction((EObject)this.getPropertyGroup(), (EStructuralFeature)Common_ConfigurationPackage.eINSTANCE.getCFGPropertyGroup_Properties());
        return iActionArray;
    }

    protected CFGComparableProperty[] addProperties() {
        CFGComparableProperty[] cFGComparablePropertyArray = null;
        if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            ComparablePropertyInputDialog comparablePropertyInputDialog = new ComparablePropertyInputDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_NEW_PROPERTY"));
            comparablePropertyInputDialog.open();
            CFGComparableProperty cFGComparableProperty = comparablePropertyInputDialog.getProperty();
            cFGComparablePropertyArray = new CFGComparableProperty[]{cFGComparableProperty};
        } else if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            String string = TestUIUtil.getUniqueName(TestUIPlugin.getString("W_COUNTER"), (List)this.propertyGroup.getProperties());
            CFGComparableProperty cFGComparableProperty = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            cFGComparableProperty.setName(string);
            cFGComparablePropertyArray = new CFGComparableProperty[]{cFGComparableProperty};
        }
        return cFGComparablePropertyArray;
    }

    public void load() {
        if (this.controlType.equals(CONTROL_TYPE_TREE)) {
            EObjectTreeSection eObjectTreeSection = (EObjectTreeSection)this.mainSection;
            eObjectTreeSection.setInput(this.propertyGroup);
        } else if (this.controlType.equals(CONTROL_TYPE_TABLE)) {
            ExtensibleEObjectTableSection extensibleEObjectTableSection = (ExtensibleEObjectTableSection)this.mainSection;
            extensibleEObjectTableSection.getTableViewer().removeSelectionChangedListener((ISelectionChangedListener)extensibleEObjectTableSection);
            extensibleEObjectTableSection.setInput(this.propertyGroup);
            extensibleEObjectTableSection.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)extensibleEObjectTableSection);
        } else if (this.controlType.equals(CONTROL_TYPE_FIELDS)) {
            // empty if block
        }
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection((Object)this.getEditorObject());
    }

    public void selectReveal(ISelection iSelection) {
        this.mainSection.selectReveal(iSelection);
    }

    public boolean doGlobalAction(String string) {
        if (string.equals("delete")) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    public class PropertyGroupTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof CFGComparableProperty) {
                CFGComparableProperty cFGComparableProperty = (CFGComparableProperty)object;
                switch (n) {
                    case 0: {
                        return cFGComparableProperty.getName();
                    }
                    case 1: {
                        return cFGComparableProperty.getOperator();
                    }
                    case 2: {
                        return cFGComparableProperty.getValue();
                    }
                }
            }
            return null;
        }
    }
}

