/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.AbstractSectionForm;
import org.eclipse.hyades.test.ui.internal.editor.form.base.SectionForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrollableSectionForm
extends SectionForm {
    private Composite container;
    private boolean verticalFit;
    private boolean scrollable = true;

    public Control createControl(Composite composite) {
        ScrolledComposite scrolledComposite;
        this.container = this.createParent(composite);
        Control control = super.createControl(this.container);
        if (this.container instanceof ScrolledComposite) {
            scrolledComposite = (ScrolledComposite)this.container;
            scrolledComposite.setContent(control);
        }
        scrolledComposite = new GridData(1808);
        control.setLayoutData((Object)scrolledComposite);
        this.container.setBackground(control.getBackground());
        return this.container;
    }

    protected Composite createParent(Composite composite) {
        Composite composite2 = null;
        if (this.isScrollable()) {
            ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
            if (this.isVerticalFit()) {
                scrolledComposite.setExpandHorizontal(true);
                scrolledComposite.setExpandVertical(true);
            }
            this.initializeScrollBars(scrolledComposite);
            composite2 = scrolledComposite;
        } else {
            composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            composite2.setLayout((Layout)gridLayout);
        }
        composite2.setMenu(composite.getMenu());
        return composite2;
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public boolean isVerticalFit() {
        return this.verticalFit;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public void setVerticalFit(boolean bl) {
        this.verticalFit = bl;
    }

    private void initializeScrollBars(ScrolledComposite scrolledComposite) {
        ScrollBar scrollBar;
        ScrollBar scrollBar2 = scrolledComposite.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setIncrement(5);
        }
        if ((scrollBar = scrolledComposite.getVerticalBar()) != null) {
            scrollBar.setIncrement(64);
        }
        AbstractSectionForm.updatePageIncrement(scrolledComposite);
    }

    public void update() {
        super.update();
        if (this.container instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        } else {
            this.container.layout(true);
        }
    }

    public void updateScrollBars() {
        if (this.container instanceof ScrolledComposite) {
            this.updateScrolledComposite();
        }
    }

    public void updateScrolledComposite() {
        ScrolledComposite scrolledComposite = (ScrolledComposite)this.container;
        Control control = this.getControl();
        Point point = control.computeSize(-1, -1);
        control.setSize(point);
        scrolledComposite.setMinSize(point);
        AbstractSectionForm.updatePageIncrement(scrolledComposite);
    }
}

