/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.ui.internal.action.CollapseAllAction;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.DrillDownAdapter;

public class EObjectTreeSection
extends TreeSection {
    private EStructuralFeature eStructuralFeature;
    protected DrillDownAdapter drillDownAdapter;
    protected CollapseAllAction collapseAllAction;
    protected IAction addAction;
    protected RemoveChildrenAction removeAction;
    protected MoveChildrenUpAction moveUpAction;
    protected MoveChildrenDownAction moveDownAction;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter;

    public EObjectTreeSection(EditorForm editorForm, EStructuralFeature eStructuralFeature, IAction iAction) {
        super(editorForm);
        this.eStructuralFeature = eStructuralFeature;
        this.addAction = iAction;
        String string = null;
        if (iAction != null) {
            string = iAction.getText();
        }
        this.adjustButtonLabels(string);
    }

    public void dispose() {
        this.eStructuralFeature = null;
        if (this.drillDownAdapter != null) {
            this.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
            this.drillDownAdapter = null;
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.dispose();
            this.collapseAllAction = null;
        }
        if (this.removeAction != null) {
            this.removeAction.dispose();
            this.removeAction = null;
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.dispose();
            this.moveUpAction = null;
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.dispose();
            this.moveDownAction = null;
        }
        this.addAction = null;
        super.dispose();
    }

    protected EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    protected void adjustButtonLabels(String string) {
        this.removeAction = new RemoveChildrenAction(false);
        this.moveUpAction = new MoveChildrenUpAction();
        this.moveDownAction = new MoveChildrenDownAction();
        this.setButtonLabels(new String[]{string, this.removeAction.getText(), this.moveUpAction.getText(), this.moveDownAction.getText()});
    }

    protected void setAddAction(IAction iAction) {
        this.addAction = iAction;
    }

    protected void adjustClient(Composite composite) {
        this.getTreeViewer().setContentProvider(this.createContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.getTreeViewer().setAutoExpandLevel(0);
        if (this.addAction != null) {
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
        if (this.removeAction != null) {
            this.removeAction.setStructuredViewer((StructuredViewer)this.getTreeViewer());
        }
    }

    protected IContentProvider createContentProvider() {
        return new EObjectContainerContentProvider(this.getEditorForm(), this.getEStructuralFeature());
    }

    protected ILabelProvider createLabelProvider() {
        return new WorkbenchAdapterLabelProvider(class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter == null ? (class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter = EObjectTreeSection.class$("org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter")) : class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter);
    }

    protected void createActions() {
        this.collapseAllAction = new CollapseAllAction(this.getTreeViewer()).useDefaultDecorators();
        this.drillDownAdapter = new DrillDownAdapter(this.getTreeViewer());
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this.drillDownAdapter);
        if (this.removeAction != null) {
            this.removeAction.setEnabled(false);
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveDownAction.setEnabled(false);
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setEStructuralFeature(this.getEStructuralFeature());
            this.moveUpAction.setEnabled(false);
        }
    }

    protected void buttonSelected(int n) {
        if (!this.isReadOnly()) {
            switch (n) {
                case 0: {
                    this.doAdd();
                    break;
                }
                case 1: {
                    this.doRemove();
                    break;
                }
                case 2: {
                    this.doMoveUp();
                    break;
                }
                case 3: {
                    this.doMoveDown();
                }
            }
        }
        this.updateActionsAndButtons(this.getStructuredSelection());
    }

    protected void doAdd() {
        if (this.addAction != null) {
            this.addAction.run();
        }
    }

    protected void doRemove() {
        if (this.removeAction != null) {
            this.removeAction.run();
        }
    }

    protected void doMoveUp() {
        if (this.moveUpAction != null) {
            this.moveUpAction.run();
        }
    }

    protected void doMoveDown() {
        if (this.moveDownAction != null) {
            this.moveDownAction.run();
        }
    }

    public boolean doGlobalAction(String string) {
        if (string.equals("delete")) {
            if (this.removeAction != null) {
                this.removeAction.run();
            }
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        if (this.removeAction != null) {
            if (this.removeAction.isEnabled()) {
                this.removeAction.setEnabled(!this.isReadOnly());
            }
            iMenuManager.add((IAction)this.removeAction);
            iMenuManager.add((IContributionItem)new Separator());
        }
        boolean bl = false;
        TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
        int n = 0;
        int n2 = treeItemArray.length;
        while (n < n2) {
            if (treeItemArray[n].getExpanded()) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            iMenuManager.add((IAction)this.collapseAllAction);
            iMenuManager.add((IContributionItem)new Separator());
        }
    }

    protected void updateActionsAndButtons(IStructuredSelection iStructuredSelection) {
        if (this.addAction != null) {
            if (this.addAction instanceof SelectionListenerAction) {
                ((SelectionListenerAction)this.addAction).selectionChanged(iStructuredSelection);
            }
            this.getTreePart().setButtonEnabled(0, this.addAction.isEnabled());
        }
        if (this.removeAction != null) {
            this.removeAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(1, this.removeAction.isEnabled());
        }
        if (this.moveDownAction != null) {
            this.moveDownAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(3, this.moveDownAction.isEnabled());
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.selectionChanged(iStructuredSelection);
            this.getTreePart().setButtonEnabled(2, this.moveUpAction.isEnabled());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class EObjectContainerContentProvider
    extends AdapterImpl
    implements ITreeContentProvider {
        private EStructuralFeature eStructuralFeature;
        private EObject container;
        private Viewer viewer;
        private EditorForm editorForm;
        private Map eStructuralFeatureByClass;

        public EObjectContainerContentProvider(EditorForm editorForm, EStructuralFeature eStructuralFeature) {
            this.eStructuralFeature = eStructuralFeature;
            this.editorForm = editorForm;
        }

        public void dispose() {
            if (this.container != null) {
                this.container.eAdapters().remove((Object)this);
                Object object = this.container.eGet(this.eStructuralFeature);
                if (object instanceof Collection) {
                    EMFUtil.removeAdapter(((Collection)object).iterator(), (Adapter)this);
                } else if (object != null) {
                    ((Notifier)object).eAdapters().remove((Object)this);
                }
                this.container = null;
            }
            this.viewer = null;
            this.eStructuralFeature = null;
            this.editorForm = null;
            if (this.eStructuralFeatureByClass != null) {
                this.eStructuralFeatureByClass.clear();
            }
        }

        protected EObject getContainer() {
            return this.container;
        }

        public void registerParent(Class clazz, EStructuralFeature eStructuralFeature) {
            if (this.eStructuralFeatureByClass == null) {
                this.eStructuralFeatureByClass = new HashMap();
            }
            this.eStructuralFeatureByClass.put(clazz, eStructuralFeature);
        }

        public void deregisterParent(Class clazz) {
            if (this.eStructuralFeatureByClass != null) {
                this.eStructuralFeatureByClass.remove(clazz);
            }
        }

        protected Object getRegisteredParentChild(Object object) {
            if (this.eStructuralFeatureByClass != null) {
                Iterator iterator = this.eStructuralFeatureByClass.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!((Class)entry.getKey()).isInstance(object)) continue;
                    if (object instanceof EObject) {
                        return ((EObject)object).eGet((EStructuralFeature)entry.getValue());
                    }
                    return null;
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            Object object3;
            this.viewer = viewer;
            if (this.container != null) {
                this.container.eAdapters().remove((Object)this);
                object3 = this.container.eGet(this.eStructuralFeature);
                this.deregisterInputAdapters(this.container, object3);
                this.container = null;
            }
            if (object2 instanceof EObject) {
                object3 = (EObject)object2;
                if (this.eStructuralFeature.eContainer() == object3.eClass()) {
                    this.container = object3;
                    this.container.eAdapters().add(this);
                    this.registerInputAdapters((EObject)object3, this.container.eGet(this.eStructuralFeature));
                }
            }
        }

        protected Viewer getViewer() {
            return this.viewer;
        }

        protected void deregisterInputAdapters(EObject eObject, Object object) {
            if (object instanceof Collection) {
                EMFUtil.removeAdapter(((Collection)object).iterator(), (Adapter)this);
            } else if (object != null) {
                ((Notifier)object).eAdapters().remove((Object)this);
            }
        }

        protected void registerInputAdapters(EObject eObject, Object object) {
            if (object instanceof List) {
                EMFUtil.addAdapter(((List)object).iterator(), (Adapter)this);
            } else if (object != null) {
                ((Notifier)object).eAdapters().add(this);
            }
        }

        public Object getParent(Object object) {
            if (this.container == object) {
                return null;
            }
            if (object instanceof EObject) {
                return ((EObject)object).eContainer();
            }
            return null;
        }

        public Object[] getElements(Object object) {
            if (this.container == null) {
                return new Object[0];
            }
            if (this.eStructuralFeature.isMany()) {
                return ((List)this.container.eGet(this.eStructuralFeature)).toArray();
            }
            return new Object[]{this.container.eGet(this.eStructuralFeature)};
        }

        public boolean hasChildren(Object object) {
            if (this.container == null) {
                return false;
            }
            if (!this.eStructuralFeature.isMany()) {
                return false;
            }
            if (this.container == object) {
                List list = (List)this.container.eGet(this.eStructuralFeature);
                return !list.isEmpty();
            }
            Object object2 = this.getRegisteredParentChild(object);
            return object2 != null;
        }

        public Object[] getChildren(Object object) {
            Object object2 = this.getRegisteredParentChild(object);
            if (object2 != null) {
                if (object2 instanceof Collection) {
                    return ((Collection)object2).toArray();
                }
                return new Object[]{object2};
            }
            return new Object[0];
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    return;
                }
            }
            this.editorForm.getBaseEditorExtension().markDirty();
            this.adjustModel(notification);
            this.adjustAdapter(notification);
            this.updateViewer(notification);
        }

        protected void adjustModel(Notification notification) {
        }

        protected boolean shouldAdjustAdapter(Notification notification) {
            return notification.getNotifier() == this.container && notification.getFeature() == this.eStructuralFeature;
        }

        protected void adjustAdapter(Notification notification) {
            if (this.shouldAdjustAdapter(notification)) {
                switch (notification.getEventType()) {
                    case 3: {
                        ((Notifier)notification.getNewValue()).eAdapters().add(this);
                        break;
                    }
                    case 5: {
                        EMFUtil.addAdapter(((Collection)notification.getNewValue()).iterator(), (Adapter)this);
                        break;
                    }
                    case 4: {
                        ((Notifier)notification.getOldValue()).eAdapters().remove((Object)this);
                        break;
                    }
                    case 6: {
                        EMFUtil.removeAdapter(((Collection)notification.getOldValue()).iterator(), (Adapter)this);
                    }
                }
            }
        }

        protected boolean shouldUpdateViewer(Notification notification) {
            return notification.getFeature() == this.eStructuralFeature;
        }

        protected void updateViewer(Notification notification) {
            if (this.getViewer() == null) {
                return;
            }
            if (!(this.getViewer() instanceof StructuredViewer)) {
                this.getViewer().refresh();
                return;
            }
            if (notification.getNotifier() != this.container) {
                switch (notification.getEventType()) {
                    case 1: 
                    case 2: {
                        this.attributeChanged(notification);
                        return;
                    }
                }
            }
            if (!(this.getViewer() instanceof TreeViewer)) {
                this.getViewer().refresh();
                return;
            }
            if (this.shouldUpdateViewer(notification)) {
                Object object = null;
                switch (notification.getEventType()) {
                    case 3: {
                        object = this.getParent(notification.getNewValue());
                        if (object == null) {
                            object = this.getViewer().getInput();
                        }
                        ((TreeViewer)this.getViewer()).add(object, notification.getNewValue());
                        this.getViewer().setSelection((ISelection)new StructuredSelection(notification.getNewValue()), true);
                        break;
                    }
                    case 5: {
                        Object[] objectArray = ((Collection)notification.getNewValue()).toArray();
                        object = this.getParent(objectArray[0]);
                        if (object == null) {
                            object = this.getViewer().getInput();
                        }
                        ((TreeViewer)this.getViewer()).add(object, objectArray);
                        this.getViewer().setSelection((ISelection)new StructuredSelection(objectArray), true);
                        break;
                    }
                    case 4: {
                        ((TreeViewer)this.getViewer()).remove(notification.getOldValue());
                        Object object2 = ((EObject)notification.getNotifier()).eGet((EStructuralFeature)notification.getFeature());
                        if (object2 instanceof List) {
                            List list = (List)object2;
                            if (list.isEmpty()) {
                                this.getViewer().getControl().setFocus();
                                break;
                            }
                            int n = notification.getPosition();
                            n = n < list.size() ? n : list.size() - 1;
                            this.getViewer().setSelection((ISelection)new StructuredSelection(list.get(n)), true);
                            break;
                        }
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    case 6: {
                        ((TreeViewer)this.getViewer()).remove(((Collection)notification.getOldValue()).toArray());
                        this.getViewer().getControl().setFocus();
                        break;
                    }
                    case 7: {
                        this.getViewer().refresh();
                    }
                }
            }
        }

        protected void attributeChanged(Notification notification) {
            ((StructuredViewer)this.getViewer()).update(notification.getNotifier(), null);
        }
    }
}

