/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GeneralInfoSection
extends NamedElementSection {
    private StyledText fileText;
    boolean displayResourceFileInfo = false;
    private boolean editable;

    public GeneralInfoSection(EditorForm editorForm, boolean bl) {
        super(editorForm);
        this.displayResourceFileInfo = bl;
        this.setHeaderText(TestUIPlugin.getString("EDT_GENERAL_INFO"));
        this.setDescription(TestUIPlugin.getString("EDT_GENERAL_DSC"));
    }

    public void dispose() {
        super.dispose();
        this.fileText.dispose();
    }

    protected void addSouthControls(Composite composite, FormWidgetFactory formWidgetFactory) {
        if (!this.displayResourceFileInfo) {
            return;
        }
        WidgetFactory widgetFactory = this.getEditorForm().getWidgetFactory();
        Composite composite2 = widgetFactory.createComposite(composite);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)GridDataUtil.createHorizontalFill());
        widgetFactory.createLabel(composite2, TestUIPlugin.getString("L_FILE"));
        this.fileText = widgetFactory.createStyledText(composite2, 65540);
        this.fileText.setEnabled(false);
        this.fileText.setLayoutData((Object)GridDataUtil.createHorizontalFill());
    }

    public void setInput(Object object) {
        IFile iFile;
        IStructuredSelection iStructuredSelection;
        super.setInput(object);
        if (!this.displayResourceFileInfo) {
            return;
        }
        if (object instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)object).size() == 1 && (iFile = EMFUtil.getWorkspaceFile((EObject)iStructuredSelection.getFirstElement())) != null) {
            this.getFileText().setText(iFile.getFullPath().toString());
        }
        if (object instanceof EObject && (iStructuredSelection = EMFUtil.getWorkspaceFile((EObject)object)) != null) {
            this.getFileText().setText(iStructuredSelection.getFullPath().toString());
        }
        this.setEditable(this.editable);
    }

    protected StyledText getFileText() {
        return this.fileText;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
        if (this.getNameTextField() != null) {
            this.getNameTextField().setEditable(this.editable);
        }
        if (this.getDescriptionTextField() != null) {
            this.getDescriptionTextField().setEditable(this.editable);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }
}

