/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.io.FileNotFoundException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.internal.plugins.ConfigurationElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IDataProcessor;
import org.eclipse.hyades.execution.core.IEclipseExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.IRemoteHyadesComponent;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.UnknownDaemonException;
import org.eclipse.hyades.execution.harness.ExecutionHarnessDataProcessorFactory;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutableObjectAdapter;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.execution.harness.util.DeploymentUtilities;
import org.eclipse.hyades.execution.harness.util.ISystemUtility;
import org.eclipse.hyades.execution.harness.util.StandaloneExecutionUtilities;
import org.eclipse.hyades.execution.harness.util.StandaloneSystemUtility;
import org.eclipse.hyades.execution.local.EclipseExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutableObjectStub;
import org.eclipse.hyades.execution.local.ExecutionComponentFactoryImpl;
import org.eclipse.hyades.execution.local.ExecutorStub;
import org.eclipse.hyades.execution.local.HyadesTestNodeImpl;
import org.eclipse.hyades.execution.local.JavaProcessExecutableObjectStub;
import org.eclipse.hyades.execution.local.SessionContext;
import org.eclipse.hyades.execution.local.SessionContextToSessionMap;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGMachineConstraint;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceFactoryImpl;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionType;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofilePackageImpl;
import org.eclipse.hyades.models.hierarchy.util.StringUtil;

public class TestExecutionHarness {
    private Object agentLock = new Object();
    private boolean bAgentReady = false;
    private static HashMap testTypeMap = null;
    private boolean bFactoryInitialized = false;
    private static boolean bStandalone = false;
    private IExecutionComponentFactory factory;
    private ISession session;
    private INode node;
    private IExecutionEnvironment exeEnvironment;
    private IExecutor executor;
    private String[] standaloneConfigurationFiles;
    private ISystemUtility systemUtility;
    private ExecutionHarnessDataProcessorFactory dpFactory;

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = stringArray[3];
        String string5 = stringArray[4];
        String string6 = stringArray[5];
        StringBuffer stringBuffer = new StringBuffer();
        TestExecutionHarness testExecutionHarness = new TestExecutionHarness(string, string2);
        testExecutionHarness.launchTest(string3, null, string4, "10002", string5, string6, true, true, stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    public TestExecutionHarness() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Standalone execution requires that a configuration file directory is passed to the TestExecutionHarness constructor!");
        }
    }

    public TestExecutionHarness(String string, String string2) {
        try {
            Class<?> clazz = Class.forName("org.eclipse.core.boot.BootLoader");
            bStandalone = false;
            this.systemUtility = ExecutionHarnessPlugin.getDefault();
        }
        catch (ClassNotFoundException classNotFoundException) {
            bStandalone = true;
            String[] stringArray = StandaloneExecutionUtilities.getConfigFilesFromConfigDir(string);
            this.setStandaloneConfigurationFiles(stringArray);
            String string3 = StandaloneExecutionUtilities.getHarnessDir(string, string2);
            this.systemUtility = new StandaloneSystemUtility(string3);
            RegistryReader.standaloneConfiguration = new RegistryReader.StandaloneConfiguration();
            RegistryReader.standaloneConfiguration.setEclipseFolder(string);
            this.init();
        }
    }

    private void init() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("testsuite", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("deploy", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("execution", new FacadeResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new FacadeResourceFactoryImpl());
        Common_TestprofilePackageImpl.init();
    }

    protected void releaseAgentLock() {
        Object object = this.agentLock;
        synchronized (object) {
            this.bAgentReady = true;
            this.agentLock.notify();
        }
    }

    protected void initializeRegisteredExecutionComponents(IExecutionComponentFactory iExecutionComponentFactory, boolean bl, ExecutionHarnessDataProcessorFactory executionHarnessDataProcessorFactory) throws ClassNotFoundException, FileNotFoundException {
        testTypeMap = new HashMap();
        if (!bl) {
            IEclipseExecutionComponentFactory iEclipseExecutionComponentFactory = (IEclipseExecutionComponentFactory)iExecutionComponentFactory;
            IPluginRegistry iPluginRegistry = Platform.getPluginRegistry();
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.RegisteredExecutionComponentImpl");
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string = iConfigurationElementArray[n].getAttribute("type");
                String string2 = iConfigurationElementArray[n].getAttribute("name");
                iEclipseExecutionComponentFactory.addExecutionComponent(iConfigurationElementArray[n]);
                Object object = testTypeMap.get(string);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(string, object);
                }
                HashMap hashMap = (HashMap)object;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("SupportedTestType");
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    hashMap.put(iConfigurationElementArray2[n2].getAttribute("name"), string2);
                    ++n2;
                }
                ++n;
            }
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutionEnvironmentAdapter", "EXECUTION_ENVIRONMENT_ADAPTER", bl);
            this.mapAdapterClasses("org.eclipse.hyades.execution.harness.ExecutableObjectAdapter", "EXECUTABLE_OBJECT_ADAPTER", bl);
        } else {
            StandaloneExecutionUtilities.initializeRegisteredExecutionComponents(this.standaloneConfigurationFiles, testTypeMap, iExecutionComponentFactory, executionHarnessDataProcessorFactory);
        }
    }

    private void mapAdapterClasses(String string, String string2, boolean bl) {
        if (!bl) {
            IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor(string);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                String string3 = iConfigurationElementArray[n].getAttribute("class");
                Object object = testTypeMap.get(string2);
                if (object == null) {
                    object = new HashMap();
                    testTypeMap.put(string2, object);
                }
                HashMap hashMap = (HashMap)object;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren("SupportedTestType");
                int n2 = 0;
                while (n2 < iConfigurationElementArray2.length) {
                    hashMap.put(iConfigurationElementArray2[n2].getAttribute("name"), iConfigurationElementArray[n]);
                    ++n2;
                }
                ++n;
            }
        }
    }

    protected String getExecutionComponentForTestType(String string, String string2, boolean bl) throws ClassNotFoundException {
        Object object;
        Object v = testTypeMap.get(string);
        if (v != null && v instanceof HashMap && (v = ((HashMap)(object = (HashMap)v)).get(string2)) != null && v instanceof String) {
            return (String)v;
        }
        object = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        object = StringUtil.change((String)object, (String)"%1", (String)string);
        object = StringUtil.change((String)object, (String)"%2", (String)string2);
        throw new ClassNotFoundException((String)object);
    }

    public synchronized IExecutor launchTest(ITestSuite iTestSuite, ITest iTest, String string, String string2, String string3, String string4, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        ArrayList<String> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<String>();
            arrayList.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        return this.launchTest(iTestSuite, iTest, string, null, string2, string3, string4, bl2, arrayList, stringBuffer);
    }

    public synchronized IExecutor launchTest(ITestSuite iTestSuite, ITest iTest, TPFDeployment tPFDeployment, String string, String string2, String string3, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        ArrayList<String> arrayList = null;
        if (bl) {
            arrayList = new ArrayList<String>();
            arrayList.add("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor");
        }
        return this.launchTest(iTestSuite, iTest, null, tPFDeployment, string, string2, string3, bl2, arrayList, stringBuffer);
    }

    public synchronized IExecutor launchTest(ITestSuite iTestSuite, ITest iTest, TPFDeployment tPFDeployment, String string, String string2, String string3, boolean bl, ArrayList arrayList, StringBuffer stringBuffer) {
        return this.launchTest(iTestSuite, iTest, null, tPFDeployment, string, string2, string3, bl, arrayList, stringBuffer);
    }

    private synchronized IExecutor launchTest(ITestSuite iTestSuite, ITest iTest, String string, TPFDeployment tPFDeployment, String string2, String string3, String string4, boolean bl, ArrayList arrayList, StringBuffer stringBuffer) {
        this.factory = null;
        this.session = null;
        this.exeEnvironment = null;
        this.executor = null;
        this.node = null;
        stringBuffer.setLength(0);
        try {
            String string5 = iTest.getType();
            String string6 = null;
            string6 = tPFDeployment != null ? DeploymentUtilities.getTestMachine(iTestSuite, iTest, tPFDeployment) : string;
            this.session = this.sessionConnect(string2, this.session, string6, stringBuffer);
            if (this.session == null) {
                return null;
            }
            this.factory = bl ? ExecutionComponentFactoryImpl.getInstance((ISession)this.session) : EclipseExecutionComponentFactoryImpl.getInstance((ISession)this.session);
            if (!this.bFactoryInitialized) {
                this.dpFactory = new ExecutionHarnessDataProcessorFactory(bl);
                this.initializeRegisteredExecutionComponents(this.factory, bl, this.dpFactory);
                this.bFactoryInitialized = true;
            }
            String string7 = this.getExecutionComponentForTestType("ENVIRONMENT", string5, bl);
            this.exeEnvironment = (IExecutionEnvironment)this.factory.createExecutionComponentByType(string7);
            this.session.addChild((IExecutionComponent)this.exeEnvironment);
            if (!this.adaptExecutionEnvironment(iTestSuite, iTest, bl, string5, tPFDeployment, stringBuffer)) {
                return null;
            }
            String string8 = this.getExecutionComponentForTestType("EXECUTOR", string5, bl);
            this.executor = (IExecutor)this.factory.createExecutionComponentByType(string8);
            this.exeEnvironment.addChild((IExecutionComponent)this.executor);
            String string9 = this.getExecutionComponentForTestType("EXECUTABLEOBJECT", string5, bl);
            IExecutableObject iExecutableObject = this.executor.getCompatibleExecutableObject(string9);
            if (!this.adaptExecutableObject(iExecutableObject, iTestSuite, iTest, bl, string5, tPFDeployment, stringBuffer)) {
                return null;
            }
            if (iExecutableObject != null) {
                this.executor.setExecutableObject(iExecutableObject);
                if (this.executor instanceof ExecutorStub) {
                    ((ExecutorStub)this.executor).setExecutionResultLocation(string3);
                    ((ExecutorStub)this.executor).setExecutionResultName(string4);
                }
            }
            String string10 = this.getExecutionComponentForTestType("AGENT", string5, bl);
            if (arrayList != null && arrayList.size() > 0 && this.executor instanceof ExecutorStub) {
                ArrayList arrayList2 = this.initValidDataProcessors(iTest, string6, string10, string4, string3, string2, arrayList);
                IExecutionHarnessDataProcessor[] iExecutionHarnessDataProcessorArray = this.convertListToArray(arrayList2);
                this.setAgentData(iTestSuite, iExecutableObject, (IDataProcessor[])iExecutionHarnessDataProcessorArray);
                ((ExecutorStub)this.executor).setDataProcessors((IDataProcessor[])iExecutionHarnessDataProcessorArray);
            } else {
                this.initializeRemoteHyadesComponent(string10, null);
            }
            this.executor.launch();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.systemUtility.logError(classNotFoundException);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("CLASS_NOT_FOUND_ERR_"), (String)"%1", (String)classNotFoundException.getMessage()));
        }
        catch (Throwable throwable) {
            this.systemUtility.logError(throwable);
            stringBuffer.append(throwable.getMessage());
        }
        return null;
    }

    private IExecutionHarnessDataProcessor[] convertListToArray(ArrayList arrayList) {
        IExecutionHarnessDataProcessor[] iExecutionHarnessDataProcessorArray = new IExecutionHarnessDataProcessor[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            iExecutionHarnessDataProcessorArray[n] = (IExecutionHarnessDataProcessor)arrayList.get(n);
            ++n;
        }
        return iExecutionHarnessDataProcessorArray;
    }

    private void setAgentData(ITestSuite iTestSuite, IExecutableObject iExecutableObject, IDataProcessor[] iDataProcessorArray) throws CoreException {
        if (iExecutableObject instanceof JavaProcessExecutableObjectStub && iDataProcessorArray != null && iDataProcessorArray.length > 1) {
            String string = "AgentIDs:";
            int n = 1;
            while (n < iDataProcessorArray.length) {
                string = string + ((IExecutionHarnessDataProcessor)iDataProcessorArray[n]).getID();
                if (n < iDataProcessorArray.length - 1) {
                    string = string + ",";
                }
                ++n;
            }
            ((JavaProcessExecutableObjectStub)iExecutableObject).setAgentData(string);
        }
    }

    private void initializeRemoteHyadesComponent(String string, IExecutionHarnessDataProcessor iExecutionHarnessDataProcessor) {
        IRemoteHyadesComponent iRemoteHyadesComponent = (IRemoteHyadesComponent)this.factory.createExecutionComponentByType(string);
        this.executor.addChild((IExecutionComponent)iRemoteHyadesComponent);
        iRemoteHyadesComponent.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

            public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
                if (executionComponentStateChangeEvent.getState() == 2) {
                    TestExecutionHarness.this.releaseAgentLock();
                }
            }
        });
        if (iExecutionHarnessDataProcessor != null) {
            iRemoteHyadesComponent.startMonitoring((IDataProcessor)iExecutionHarnessDataProcessor);
        }
        this.waitForActiveAgent(iRemoteHyadesComponent);
    }

    private ArrayList loadDataProcessors() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.Dataprocessor");
        ArrayList<IExecutionHarnessDataProcessor> arrayList = new ArrayList<IExecutionHarnessDataProcessor>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            try {
                IExecutionHarnessDataProcessor iExecutionHarnessDataProcessor = (IExecutionHarnessDataProcessor)iConfigurationElementArray[n].createExecutableExtension("class");
                arrayList.add(iExecutionHarnessDataProcessor);
            }
            catch (CoreException coreException) {
                this.systemUtility.logError(coreException);
            }
            ++n;
        }
        return arrayList;
    }

    private ArrayList initValidDataProcessors(ITest iTest, String string, String string2, String string3, String string4, String string5, ArrayList arrayList) throws CoreException {
        ArrayList<IExecutionHarnessDataProcessor> arrayList2 = new ArrayList<IExecutionHarnessDataProcessor>();
        int n = 0;
        while (n < this.dpFactory.getDataProcessors().size()) {
            IExecutionHarnessDataProcessor iExecutionHarnessDataProcessor = (IExecutionHarnessDataProcessor)this.dpFactory.getDataProcessors().get(n);
            if (arrayList.contains(iExecutionHarnessDataProcessor.getID())) {
                iExecutionHarnessDataProcessor.setInitData(iTest, string, string3, string4, string5);
                if (iExecutionHarnessDataProcessor.getID().equalsIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor")) {
                    arrayList2.add(0, iExecutionHarnessDataProcessor);
                } else {
                    arrayList2.add(iExecutionHarnessDataProcessor);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            IExecutionHarnessDataProcessor iExecutionHarnessDataProcessor = (IExecutionHarnessDataProcessor)arrayList2.get(n2);
            if (n2 == 0 && iExecutionHarnessDataProcessor.getID().compareToIgnoreCase("org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor") != 0) {
                this.initializeRemoteHyadesComponent(string2, null);
            } else {
                this.initializeRemoteHyadesComponent(string2, iExecutionHarnessDataProcessor);
            }
            ++n2;
        }
        return arrayList2;
    }

    private void waitForActiveAgent(IRemoteHyadesComponent iRemoteHyadesComponent) {
        if (iRemoteHyadesComponent.getState() == 3) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private Object getAdapterInstance(String string, String string2, boolean bl) throws ClassNotFoundException {
        Object object;
        Object v = testTypeMap.get(string);
        if (v != null && v instanceof HashMap) {
            object = (HashMap)v;
            v = ((HashMap)object).get(string2);
            try {
                if (bl) {
                    if (v != null && v instanceof String) {
                        return Class.forName((String)v).newInstance();
                    }
                } else if (v != null && v instanceof ConfigurationElement) {
                    return ((ConfigurationElement)v).createExecutableExtension("class");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.systemUtility.getString("EXEC_NOT_FOUND_ERR_");
        object = StringUtil.change((String)object, (String)"%1", (String)string);
        object = StringUtil.change((String)object, (String)"%2", (String)string2);
        throw new ClassNotFoundException((String)object);
    }

    private boolean adaptExecutableObject(IExecutableObject iExecutableObject, ITestSuite iTestSuite, ITest iTest, boolean bl, String string, TPFDeployment tPFDeployment, StringBuffer stringBuffer) {
        IExecutableObjectAdapter iExecutableObjectAdapter = null;
        try {
            iExecutableObjectAdapter = (IExecutableObjectAdapter)this.getAdapterInstance("EXECUTABLE_OBJECT_ADAPTER", string, bl);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutableObjectAdapter != null) {
            iExecutableObjectAdapter.setupExecutableObject(iExecutableObject, (TPFTestSuite)iTestSuite, (TPFTest)iTest, tPFDeployment);
        }
        if (iExecutableObject instanceof JavaProcessExecutableObjectStub) {
            JavaProcessExecutableObjectStub javaProcessExecutableObjectStub = (JavaProcessExecutableObjectStub)iExecutableObject;
            String string2 = javaProcessExecutableObjectStub.getArgs();
            string2 = string2 + " org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
            javaProcessExecutableObjectStub.setArgs(string2);
        }
        return true;
    }

    private boolean adaptExecutionEnvironment(ITestSuite iTestSuite, ITest iTest, boolean bl, String string, TPFDeployment tPFDeployment, StringBuffer stringBuffer) {
        IExecutionEnvironmentAdapter iExecutionEnvironmentAdapter = null;
        try {
            iExecutionEnvironmentAdapter = (IExecutionEnvironmentAdapter)this.getAdapterInstance("EXECUTION_ENVIRONMENT_ADAPTER", string, bl);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("EXEC_ENV_ERR_"), (String)"%1", (String)string));
            return false;
        }
        if (iExecutionEnvironmentAdapter != null) {
            iExecutionEnvironmentAdapter.setupExecutionEnvironment(this.exeEnvironment, (TPFTestSuite)iTestSuite, (TPFTest)iTest, null);
        }
        return true;
    }

    private ISession sessionConnect(String string, ISession iSession, String string2, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        try {
            HyadesTestNodeImpl hyadesTestNodeImpl = new HyadesTestNodeImpl(string2);
            iSession = hyadesTestNodeImpl.connect(string, null);
        }
        catch (UnknownHostException unknownHostException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("TIMEOUT_NODE_ERROR_"), (String)"%1", (String)string2));
        }
        catch (AgentControllerUnavailableException agentControllerUnavailableException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string2));
        }
        catch (UnknownDaemonException unknownDaemonException) {
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("AGENT_UNAV_ERROR_"), (String)"%1", (String)string2));
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("RUN_FAILED_ERR_"), (String)"%1", (String)string2));
        }
        return iSession;
    }

    private ISession getSession(String string, ISession iSession, String string2, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        SessionContext sessionContext = new SessionContext(string2, string, null);
        return SessionContextToSessionMap.getSession((SessionContext)sessionContext);
    }

    public IExecutor launchTest(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        Object object = null;
        ITestSuite iTestSuite = null;
        stringBuffer.setLength(0);
        try {
            iTestSuite = HyadesFactory.INSTANCE.loadTestSuite(string);
        }
        catch (Exception exception) {
            this.systemUtility.logError(exception);
            stringBuffer.append(StringUtil.change((String)this.systemUtility.getString("LOAD_SUITE_ERR_"), (String)"%1", (String)string));
            return null;
        }
        object = string2 != null && string2.length() != 0 ? (ITest)HyadesFactory.INSTANCE.getObjectByID(iTestSuite, string2) : iTestSuite;
        return this.launchTest(iTestSuite, (ITest)object, string3, string4, string5, string6, bl, bl2, stringBuffer);
    }

    private String[] getStandaloneConfigurationFiles() {
        return this.standaloneConfigurationFiles;
    }

    private void setStandaloneConfigurationFiles(String[] stringArray) {
        this.standaloneConfigurationFiles = stringArray;
    }

    public synchronized String stopTest(ITestSuite iTestSuite, ITest iTest, CFGLocation cFGLocation, String string, TPFExecutionResult tPFExecutionResult) {
        String string2 = ((CFGMachineConstraint)cFGLocation).getHostname();
        StringBuffer stringBuffer = new StringBuffer();
        this.session = this.getSession(string, this.session, string2, stringBuffer);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)string2);
        }
        try {
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<IExecutionComponent> arrayList = new ArrayList<IExecutionComponent>();
            IExecutionComponent[] iExecutionComponentArray = this.session.getChildren();
            int n = 0;
            while (n < iExecutionComponentArray.length) {
                if (iExecutionComponentArray[n] instanceof IExecutionEnvironment) {
                    IExecutionComponent[] iExecutionComponentArray2 = iExecutionComponentArray[n].getChildren();
                    int n2 = 0;
                    while (n2 < iExecutionComponentArray2.length) {
                        ExecutableObjectStub executableObjectStub;
                        if (iExecutionComponentArray2[n2] instanceof ExecutorStub && (executableObjectStub = (ExecutableObjectStub)((IExecutor)iExecutionComponentArray2[n2]).getExecutableObject()).getTestID().equals(iTest.getId()) && executableObjectStub.getSuiteID().equals(iTestSuite.getId()) && ((ExecutorStub)iExecutionComponentArray2[n2]).getExecutionResultName().equals(tPFExecutionResult.getName())) {
                            bl2 = true;
                            IExecutionComponent[] iExecutionComponentArray3 = iExecutionComponentArray2[n2].getChildren();
                            int n3 = 0;
                            while (n3 < iExecutionComponentArray3.length) {
                                if (iExecutionComponentArray3[n3] instanceof IRemoteHyadesComponent) {
                                    this.StopMonitoringAndWait((IRemoteHyadesComponent)iExecutionComponentArray3[n3]);
                                    arrayList.add(iExecutionComponentArray3[n3]);
                                }
                                ++n3;
                            }
                            ((IExecutor)iExecutionComponentArray2[n2]).kill();
                            this.RemoveChildComponents(arrayList, iExecutionComponentArray2[n2]);
                            arrayList.clear();
                            bl = true;
                            if (iExecutionComponentArray2[n2].getChildren().length == 0) {
                                arrayList.add(iExecutionComponentArray2[n2]);
                            }
                        }
                        ++n2;
                    }
                    this.RemoveChildComponents(arrayList, iExecutionComponentArray[n]);
                    arrayList.clear();
                    if (iExecutionComponentArray[n].getChildren().length == 0) {
                        arrayList.add(iExecutionComponentArray[n]);
                    }
                }
                ++n;
            }
            this.RemoveChildComponents(arrayList, (IExecutionComponent)this.session);
            if (!bl) {
                if (!bl2) {
                    return this.systemUtility.getString("NO_TEST_TO_STOP_ERROR_");
                }
                return this.systemUtility.getString("TEST_STOP_ERROR_");
            }
            this.logStopEvents(tPFExecutionResult);
            tPFExecutionResult.eResource().save(Collections.EMPTY_MAP);
        }
        catch (Throwable throwable) {
            this.systemUtility.logError(throwable);
            return throwable.getMessage();
        }
        return null;
    }

    private void logStopEvents(TPFExecutionResult tPFExecutionResult) {
        String string = this.systemUtility.getString("TEST_ABORTED_MESSAGE_");
        TPFVerdictEvent tPFVerdictEvent = Common_TestprofileFactory.eINSTANCE.createTPFVerdictEvent();
        tPFVerdictEvent.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
        tPFVerdictEvent.setReason(TPFVerdictReason.ABORT_LITERAL);
        tPFVerdictEvent.setText(string);
        tPFVerdictEvent.setExecutionHistory(tPFExecutionResult.getExecutionHistory());
        TPFTypedEvent tPFTypedEvent = Common_TestprofileFactory.eINSTANCE.createTPFTypedEvent();
        tPFTypedEvent.setType(TPFExecutionType.STOP_LITERAL);
        tPFTypedEvent.setText(string);
        tPFTypedEvent.setTimestamp(System.currentTimeMillis());
        tPFTypedEvent.setExecutionHistory(tPFExecutionResult.getExecutionHistory());
        tPFExecutionResult.setVerdict(TPFVerdict.INCONCLUSIVE_LITERAL);
    }

    private void waitForInactiveAgent(IRemoteHyadesComponent iRemoteHyadesComponent) {
        if (iRemoteHyadesComponent.getState() == 2) {
            while (!this.bAgentReady) {
                Object object = this.agentLock;
                synchronized (object) {
                    try {
                        this.agentLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void StopMonitoringAndWait(IRemoteHyadesComponent iRemoteHyadesComponent) throws InterruptedException {
        iRemoteHyadesComponent.stopMonitoring();
        Thread.sleep(3000L);
    }

    private void RemoveChildComponents(ArrayList arrayList, IExecutionComponent iExecutionComponent) {
        int n = 0;
        while (n < arrayList.size()) {
            iExecutionComponent.removeChild((IExecutionComponent)arrayList.get(n));
            ++n;
        }
    }

    public synchronized String performControlEvent(ITestSuite iTestSuite, ITest iTest, CFGLocation cFGLocation, String string, TPFExecutionResult tPFExecutionResult, String string2) {
        String string3 = ((CFGMachineConstraint)cFGLocation).getHostname();
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.canSupportControlEvent(iTestSuite, iTest, cFGLocation, string, tPFExecutionResult, string2)) {
            return StringUtil.change((String)this.systemUtility.getString("CANNOT_SUPPORT_MSG_"), (String)"%1", (String)string2);
        }
        this.session = this.getSession(string, this.session, string3, stringBuffer);
        if (this.session == null) {
            return StringUtil.change((String)this.systemUtility.getString("NO_SESSION_FOUND_ERROR"), (String)"%1", (String)string3);
        }
        String string4 = null;
        try {
            boolean bl = false;
            IExecutionComponent[] iExecutionComponentArray = this.session.getChildren();
            int n = 0;
            while (n < iExecutionComponentArray.length) {
                if (iExecutionComponentArray[n] instanceof IExecutionEnvironment) {
                    IExecutionComponent[] iExecutionComponentArray2 = iExecutionComponentArray[n].getChildren();
                    int n2 = 0;
                    while (n2 < iExecutionComponentArray2.length) {
                        ExecutableObjectStub executableObjectStub;
                        if (iExecutionComponentArray2[n2] instanceof ExecutorStub && (executableObjectStub = (ExecutableObjectStub)((IExecutor)iExecutionComponentArray2[n2]).getExecutableObject()).getTestID().equals(iTest.getId()) && executableObjectStub.getSuiteID().equals(iTestSuite.getId()) && ((ExecutorStub)iExecutionComponentArray2[n2]).getExecutionResultName().equals(tPFExecutionResult.getName()) && (string4 = ((IExecutor)iExecutionComponentArray2[n2]).performControlEvent("CONTROL_EVENT_SUSPEND")) == null) {
                            bl = true;
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            if (!bl) {
                if (string4 == null) {
                    return StringUtil.change((String)this.systemUtility.getString("CANNOT_PERFORM_MSG_"), (String)"%1", (String)string2);
                }
                return string4;
            }
        }
        catch (Throwable throwable) {
            this.systemUtility.logError(throwable);
            return throwable.getMessage();
        }
        return null;
    }

    public synchronized boolean canSupportControlEvent(ITestSuite iTestSuite, ITest iTest, CFGLocation cFGLocation, String string, TPFExecutionResult tPFExecutionResult, String string2) {
        String string3 = ((CFGMachineConstraint)cFGLocation).getHostname();
        StringBuffer stringBuffer = new StringBuffer();
        this.session = this.getSession(string, this.session, string3, stringBuffer);
        if (this.session == null) {
            return false;
        }
        boolean bl = false;
        IExecutionComponent[] iExecutionComponentArray = this.session.getChildren();
        int n = 0;
        while (n < iExecutionComponentArray.length) {
            if (iExecutionComponentArray[n] instanceof IExecutionEnvironment) {
                IExecutionComponent[] iExecutionComponentArray2 = iExecutionComponentArray[n].getChildren();
                int n2 = 0;
                while (n2 < iExecutionComponentArray2.length) {
                    ExecutableObjectStub executableObjectStub;
                    if (iExecutionComponentArray2[n2] instanceof ExecutorStub && (executableObjectStub = (ExecutableObjectStub)((IExecutor)iExecutionComponentArray2[n2]).getExecutableObject()).getTestID().equals(iTest.getId()) && executableObjectStub.getSuiteID().equals(iTestSuite.getId()) && ((ExecutorStub)iExecutionComponentArray2[n2]).getExecutionResultName().equals(tPFExecutionResult.getName())) {
                        if (((IExecutor)iExecutionComponentArray2[n2]).supportsControlEvent(string2)) {
                            bl = true;
                        } else {
                            return false;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }
}

