/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.net.InetAddress;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

public class XMLExecutionDataProcessor
extends XMLLoader
implements DataServerListener,
IExecutionHarnessDataProcessor {
    private final String START_TAG = "<EXECUTION>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    public static final String IID = "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
    private ITest test = null;
    private Agent controlAgent = null;
    private Process process = null;
    private String hostName;
    private String executionResultName;
    private String executionResultLocation;
    private String portNumber;

    public XMLExecutionDataProcessor() {
        super((TRCMonitor)null);
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == null) {
                return true;
            }
            if (this.currentElementName.equals("EXECUTION")) {
                return true;
            }
            this.startDocument = false;
        }
        return false;
    }

    protected boolean isValidTag(String string) {
        return !string.startsWith("<EXECUTION>") && !string.startsWith("<?xml version=\"1.0\"?>");
    }

    public void dataServerExited() {
        ExecutionContext executionContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        executionContext.cleanUp();
        this.cleanUp();
    }

    public void incommingData(byte[] byArray, int n, InetAddress inetAddress) {
        try {
            super.loadEvent(byArray, n);
        }
        catch (InvalidXMLException invalidXMLException) {
            // empty catch block
        }
    }

    public void incommingData(char[] cArray, int n, InetAddress inetAddress) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        this.incommingData(byArray, byArray.length, inetAddress);
    }

    public void invalidDataType(byte[] byArray, int n, InetAddress inetAddress) {
    }

    public void waitingForData() {
    }

    public void init() {
        this.defaultLoader = new IgnoredXMLFragmentLoader();
        if (!(this.getTest() instanceof TPFTestSuite)) {
            return;
        }
        TPFTestSuite tPFTestSuite = (TPFTestSuite)this.getTest();
        ExecutionContext executionContext = new ExecutionContext(tPFTestSuite, tPFTestSuite.getId(), this.executionResultLocation, this.executionResultName);
        this.context.getCustomData().put(ExecutionContext.root, executionContext);
    }

    public IConfigurationElement getConfigElement() {
        return null;
    }

    public String getID() {
        return IID;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setConfigElement(IConfigurationElement iConfigurationElement) {
    }

    public ITest getTest() {
        return this.test;
    }

    public Agent getControlAgent() {
        return this.controlAgent;
    }

    public void setControlAgent(Agent agent) {
        this.controlAgent = agent;
    }

    public void setInitData(ITest iTest, String string, String string2, String string3, String string4) {
        this.test = iTest;
        this.hostName = string;
        this.executionResultName = string2;
        this.executionResultLocation = string3;
        this.portNumber = string4;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

