/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.test.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.hyades.ui.internal.util.FileUtil;

public class FileUtilTest
extends TestCase {
    public static final String TEST_ARTIFACTS_PATH = "artifacts/util/";
    static /* synthetic */ Class class$org$eclipse$hyades$ui$test$util$FileUtilTest;

    public FileUtilTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("Hyades UI File Util");
        testSuite.addTestSuite(class$org$eclipse$hyades$ui$test$util$FileUtilTest == null ? (class$org$eclipse$hyades$ui$test$util$FileUtilTest = FileUtilTest.class$("org.eclipse.hyades.ui.test.util.FileUtilTest")) : class$org$eclipse$hyades$ui$test$util$FileUtilTest);
        return testSuite;
    }

    public void testAppendPath() {
        String string = "c:\\temp";
        String string2 = "download\\eclipse.zip";
        Assert.assertEquals((String)"c:/temp/download/eclipse.zip", (String)FileUtil.appendPath((String)string, (String)string2));
        string = "c:\\temp\\";
        string2 = "\\download/eclipse.zip";
        Assert.assertEquals((String)"c:/temp/download/eclipse.zip", (String)FileUtil.appendPath((String)string, (String)string2));
        string = "\\temp";
        string2 = "/download/eclipse.zip";
        Assert.assertEquals((String)"/temp/download/eclipse.zip", (String)FileUtil.appendPath((String)string, (String)string2));
        string = "temp/";
        string2 = "/download/eclipse.zip";
        Assert.assertEquals((String)"temp/download/eclipse.zip", (String)FileUtil.appendPath((String)string, (String)string2));
        string = "http://www.eclipse.org";
        string2 = "hyades";
        Assert.assertEquals((String)"http://www.eclipse.org/hyades", (String)FileUtil.appendPath((String)string, (String)string2));
        string = "";
        string2 = "\\hyades";
        Assert.assertEquals((String)"/hyades", (String)FileUtil.appendPath((String)string, (String)string2));
    }

    public void testDelete() throws IOException {
        File file = this.getUnexistingDirectoryHandle();
        String string = "Base directory:" + file.getAbsolutePath();
        Assert.assertTrue((String)string, (boolean)file.mkdir());
        File file2 = new File(file, "file1.tmp");
        Assert.assertTrue((String)string, (boolean)file2.createNewFile());
        File file3 = new File(file, "file2.tmp");
        Assert.assertTrue((String)string, (boolean)file3.createNewFile());
        Assert.assertEquals((String)string, (int)1, (int)FileUtil.delete((File)file2));
        Assert.assertFalse((String)string, (boolean)file2.exists());
        Assert.assertTrue((String)string, (boolean)file3.exists());
        File file4 = new File(file, "dir1/f1.tmp");
        Assert.assertTrue((String)string, (boolean)file4.getParentFile().mkdir());
        Assert.assertTrue((String)string, (boolean)file4.createNewFile());
        file4 = new File(file, "dir1/f2.tmp");
        Assert.assertTrue((String)string, (boolean)file4.createNewFile());
        file4 = new File(file, "dir2/f1.tmp");
        Assert.assertTrue((String)string, (boolean)file4.getParentFile().mkdir());
        Assert.assertTrue((String)string, (boolean)file4.createNewFile());
        file4 = new File(file, "dir2/dir21/f1.tmp");
        Assert.assertTrue((String)string, (boolean)file4.getParentFile().mkdir());
        Assert.assertTrue((String)string, (boolean)file4.createNewFile());
        Assert.assertEquals((String)string, (int)9, (int)FileUtil.delete((File)file));
        Assert.assertFalse((String)string, (boolean)file.exists());
    }

    public void testGetFileExtension() {
        Assert.assertEquals((String)"txt", (String)FileUtil.getFileExtension((File)new File("artifacts/util/test.txt")));
        Assert.assertEquals((String)"log", (String)FileUtil.getFileExtension((File)new File(".log")));
        Assert.assertEquals((String)"", (String)FileUtil.getFileExtension((File)new File("test")));
    }

    public void testGetLastSegment() {
        Assert.assertEquals((String)"test", (String)FileUtil.getLastSegment((String)"x:\\temp\\test"));
        Assert.assertEquals((String)"temp", (String)FileUtil.getLastSegment((String)"/temp"));
        Assert.assertEquals((String)"test", (String)FileUtil.getLastSegment((String)"test"));
        Assert.assertEquals((String)"test", (String)FileUtil.getLastSegment((String)"/test/"));
    }

    public void testGetTempDir() {
    }

    public void testGetValidFileOrDirectory() throws IOException {
        File file = this.getUnexistingDirectoryHandle();
        Assert.assertTrue((String)file.toString(), (boolean)file.mkdir());
        File file2 = new File(file, "test.tmp");
        Assert.assertTrue((String)file2.toString(), (boolean)file2.createNewFile());
        Assert.assertEquals((Object)file2, (Object)FileUtil.getValidFileOrDirectory((File)file2));
        Assert.assertEquals((Object)file, (Object)FileUtil.getValidFileOrDirectory((File)file));
        file2.delete();
        Assert.assertNull((Object)FileUtil.getValidFileOrDirectory((File)file2));
        Assert.assertEquals((Object)file, (Object)FileUtil.getValidFileOrDirectory((File)file));
        file.delete();
        Assert.assertNull((Object)FileUtil.getValidFileOrDirectory((File)file2));
        Assert.assertNull((Object)FileUtil.getValidFileOrDirectory((File)file));
    }

    public void testGetZipEntryDataByZipEntryName() {
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("artifacts/util/test.zip");
        Assert.assertNotNull((Object)uRL);
        File file = new File(uRL.getFile());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.exists());
        Map map = FileUtil.getZipEntryDataByZipEntryName((String)file.getAbsolutePath());
        Assert.assertEquals((int)6, (int)map.size());
        Assert.assertNotNull(map.get("test/text1.txt"));
        Assert.assertNotNull(map.get("test/text2.txt"));
        Assert.assertNotNull(map.get("test/folder1/text1.txt"));
        Assert.assertNotNull(map.get("test/folder1/text2.txt"));
        Assert.assertNotNull(map.get("test/folder2/text1.txt"));
        Assert.assertNotNull(map.get("test/folder2/text2.txt"));
    }

    public void testIsParent() {
        File file = new File("/home/usr/public");
        File file2 = new File(file, "xyz/temp/test.tst");
        Assert.assertTrue((boolean)FileUtil.isParent((File)file, (File)file2));
        file2 = new File("xyz/temp/test.tst");
        Assert.assertFalse((boolean)FileUtil.isParent((File)file, (File)file2));
        Assert.assertTrue((boolean)FileUtil.isParent((File)file2, (File)file2));
    }

    public void testNormalizePath() {
        Assert.assertEquals((String)"c:/temp", (String)FileUtil.normalizePath((String)"c:\\temp\\"));
        Assert.assertEquals((String)"/home/temp", (String)FileUtil.normalizePath((String)"/home/temp"));
        Assert.assertEquals((String)"//home/temp", (String)FileUtil.normalizePath((String)" //home\\temp/ "));
    }

    public void testReadFromFile() throws IOException {
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("artifacts/util/test.txt");
        File file = new File(uRL.getFile());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.exists());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.canRead());
        String string = "This is the line 1\r\nThis is the line 2\r\nThis is the line 3\r\n\r\nThis is the line 5";
        Assert.assertEquals((String)string, (String)FileUtil.readFromFile((String)"UTF-8", (File)file, (boolean)false));
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.canWrite());
    }

    public void testReadFromInputStream() throws IOException {
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("artifacts/util/test.txt");
        Assert.assertNotNull((Object)uRL);
        File file = new File(uRL.getFile());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.exists());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.canRead());
        InputStream inputStream = new FileInputStream(file);
        String string = "This is the line 1\r\nThis is the line 2\r\nThis is the line 3\r\n\r\nThis is the line 5";
        Assert.assertEquals((String)string, (String)FileUtil.readFromInputStream((String)"UTF-8", (InputStream)inputStream, (boolean)false));
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.canWrite());
        String string2 = "\u4e13a\u00e1\u00e0\u00e2\u00e4\u00e3\u4e13\u00e7\u4e13";
        inputStream = new ByteArrayInputStream(string2.getBytes("UTF-16"));
        Assert.assertEquals((String)string2, (String)FileUtil.readFromInputStream((String)"UTF-16", (InputStream)inputStream, (boolean)false));
    }

    public void testRemoveLastSegment() {
        Assert.assertEquals((String)"c:/temp", (String)FileUtil.removeLastSegment((String)"c:\\temp\\test.tst"));
        Assert.assertEquals((String)"", (String)FileUtil.removeLastSegment((String)"test.tst"));
        Assert.assertEquals((String)"//home/temp", (String)FileUtil.removeLastSegment((String)"//home/temp\\test.tst"));
    }

    public void testWriteToFile() throws IOException {
        File file = this.getUnexistingDirectoryHandle();
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.mkdir());
        File file2 = new File(file, "writeToFile.test");
        String string = "This is a\r\ntest of the\r\n\t\"WriteToFile\"\r\nmethod of the class\r\n\tFileUtil";
        Assert.assertTrue((String)file2.getAbsolutePath(), (boolean)FileUtil.writeToFile((String)"UTF-8", (File)file2, (boolean)false, (String)string));
        String string2 = FileUtil.readFromFile((String)"UTF-8", (File)file2, (boolean)false);
        Assert.assertEquals((String)file2.getAbsolutePath(), (String)string, (String)string2);
        Assert.assertTrue((String)file2.getAbsolutePath(), (boolean)FileUtil.writeToFile((String)"UTF-8", (File)file2, (boolean)true, (String)string));
        string2 = FileUtil.readFromFile((String)"UTF-8", (File)file2, (boolean)false);
        Assert.assertEquals((String)file2.getAbsolutePath(), (String)(string + string), (String)string2);
        Assert.assertTrue((String)file2.getAbsolutePath(), (boolean)file2.delete());
        Assert.assertTrue((String)file2.getAbsolutePath(), (boolean)FileUtil.writeToFile((String)"UTF-8", (File)file2, (boolean)true, (String)string));
        string2 = FileUtil.readFromFile((String)"UTF-8", (File)file2, (boolean)false);
        Assert.assertEquals((String)file2.getAbsolutePath(), (String)string, (String)string2);
        Assert.assertTrue((String)file2.getAbsolutePath(), (boolean)file2.delete());
        Assert.assertTrue((String)file.getAbsolutePath(), (boolean)file.delete());
    }

    public void testWriteToOutputStream() throws IOException {
        String string = "\u4e13a\u00e1\u00e0\u00e2\u00e4\u00e3\u4e13\u00e7\u4e13";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)FileUtil.writeToOutputStream((String)"UTF-16", (OutputStream)byteArrayOutputStream, (String)string));
        Assert.assertTrue((boolean)Arrays.equals(string.getBytes("UTF-16"), byteArrayOutputStream.toByteArray()));
    }

    public void testCopyFiles() throws IOException {
        int n;
        int n2;
        File[] fileArray = new File[5];
        URL uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("artifacts/util/test.txt");
        fileArray[0] = new File(uRL.getFile()).getAbsoluteFile();
        Assert.assertTrue((String)fileArray[0].getAbsolutePath(), (boolean)fileArray[0].exists());
        uRL = ((Object)((Object)this)).getClass().getClassLoader().getResource("artifacts/util/test.zip");
        fileArray[1] = new File(uRL.getFile()).getAbsoluteFile();
        Assert.assertTrue((String)fileArray[1].getAbsolutePath(), (boolean)fileArray[1].exists());
        fileArray[2] = fileArray[1].getParentFile();
        File file = this.getUnexistingDirectoryHandle();
        new File(file, fileArray[0].getName()).mkdir();
        Assert.assertEquals((int)2, (int)FileUtil.copyFiles((File[])fileArray, (File)file, (boolean)false));
        File[] fileArray2 = file.listFiles();
        Assert.assertEquals((int)2, (int)fileArray2.length);
        int n3 = 0;
        int n4 = fileArray2.length;
        while (n3 < n4) {
            n2 = 0;
            n = fileArray.length;
            while (n2 < n) {
                if (fileArray[n2] != null && fileArray2[n3].getName().equals(fileArray[n2].getName())) {
                    Assert.assertEquals((long)fileArray[n2].length(), (long)fileArray2[n3].length());
                }
                ++n2;
            }
            ++n3;
        }
        Assert.assertEquals((int)0, (int)FileUtil.copyFiles((File[])fileArray, (File)file, (boolean)false));
        Assert.assertEquals((int)2, (int)FileUtil.copyFiles((File[])fileArray, (File)file, (boolean)true));
        fileArray2 = file.listFiles();
        Assert.assertEquals((int)2, (int)fileArray2.length);
        n2 = 0;
        n = fileArray2.length;
        while (n2 < n) {
            int n5 = 0;
            int n6 = fileArray.length;
            while (n5 < n6) {
                if (fileArray[n5] != null && fileArray2[n2].getName().equals(fileArray[n5].getName())) {
                    Assert.assertEquals((long)fileArray[n5].length(), (long)fileArray2[n2].length());
                }
                ++n5;
            }
            ++n2;
        }
        FileUtil.delete((File)file);
    }

    private synchronized File getUnexistingDirectoryHandle() {
        String string = "baseTestDir";
        int n = 0;
        while (n < 200) {
            File file = new File(string + n);
            if (!file.exists()) {
                return file.getAbsoluteFile();
            }
            ++n;
        }
        Assert.fail((String)"Unable to create inexistent directory handle.");
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

