/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.internal.model.ui.EMFContentProvider;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.ITypeValidator;
import org.eclipse.hyades.ui.internal.provider.WorkbenchAdapterLabelProvider;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class InvokedTestSelectionDialog
extends Dialog
implements IDisposable,
IDoubleClickListener,
ISelectionChangedListener {
    protected static final int HELP_DLG_CONTROL = 1;
    protected static final int HELP_LOCAL_TEST_CASES_CONTROL = 2;
    protected static final int HELP_TESTS_CONTROL = 3;
    private static final int HEIGHT = 400;
    private static final int WIDTH = 400;
    private ITestSuite testSuite;
    private Collection tests;
    private TableViewer localTestCasesTableViewer;
    private TreeViewer testsTreeViewer;
    private ResourceSet testsResourceSet;
    private String title;
    private String tableLabel;
    private String treeLabel;
    private boolean singleSelection;
    private ITypeValidator typeValidator;
    static /* synthetic */ Class class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter;

    public InvokedTestSelectionDialog(Shell shell, ITestSuite iTestSuite, String string, String string2, String string3, boolean bl) {
        super(shell);
        IAssociationDescriptor iAssociationDescriptor;
        this.testSuite = iTestSuite;
        this.title = string;
        this.tableLabel = string2;
        this.treeLabel = string3;
        this.singleSelection = bl;
        this.tests = new ArrayList();
        String string4 = iTestSuite.getType();
        if (string4 != null && (iAssociationDescriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping("typeValidators").getDefaultAssociationDescriptor(string4)) != null) {
            this.typeValidator = (ITypeValidator)iAssociationDescriptor.createImplementationClassInstance();
        }
    }

    public void dispose() {
        this.testsResourceSet = null;
        this.localTestCasesTableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.localTestCasesTableViewer.removeDoubleClickListener((IDoubleClickListener)this);
        if (this.testsTreeViewer != null) {
            this.testsTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.testsTreeViewer.removeDoubleClickListener((IDoubleClickListener)this);
        }
        this.testSuite = null;
        this.typeValidator = null;
    }

    public void setTest(ITest iTest) {
        this.tests.clear();
        this.tests.add(iTest);
        this.selectTest(this.tests);
    }

    public Collection getTests() {
        return this.tests;
    }

    public ITestSuite getTestSuite() {
        return this.testSuite;
    }

    protected ITypeValidator getTypeValidator() {
        return this.typeValidator;
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.getButton(0).setEnabled(false);
        this.localTestCasesTableViewer.setInput((Object)this.testSuite);
        if (this.testsTreeViewer != null) {
            this.testsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        this.selectTest(this.getTests());
        this.registerHelp(1, control);
        this.registerHelp(2, this.localTestCasesTableViewer.getControl());
        if (this.testsTreeViewer != null) {
            this.registerHelp(3, this.testsTreeViewer.getControl());
        }
        return control;
    }

    protected void registerHelp(int n, Object object) {
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 400;
        gridData.widthHint = 400;
        composite2.setLayoutData((Object)gridData);
        this.createLocalTestCasesControl(composite2);
        if (this.getTypeValidator() != null) {
            this.createTestControl(composite2);
        }
        if (this.title != null) {
            this.getShell().setText(this.title);
        }
        return composite2;
    }

    protected void selectTest(Collection collection) {
        if (this.localTestCasesTableViewer == null) {
            return;
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ITest iTest = (ITest)iterator.next();
                if (iTest instanceof ITestCase && ((ITestCase)iTest).getOwner() == this.testSuite) {
                    this.localTestCasesTableViewer.setSelection((ISelection)new StructuredSelection((Object)iTest), true);
                    continue;
                }
                if (this.testsTreeViewer == null) continue;
                iTest = (ITest)EMFUtil.getEObject((ResourceSet)this.testsResourceSet, (EObject)((EObject)iTest), (boolean)true);
                this.testsTreeViewer.setSelection((ISelection)new StructuredSelection((Object)iTest), true);
            }
        } else {
            this.localTestCasesTableViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            if (this.testsTreeViewer != null) {
                this.testsTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    protected void createLocalTestCasesControl(Composite composite) {
        Object object;
        if (this.tableLabel != null) {
            Label label = new Label(composite, 0);
            label.setText(this.tableLabel);
        }
        int n = this.singleSelection ? 4 : 2;
        this.localTestCasesTableViewer = new TableViewer(composite, n | 0x100 | 0x200 | 0x800);
        this.localTestCasesTableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.localTestCasesTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.getTypeValidator() != null) {
            object = GridDataUtil.createHorizontalFill();
            object.grabExcessVerticalSpace = false;
            object.heightHint = 100;
            this.localTestCasesTableViewer.getControl().setLayoutData(object);
        } else {
            this.localTestCasesTableViewer.getControl().setLayoutData((Object)GridDataUtil.createFill());
        }
        object = new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }

            public Object[] getElements(Object object) {
                if (InvokedTestSelectionDialog.this.getTestSuite() != null) {
                    return InvokedTestSelectionDialog.this.getTestSuite().getITestCases().toArray();
                }
                return new Object[0];
            }
        };
        this.localTestCasesTableViewer.setContentProvider((IContentProvider)object);
        this.localTestCasesTableViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchAdapterLabelProvider(class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter == null ? (class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter = InvokedTestSelectionDialog.class$("org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter")) : class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter));
    }

    protected void createTestControl(Composite composite) {
        if (this.treeLabel != null) {
            Label label = new Label(composite, 0);
            label.setText(this.treeLabel);
        }
        int n = this.singleSelection ? 4 : 2;
        this.testsTreeViewer = new TreeViewer(composite, n | 0x100 | 0x200 | 0x800);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 220;
        this.testsTreeViewer.getControl().setLayoutData((Object)gridData);
        this.testsTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.testsTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        ViewerFilter viewerFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object object, Object object2) {
                if (object2 instanceof ITest) {
                    ITest iTest = (ITest)object2;
                    if (InvokedTestSelectionDialog.this.getTestSuite().getId().equals(iTest.getId())) {
                        return false;
                    }
                    return InvokedTestSelectionDialog.this.getTypeValidator().isValidType(iTest.getType());
                }
                return true;
            }
        };
        this.testsTreeViewer.addFilter(viewerFilter);
        this.testsResourceSet = new ResourceSetImpl();
        EMFContentProvider eMFContentProvider = new EMFContentProvider(this.testsResourceSet);
        EMFContentProvider.ElementDescription elementDescription = new EMFContentProvider.ElementDescription("testsuite");
        elementDescription.getEClassifiers().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        eMFContentProvider.addElementDescription(elementDescription);
        EMFContentProvider.EnabledChildren enabledChildren = new EMFContentProvider.EnabledChildren((EClassifier)Common_TestprofilePackage.eINSTANCE.getTPFTestSuite());
        enabledChildren.getChildrenEStructuralFeatures().add(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases());
        eMFContentProvider.addEnabledChildren(enabledChildren);
        this.testsTreeViewer.setContentProvider((IContentProvider)eMFContentProvider);
        ILabelDecorator iLabelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.testsTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchAdapterLabelProvider(class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter == null ? (class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter = InvokedTestSelectionDialog.class$("org.eclipse.hyades.test.ui.adapter.TestWorkbenchAdapter")) : class$org$eclipse$hyades$test$ui$adapter$TestWorkbenchAdapter), iLabelDecorator));
        eMFContentProvider.setShowEnabledChildren(true);
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        if (this.processSelection((IStructuredSelection)doubleClickEvent.getSelection())) {
            this.okPressed();
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.processSelection((IStructuredSelection)selectionChangedEvent.getSelection());
    }

    protected boolean processSelection(IStructuredSelection iStructuredSelection) {
        if (!iStructuredSelection.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof ITest)) continue;
                arrayList.add(e);
            }
            if (!arrayList.isEmpty()) {
                this.tests = arrayList;
                this.getButton(0).setEnabled(true);
                return true;
            }
        }
        this.getButton(0).setEnabled(false);
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

