/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGLineChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGLineChart() {
        this.graphicType = "line";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        String[] stringArray;
        Object object;
        double d;
        double d2;
        double d3;
        GraphicAttributes graphicAttributes = this.createGraphicAttributes(graphicDocumentProperties);
        Document document = graphicAttributes.getDataDocument();
        int n = 0;
        try {
            n = this.dataRetriever.getNumberOfDatasets(document);
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.graphicType);
            throw dataInputProcessingException;
        }
        String string = null;
        int n2 = 60;
        int n3 = n2 / 2;
        int n4 = 50;
        try {
            this.xAxis = this.dataRetriever.getDataRange(document, "S");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(document, "W");
        }
        catch (DataInputProcessingException dataInputProcessingException) {
            dataInputProcessingException.setWidgetType(this.getGraphicType());
            throw dataInputProcessingException;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 0 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            string = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        this.dataSets = new DataSet[n];
        int n5 = 0;
        while (n5 < n) {
            this.dataSets[n5] = this.dataRetriever.getDatasetWithPosition(document, Integer.toString(n5));
            ++n5;
        }
        this.legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double d4 = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttributes);
        if (d4 > (d3 = (double)(graphicAttributes.getGraphicWidth() / 4))) {
            d4 = d3;
        }
        if ((d2 = this.getMaxLengthOfLegendLabel(graphicAttributes, this.dataSets)) > (d = (double)(graphicAttributes.getGraphicWidth() / 3))) {
            d2 = d;
        }
        if (graphicAttributes.isLegendSuppressed()) {
            d2 = 0.0;
        }
        int n6 = (int)((double)graphicAttributes.getGraphicWidth() - (d2 + d4 + (double)n2));
        int n7 = this.getNumberOfAxisLabels(graphicAttributes, n6, this.xAxis);
        int n8 = (int)((double)graphicAttributes.getGraphicHeight() - (double)n4 * 2.5 - (double)(n7 * 10));
        Document document2 = this.createSvgDocument(document.getImplementation(), Short.toString(graphicAttributes.getGraphicWidth()), Short.toString(graphicAttributes.getGraphicHeight()));
        Element element = document2.getDocumentElement();
        this.registerEventHandler(element, "onload", "init(evt)");
        this.addDefinitions(document2, graphicAttributes, n);
        this.addJavaScriptFunctions(document2, graphicAttributes, n, n2, n4, n6, n8);
        if (!graphicAttributes.isOutlineSuppressed()) {
            this.addOutline(document2, graphicAttributes);
        }
        if (!graphicAttributes.isTimestampSuppressed()) {
            try {
                object = this.dataRetriever.getTimestamp(document);
                stringArray = GraphicAttributes.parseISO8601Date((String)object);
                this.addTimeStamp(document2, graphicAttributes, (String)(stringArray == null ? object : graphicAttributes.formatDate((Date)stringArray)));
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        if (!graphicAttributes.isTitlebarSuppressed()) {
            this.addTitleBar(document2, graphicAttributes);
        } else {
            n4 = super.resetGridOffsetForCenter(graphicAttributes.getGraphicHeight(), n8, 3.0);
        }
        if (!graphicAttributes.isUserPreferencesSuppressed() && graphicAttributes.getSvgFormatOnly()) {
            this.addPreferenceIcon(document2, graphicAttributes);
        }
        n2 = n3 + (int)d4;
        this.addGrid(document2, element, n6, n8, n2, n4, this.xAxis, this.yAxis);
        this.addAxisLabels(document2, graphicAttributes, element, n6, n8, n2, n4, this.xAxis, this.yAxis);
        this.addTitles(document2, graphicAttributes, element, n6, n8, n2, n4, this.xAxis, this.yAxis, n7, string);
        object = document2.createElement("g");
        this.addDataSets(document2, graphicAttributes, element, (Element)object, n6, n8, n2, n4, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttributes.isLegendSuppressed()) {
            try {
                stringArray = this.dataRetriever.getLegendLabels(document);
                this.addLegend(document2, graphicAttributes, (Element)object, stringArray, this.legendFlyOverLabels, (int)d4 + n6 + n3, n4);
            }
            catch (DataInputProcessingException dataInputProcessingException) {
                dataInputProcessingException.setWidgetType(this.graphicType);
                throw dataInputProcessingException;
            }
        }
        element.appendChild((Node)object);
        return document2;
    }

    protected Element addLegendItemGraphic(Document document, Element element, int n, int n2, int n3, int n4) {
        String[] stringArray = new String[]{"#legendcircleshape", "#legendsquareshape", "#legendhorizontalrectshape", "#legendverticalrectshape", "#legendtriangleshape", "#legenddiamondshape"};
        super.addLegendItemGraphic(document, element, n, n2, n3, n4);
        Element element2 = document.createElement("use");
        element2.setAttribute("xlink:href", stringArray[n % stringArray.length]);
        element2.setAttribute("x", Integer.toString(n3));
        element2.setAttribute("y", Integer.toString(n4 + n2 - 8));
        Element element3 = document.createElement("g");
        element3.setAttribute("id", "shape" + n);
        element3.setAttribute("onclick", "toggleVisibility('dataColour" + n + "');");
        element3.setAttribute("class", "shape" + n);
        element3.appendChild(element2);
        return element3;
    }

    private void addDataSets(Document document, GraphicAttributes graphicAttributes, Element element, Element element2, int n, int n2, int n3, int n4, DataRange dataRange, DataRange dataRange2, DataSet[] dataSetArray) throws DataInputProcessingException {
        double d = dataRange.getMinValue();
        double d2 = dataRange.getMaxValue();
        double d3 = dataRange2.getMinValue();
        double d4 = dataRange2.getMaxValue();
        if (d == d2 || d3 == d4) {
            return;
        }
        int n5 = 0;
        while (n5 < dataSetArray.length) {
            DataSet dataSet = dataSetArray[n5];
            DataPoint[] dataPointArray = dataSet.getDataPoints();
            double[] dArray = new double[dataPointArray.length];
            double[] dArray2 = new double[dataPointArray.length];
            int n6 = 0;
            while (n6 < dataPointArray.length) {
                dArray2[n6] = (double)n * (dataPointArray[n6].getValue1() - d) / (d2 - d);
                dArray[n6] = (double)n2 * (d4 - dataPointArray[n6].getValue2()) / (d4 - d3);
                ++n6;
            }
            this.addLine(document, element, dataPointArray, n5, dArray2, dArray, n, n2, n3, n4);
            String string = "dataValues anchorAtMiddle";
            Element element3 = document.createElement("g");
            element3.setAttribute("id", "textbox" + n5);
            element3.setAttribute("class", string);
            element3.setAttribute("transform", "translate(" + n3 + "," + n4 + ")");
            element3.setAttribute("visibility", "hidden");
            element3.setAttribute("onclick", "toggleVisibility('textbox" + n5 + "');");
            element2.appendChild(element3);
            this.addTextBoxes(document, graphicAttributes, element3, n5, dArray2, dArray, dataPointArray, n, n2);
            ++n5;
        }
    }

    private void addDefaultInternalStylesheet(Document document, GraphicAttributes graphicAttributes, Element element, int n) {
        StringBuffer stringBuffer = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        stringBuffer.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] stringArray = (String[])graphicAttributes.getGraphicColorPalette().get(graphicAttributes.getGraphicColorPaletteName());
        int n2 = stringArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            n4 = (n3 + 1) % n2;
            n4 = n4 == 0 ? n2 - 1 : n4 - 1;
            stringBuffer.append(" .dataset" + n3 + "{stroke-linecap:round;stroke-width:0.75pt; stroke:" + stringArray[n4] + ";}");
            if (!graphicAttributes.isLegendSuppressed()) {
                stringBuffer.append(" .shapeline" + n3 + "{stroke-width:0.75pt;stroke:" + stringArray[n4] + ";fill:" + stringArray[n4] + ";}");
                stringBuffer.append(" .shape" + n3 + "{ fill:" + stringArray[n4] + ";}");
            }
            ++n3;
        }
        CDATASection cDATASection = document.createCDATASection(stringBuffer.toString());
        Element element2 = document.createElement("style");
        element2.setAttribute("id", "defaultStyleRules");
        element2.setAttribute("type", "text/css");
        element2.appendChild(cDATASection);
        element.appendChild(element2);
    }

    protected void addDefinitions(Document document, GraphicAttributes graphicAttributes, int n) {
        Element element;
        Element element2;
        Element element3;
        Element element4;
        Element element5;
        Element element6;
        Element element7;
        Element element8;
        Element element9;
        Element element10;
        Element element11;
        Element element12;
        Element element13 = super.addDefinitions(document, graphicAttributes);
        this.addDefaultInternalStylesheet(document, graphicAttributes, element13, n);
        if (!graphicAttributes.isLegendSuppressed()) {
            element12 = document.createElement("g");
            element13.appendChild(element12);
            element12.setAttribute("id", "legendsquareshape");
            element11 = document.createElement("rect");
            element12.appendChild(element11);
            element11.setAttribute("width", "8");
            element11.setAttribute("height", "8");
            element11.setAttribute("transform", "translate(3,0)");
            element12.appendChild(this.addLegendShapeLine(document));
            element10 = document.createElement("g");
            element13.appendChild(element10);
            element10.setAttribute("id", "legendcircleshape");
            element9 = document.createElement("circle");
            element10.appendChild(element9);
            element9.setAttribute("r", "4");
            element9.setAttribute("cx", "4");
            element9.setAttribute("cy", "4");
            element9.setAttribute("transform", "translate(3,0)");
            element10.appendChild(this.addLegendShapeLine(document));
            element8 = document.createElement("g");
            element13.appendChild(element8);
            element8.setAttribute("id", "legenddiamondshape");
            element7 = document.createElement("polygon");
            element8.appendChild(element7);
            element7.setAttribute("points", "0,4 4,0 8,4 4,8");
            element7.setAttribute("transform", "translate(3,0)");
            element8.appendChild(this.addLegendShapeLine(document));
            element6 = document.createElement("g");
            element13.appendChild(element6);
            element6.setAttribute("id", "legendhorizontalrectshape");
            element5 = document.createElement("rect");
            element6.appendChild(element5);
            element5.setAttribute("width", "8");
            element5.setAttribute("height", "4");
            element5.setAttribute("transform", "translate(3,2)");
            element6.appendChild(this.addLegendShapeLine(document));
            element4 = document.createElement("g");
            element13.appendChild(element4);
            element4.setAttribute("id", "legendverticalrectshape");
            element3 = document.createElement("rect");
            element4.appendChild(element3);
            element3.setAttribute("width", "4");
            element3.setAttribute("height", "8");
            element3.setAttribute("transform", "translate(5,0)");
            element4.appendChild(this.addLegendShapeLine(document));
            element2 = document.createElement("g");
            element13.appendChild(element2);
            element2.setAttribute("id", "legendtriangleshape");
            element = document.createElement("polygon");
            element.setAttribute("points", "4 0, 0 8, 8 8");
            element.setAttribute("transform", "translate(3,0)");
            element2.appendChild(element);
            element2.appendChild(this.addLegendShapeLine(document));
        }
        element12 = document.createElement("g");
        element13.appendChild(element12);
        element12.setAttribute("id", "squareshape");
        element11 = document.createElement("rect");
        element12.appendChild(element11);
        element11.setAttribute("width", "5.6");
        element11.setAttribute("height", "5.6");
        element10 = document.createElement("g");
        element13.appendChild(element10);
        element10.setAttribute("id", "circleshape");
        element9 = document.createElement("circle");
        element10.appendChild(element9);
        element9.setAttribute("r", "2.8");
        element9.setAttribute("cx", "2.8");
        element9.setAttribute("cy", "2.8");
        element8 = document.createElement("g");
        element13.appendChild(element8);
        element8.setAttribute("id", "holeshape");
        element7 = document.createElement("circle");
        element8.appendChild(element7);
        element7.setAttribute("r", "2.8");
        element7.setAttribute("cx", "2.8");
        element7.setAttribute("cy", "2.8");
        element7.setAttribute("style", "fill:none;");
        element6 = document.createElement("g");
        element13.appendChild(element6);
        element6.setAttribute("id", "diamondshape");
        element5 = document.createElement("polygon");
        element6.appendChild(element5);
        element5.setAttribute("points", "0,2.8 2.8,0 5.6,2.8 2.8,5.6");
        element4 = document.createElement("g");
        element13.appendChild(element4);
        element4.setAttribute("id", "horizontalrectshape");
        element3 = document.createElement("rect");
        element4.appendChild(element3);
        element3.setAttribute("width", "5.6");
        element3.setAttribute("height", "2.8");
        element2 = document.createElement("g");
        element13.appendChild(element2);
        element2.setAttribute("id", "verticalrectshape");
        element = document.createElement("rect");
        element.setAttribute("width", "2.8");
        element.setAttribute("height", "5.6");
        element2.appendChild(element);
        Element element14 = document.createElement("g");
        element13.appendChild(element14);
        element14.setAttribute("id", "triangleshape");
        Element element15 = document.createElement("polygon");
        element15.setAttribute("points", "2.8 0, 0 5.6, 5.6 5.6");
        element14.appendChild(element15);
    }

    private Element addLegendShapeLine(Document document) {
        Element element = document.createElement("polyline");
        element.setAttribute("points", "0 4, 14 4");
        return element;
    }

    private void addLine(Document document, Element element, DataPoint[] dataPointArray, int n, double[] dArray, double[] dArray2, int n2, int n3, int n4, int n5) {
        String[] stringArray = new String[]{"#circleshape", "#squareshape", "#horizontalrectshape", "#verticalrectshape", "#triangleshape", "#diamondshape"};
        double[] dArray3 = new double[]{5.6, 5.6, 5.6, 2.8, 5.6, 5.6};
        double[] dArray4 = new double[]{5.6, 5.6, 2.8, 5.6, 4.85, 5.6};
        int n6 = dArray.length;
        double d = 0.0;
        double d2 = 0.0;
        Element element2 = document.createElement("g");
        element2.setAttribute("id", "dataColour" + n);
        element2.setAttribute("class", "dataset" + n);
        element2.setAttribute("visibility", "visible");
        element2.setAttribute("onclick", "toggleVisibility('textbox" + n + "');");
        element.appendChild(element2);
        int n7 = n % stringArray.length;
        int n8 = 0;
        while (n8 < n6) {
            double d3;
            double d4 = dArray[n8];
            double d5 = dArray2[n8];
            if (n8 > 0) {
                Element element3 = document.createElement("polyline");
                String string = d + " " + d2 + "," + d4 + " " + d5;
                element3.setAttribute("points", string);
                if (dataPointArray[n8].getType() == 1 || dataPointArray[n8 - 1].getType() == 1) {
                    element3.setAttribute("style", "stroke-dasharray: 9, 5; stroke-width: 2;");
                }
                element3.setAttribute("transform", "translate(" + n4 + "," + n5 + ")");
                element2.appendChild(element3);
            }
            if ((d3 = d4 - dArray3[n7] / 2.0) <= 0.0) {
                d3 = 0.0;
            } else if (d3 + dArray3[n7] > (double)n2) {
                d3 = (double)n2 - dArray3[n7];
            }
            double d6 = d5 - dArray4[n7] / 2.0;
            if (d6 + dArray4[n7] > (double)n3) {
                d6 = (double)n3 - dArray4[n7];
            }
            Element element4 = document.createElement("use");
            if (dataPointArray[n8].getType() == 1) {
                element4.setAttribute("xlink:href", "#holeshape");
            } else {
                element4.setAttribute("xlink:href", stringArray[n7]);
            }
            element4.setAttribute("transform", "translate(" + ((double)n4 + d3) + "," + ((double)n5 + d6) + ")");
            element4.setAttribute("visibility", "visible");
            element2.appendChild(element4);
            d = d4;
            d2 = d5;
            ++n8;
        }
    }

    protected void addTextBoxes(Document document, GraphicAttributes graphicAttributes, Element element, int n, double[] dArray, double[] dArray2, DataPoint[] dataPointArray, int n2, int n3) {
        int n4 = dArray.length;
        int n5 = 0;
        while (n5 < n4) {
            String string = dataPointArray[n5].getDisplayLabel(graphicAttributes);
            double d = string.length();
            double d2 = 16.0 + (d - 1.0) * 6.0;
            double d3 = 18.0;
            double d4 = dArray[n5];
            double d5 = dArray2[n5];
            double d6 = d4;
            double d7 = d5;
            this.addEachTextBox(document, graphicAttributes, element, d6, d7, d2, d3, string, n, n5);
            ++n5;
        }
    }

    protected GraphicAttributes createGraphicAttributes(GraphicDocumentProperties graphicDocumentProperties) throws DataInputProcessingException {
        GraphicAttributes graphicAttributes = new GraphicAttributes();
        graphicAttributes.setGraphicWidth("450");
        graphicAttributes.setPreferencesPage("prefs_line.htm");
        graphicAttributes.setPreferencesPageWidth("430");
        graphicAttributes.setPreferencesPageHeight("495");
        graphicAttributes.setConfigDocument(graphicDocumentProperties.getConfigDocument());
        graphicAttributes.setDataDocument(graphicDocumentProperties.getDataDocument());
        this.getConfigAttributes(graphicAttributes);
        graphicAttributes.setAttributesFrom(graphicDocumentProperties);
        return graphicAttributes;
    }
}

