/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.common.internal.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.codegen.Generator;
import org.eclipse.hyades.ui.internal.util.ResourceUtil;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class JavaGenerator
extends Generator
implements IDisposable {
    private Collection requiredLibraries;
    public static final String ECLIPSE_HOME = "ECLIPSE_HOME";
    public static final String PLUGINS = "/plugins";

    public void dispose() {
        this.requiredLibraries.clear();
    }

    public void addAllLibraries(String string) {
        if (this.requiredLibraries == null) {
            this.requiredLibraries = new HashSet();
        }
        this.requiredLibraries.addAll(Arrays.asList(this.getVariablePluginLibraries(string)));
    }

    public void addRequiredLibrary(String string, String string2) {
        String string3 = this.getLibrary(string, string2);
        if (string3 == null) {
            return;
        }
        if (this.requiredLibraries == null) {
            this.requiredLibraries = new HashSet();
        }
        this.requiredLibraries.add(string3);
    }

    protected String getLibrary(String string, String string2) {
        return this.getVariablePluginLibrary(string, string2);
    }

    protected void doGenerateFile(ITestSuite iTestSuite, IContainer iContainer, IFile iFile, IProgressMonitor iProgressMonitor) throws Exception {
        String string = iTestSuite.getImplementor().getResource();
        int n = string.lastIndexOf(46);
        this.adjustSourceContainer(iContainer, string.substring(0, n), iProgressMonitor);
        this.adjustProjectDependencies(iTestSuite, iFile.getProject(), this.requiredLibraries, iProgressMonitor);
        this.generateFile(iTestSuite, iFile, iProgressMonitor);
    }

    public IFile getFileHandle(ITestSuite iTestSuite) {
        IContainer iContainer = this.getSourceContainerHandle(iTestSuite);
        return iContainer.getFile((IPath)new Path(iTestSuite.getImplementor().getResource().replace('.', '/') + ".java"));
    }

    protected void adjustSourceContainer(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) throws Exception {
        IJavaProject iJavaProject = JavaCore.create((IProject)iContainer.getProject());
        if (iContainer.getType() == 2 && !iJavaProject.isOnClasspath((IResource)iContainer)) {
            IClasspathEntry iClasspathEntry = JavaCore.newSourceEntry((IPath)iContainer.getFullPath());
            ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
            arrayList.add(1, iClasspathEntry);
            iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), iProgressMonitor);
        }
        iJavaProject.getPackageFragmentRoot((IResource)iContainer).createPackageFragment(string, true, iProgressMonitor);
    }

    protected void adjustProjectDependencies(ITestSuite iTestSuite, IProject iProject, Collection collection, IProgressMonitor iProgressMonitor) {
        ArrayList<IClasspathEntry> arrayList;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        try {
            arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        }
        catch (JavaModelException javaModelException) {
            TestCommonPlugin.logError(javaModelException);
            return;
        }
        int n = arrayList.size() - 2;
        if (n < 0) {
            n = 0;
        }
        IClasspathEntry[] iClasspathEntryArray = this.getLibrariesEntries(collection);
        int n2 = 0;
        int n3 = iClasspathEntryArray.length;
        while (n2 < n3) {
            if (!arrayList.contains(iClasspathEntryArray[n2]) && !arrayList.contains(JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntryArray[n2]))) {
                arrayList.add(n, iClasspathEntryArray[n2]);
            }
            ++n2;
        }
        iClasspathEntryArray = this.getProjectEntries(iTestSuite, iProject);
        int n4 = 0;
        int n5 = iClasspathEntryArray.length;
        while (n4 < n5) {
            if (!arrayList.contains(iClasspathEntryArray[n4]) && !arrayList.contains(JavaCore.getResolvedClasspathEntry((IClasspathEntry)iClasspathEntryArray[n4]))) {
                arrayList.add(n, iClasspathEntryArray[n4]);
            }
            ++n4;
        }
        try {
            iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), null);
        }
        catch (JavaModelException javaModelException) {
            TestCommonPlugin.logError(javaModelException);
            return;
        }
    }

    protected IClasspathEntry[] getLibrariesEntries(Collection collection) {
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            URI uRI = URI.createURI((String)string);
            if (uRI.isRelative()) {
                arrayList.add(JavaCore.newVariableEntry((IPath)new Path(string), null, null));
                continue;
            }
            arrayList.add(JavaCore.newLibraryEntry((IPath)new Path(uRI.toFileString()), null, null));
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    protected IClasspathEntry[] getProjectEntries(ITestSuite iTestSuite, IProject iProject) {
        if (iTestSuite.getIReferencedSuites() == null || iTestSuite.getIReferencedSuites().isEmpty()) {
            return new IClasspathEntry[0];
        }
        HashSet<IClasspathEntry> hashSet = new HashSet<IClasspathEntry>(iTestSuite.getIReferencedSuites().size() + 1);
        Iterator iterator = iTestSuite.getIReferencedSuites().iterator();
        while (iterator.hasNext()) {
            String string;
            ITestSuite iTestSuite2 = (ITestSuite)iterator.next();
            if (iTestSuite2.getImplementor() == null || (string = iTestSuite2.getImplementor().getLocation()) == null) continue;
            Path path = new Path(string);
            IProject iProject2 = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            if (iProject2 == null || !iProject2.exists() || iProject.equals((Object)iProject2)) continue;
            hashSet.add(JavaCore.newProjectEntry((IPath)iProject2.getFullPath()));
        }
        return hashSet.toArray(new IClasspathEntry[hashSet.size()]);
    }

    protected String[] getVariablePluginLibraries(String string) {
        if (string == null) {
            return new String[0];
        }
        Plugin plugin = Platform.getPlugin((String)string);
        ILibrary[] iLibraryArray = plugin.getDescriptor().getRuntimeLibraries();
        ArrayList<String> arrayList = new ArrayList<String>(iLibraryArray.length);
        int n = 0;
        int n2 = iLibraryArray.length;
        while (n < n2) {
            String string2 = this.getVariablePluginLibrary(string, iLibraryArray[n].getPath().toString());
            arrayList.add(string2);
            ++n;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected String getVariablePluginLibrary(String string, String string2) {
        String string3;
        if (string == null) {
            return "";
        }
        Plugin plugin = Platform.getPlugin((String)string);
        if (plugin == null) {
            return "";
        }
        File file = ResourceUtil.getPluginDirectory((String)string);
        Path path = new Path(file.getAbsolutePath());
        IPath iPath = JavaCore.getClasspathVariable((String)ECLIPSE_HOME);
        String string4 = path.getDevice();
        String string5 = iPath.getDevice();
        if (string4 != null && string5 != null && string4.equalsIgnoreCase(string5) && !string4.equals(string5)) {
            path = path.setDevice(string4.toUpperCase());
            iPath = iPath.setDevice(string5.toUpperCase());
        }
        if ((string3 = iPath.toString()) == null || string3.length() == 0) {
            return "";
        }
        string3 = string3 + PLUGINS;
        URI uRI = URI.createFileURI((String)string3);
        File file2 = new File(path.toString(), string2);
        URI uRI2 = URI.createFileURI((String)file2.getAbsolutePath());
        URI uRI3 = uRI2.deresolve(uRI);
        if (uRI3.segmentCount() < uRI2.segmentCount()) {
            String string6 = uRI3.toString();
            return "ECLIPSE_HOME/" + string6;
        }
        return uRI2.toString();
    }
}

