/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.execution.harness.ExecutionHarnessPlugin;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor;

public class ExecutionHarnessDataProcessorFactory {
    private static ArrayList standAloneClassObjects = null;
    private static IConfigurationElement[] dpConfigElements = null;
    private boolean bStandAlone = false;

    public ExecutionHarnessDataProcessorFactory(boolean bStandAlone) {
        if (!bStandAlone && dpConfigElements == null) {
            this.loadDataProcessors();
        }
        this.bStandAlone = bStandAlone;
    }

    private void loadDataProcessors() {
        dpConfigElements = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.hyades.execution.harness.Dataprocessor");
    }

    public static void setStandAloneClassObjects(ArrayList standAloneClassObjects) {
        ExecutionHarnessDataProcessorFactory.standAloneClassObjects = standAloneClassObjects;
    }

    public ArrayList getDataProcessors() {
        ArrayList<Object> dataProcessors = new ArrayList<Object>();
        if (this.bStandAlone) {
            int i = 0;
            while (i < standAloneClassObjects.size()) {
                try {
                    dataProcessors.add(((Class)standAloneClassObjects.get(i)).newInstance());
                }
                catch (InstantiationException e) {
                    ExecutionHarnessPlugin.getDefault().logError(e);
                }
                catch (IllegalAccessException e) {
                    ExecutionHarnessPlugin.getDefault().logError(e);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dpConfigElements.length) {
                try {
                    IExecutionHarnessDataProcessor dataProcessor = (IExecutionHarnessDataProcessor)dpConfigElements[i].createExecutableExtension("class");
                    dataProcessors.add(dataProcessor);
                }
                catch (CoreException e) {
                    ExecutionHarnessPlugin.getDefault().logError(e);
                }
                ++i;
            }
        }
        return dataProcessors;
    }
}

