/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.harness.IExecutionEnvironmentAdapter;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.CFGPropertyGroup;
import org.eclipse.hyades.models.common.configuration.util.ConfigurationUtil;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.interactions.BVRProperty;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

public class JavaExecutionEnvironmentAdapter
implements IExecutionEnvironmentAdapter {
    public void setupExecutionEnvironment(IExecutionEnvironment executionEnvironment, CFGClass rootResource, IImplementor theImplementor, TPFDeployment deployment) throws ClassCastException {
        BVRProperty[] properties = null;
        List environmentVariableProperties = rootResource.getEnvironmentVariables().getProperties();
        CFGLocation location = null;
        if (rootResource instanceof TPFTestSuite && !deployment.getArtifactLocations().isEmpty()) {
            Iterator i = deployment.getArtifactLocations().iterator();
            while (i.hasNext()) {
                CFGArtifactLocationPair pair = (CFGArtifactLocationPair)i.next();
                if (!ConfigurationUtil.containsById((List)pair.getArtifact().getDeployableInstances(), (CMNNamedElement)rootResource)) continue;
                location = pair.getLocation();
                break;
            }
        }
        if (location != null) {
            CFGPropertyGroup propGroup = ConfigurationUtil.searchPropertyGroupById((List)location.getPropertyGroups(), (String)"org.eclipse.hyades.test.configuration.location.attributes");
            if (propGroup != null && (properties = ConfigurationUtil.searchPropertiesByName((List)propGroup.getProperties(), (String)"CLASSPATH", (boolean)false)) != null && properties.length > 0 && environmentVariableProperties != null) {
                environmentVariableProperties.clear();
                environmentVariableProperties.addAll(Arrays.asList(properties));
            }
        } else {
            if (environmentVariableProperties == null) {
                return;
            }
            properties = new BVRProperty[environmentVariableProperties.size()];
            int index = 0;
            Iterator i = environmentVariableProperties.iterator();
            while (i.hasNext()) {
                properties[index] = (BVRProperty)i.next();
                ++index;
            }
        }
        if (properties == null || properties.length == 0) {
            return;
        }
        int i = 0;
        while (i < properties.length) {
            IOrderedProperty orderedProperty = executionEnvironment.getEnvByName(properties[i].getName());
            if (orderedProperty == null) {
                orderedProperty = new OrderedPropertyImpl();
                orderedProperty.setName(properties[i].getName());
            }
            orderedProperty.appendValue((Object)properties[i].getValue());
            executionEnvironment.setEnv(orderedProperty);
            ++i;
        }
    }
}

