/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.dialog;

import java.util.List;
import java.util.Vector;
import org.eclipse.hyades.models.common.configuration.CFGComparableProperty;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.configuration.util.Common_ConfigurationCategoryUtil;
import org.eclipse.hyades.models.common.configuration.util.ICategory;
import org.eclipse.hyades.models.common.configuration.util.ICategoryEnumeration;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComparablePropertyInputDialog
extends Dialog
implements SelectionListener,
ModifyListener {
    private String title;
    private CCombo[] comboBoxes = new CCombo[3];
    private Button okButton;
    private CFGComparableProperty property;
    private ICategory[] categories;
    private String[] categoryDisplayNames;
    private String[] operators;

    public ComparablePropertyInputDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
    }

    private ICategory[] getAllCategories() {
        if (this.categories == null) {
            this.categories = Common_ConfigurationCategoryUtil.getInstance().getCategories();
        }
        return this.categories;
    }

    private String[] getCategoryDisplayNames() {
        if (this.categoryDisplayNames == null) {
            ICategory[] categories = this.getAllCategories();
            this.categoryDisplayNames = new String[categories.length];
            int i = 0;
            while (i < categories.length) {
                this.categoryDisplayNames[i] = categories[i].getDisplayName();
                ++i;
            }
        }
        return this.categoryDisplayNames;
    }

    private String[] getOperators() {
        if (this.operators == null) {
            this.operators = new String[]{"=", "!=", ">", "<", ">=", "<="};
        }
        return this.operators;
    }

    private String[] getEnumerationDisplayNames(ICategory category) {
        ICategoryEnumeration[] iCategoryEnumerationArray = Common_ConfigurationCategoryUtil.getInstance().getCategoryEnumeration(category);
        if (iCategoryEnumerationArray == null) {
            return new String[0];
        }
        Vector<String> names = new Vector<String>(200);
        int i = 0;
        while (i < iCategoryEnumerationArray.length) {
            List values = iCategoryEnumerationArray[i].getIEnumerationValues();
            int j = 0;
            while (j < values.size()) {
                names.add((String)values.get(j));
                ++j;
            }
            ++i;
        }
        String[] returnList = new String[names.size()];
        int i2 = 0;
        while (i2 < names.size()) {
            returnList[i2] = (String)names.get(i2);
            ++i2;
        }
        return returnList;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        Label[] labels = new Label[3];
        int i = 0;
        while (i < 3) {
            labels[i] = new Label(composite, 64);
            switch (i) {
                case 0: {
                    labels[i].setText(TestUIPlugin.getString("DLG_PROPERTY_NAME"));
                    break;
                }
                case 1: {
                    labels[i].setText(TestUIPlugin.getString("DLG_OPERATOR"));
                    break;
                }
                case 2: {
                    labels[i].setText(TestUIPlugin.getString("DLG_PROPERTY_VALUE"));
                    break;
                }
            }
            GridData data = new GridData(36);
            labels[i].setLayoutData((Object)data);
            labels[i].setFont(parent.getFont());
            ++i;
        }
        this.comboBoxes[0] = new CCombo(composite, 2048);
        this.comboBoxes[0].setItems(this.getCategoryDisplayNames());
        if (this.property != null && this.property.getName() != null) {
            this.comboBoxes[0].setText(this.property.getName());
        }
        GridData gridData = new GridData(256);
        gridData.widthHint = 150;
        this.comboBoxes[0].setLayoutData((Object)gridData);
        this.comboBoxes[0].setSize(100, this.comboBoxes[0].getSize().y);
        this.comboBoxes[0].addSelectionListener((SelectionListener)this);
        this.comboBoxes[0].addModifyListener((ModifyListener)this);
        this.comboBoxes[1] = new CCombo(composite, 2056);
        this.comboBoxes[1].setItems(this.getOperators());
        if (this.property != null && this.property.getOperator() != null) {
            this.comboBoxes[1].setText(this.property.getOperator());
        } else {
            this.comboBoxes[1].select(0);
        }
        gridData = new GridData();
        gridData.widthHint = 50;
        this.comboBoxes[1].setLayoutData((Object)gridData);
        this.comboBoxes[1].addModifyListener((ModifyListener)this);
        this.comboBoxes[2] = new CCombo(composite, 2048);
        if (this.property != null && this.property.getValue() != null) {
            this.comboBoxes[2].setText(this.property.getValue());
        }
        gridData = new GridData(256);
        gridData.widthHint = 150;
        this.comboBoxes[2].setLayoutData((Object)gridData);
        this.comboBoxes[2].setSize(100, this.comboBoxes[2].getSize().y);
        this.comboBoxes[2].addModifyListener((ModifyListener)this);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String name = this.comboBoxes[0].getText();
            int index = this.comboBoxes[0].indexOf(name);
            if (index > -1) {
                name = this.getAllCategories()[index].getName();
            }
            String operator = this.comboBoxes[1].getText();
            String value = this.comboBoxes[2].getText();
            if (this.property == null) {
                this.property = Common_ConfigurationFactory.eINSTANCE.createCFGComparableProperty();
            }
            this.property.setName(name);
            if (operator != null && operator.length() > 0) {
                this.property.setOperator(operator);
            }
            if (value != null && value.length() > 0) {
                this.property.setValue(value);
            }
        } else {
            this.property = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void validateInput() {
        String name = this.comboBoxes[0].getText();
        String operator = this.comboBoxes[1].getText();
        String value = this.comboBoxes[2].getText();
        if (name == null || name.length() < 1 || operator == null || operator.length() < 1 || value == null || value.length() < 1) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    public CFGComparableProperty getProperty() {
        return this.property;
    }

    public void setProperty(CFGComparableProperty prop) {
        this.property = prop;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.comboBoxes[0]) {
            int index = this.comboBoxes[0].getSelectionIndex();
            if (index < 0) {
                return;
            }
            ICategory catg = this.getAllCategories()[index];
            String[] stringArray = this.getEnumerationDisplayNames(catg);
            this.comboBoxes[2].setItems(stringArray);
        }
    }

    public void modifyText(ModifyEvent e) {
        this.validateInput();
    }
}

