/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGArtifactLocationPair;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationFactory;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenDownAction;
import org.eclipse.hyades.test.ui.action.model.MoveFeatureChildrenUpAction;
import org.eclipse.hyades.test.ui.action.model.RemoveFeatureChildrenAction;
import org.eclipse.hyades.test.ui.editor.form.util.EObjectTableContentProvider;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.TableLabelProviderAdapter;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.action.AddArtifactAction;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.test.ui.internal.action.OpenArtifactAction;
import org.eclipse.hyades.test.ui.internal.action.OpenLocationAction;
import org.eclipse.hyades.test.ui.internal.editor.extension.ConfigurableObjectEditorExtension;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ArtifactLocationMapForm
extends EditorForm
implements ISelectionChangedListener,
SelectionListener {
    public static final String PROPERTY_NAME_CLASSPATH = Common_ConfigurationFactory.eINSTANCE.createHyadesClasspathCategory().getName();
    public static final String PROPERTY_NAME_ROOTDIR = Common_ConfigurationFactory.eINSTANCE.createHyadesRootDirectroyCategory().getName();
    private ExtensibleEObjectTreeSection artifactsSection;
    private ExtensibleEObjectTreeSection locationsSection;
    private ExtensibleEObjectTableSection mapSection;
    private AddLocationAction addLocationAction;
    private AddArtifactAction addArtifactAction;
    private Button createPairButton;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public ArtifactLocationMapForm(ConfigurableObjectEditorExtension deploymentEditorExtension, WidgetFactory widgetFactory) {
        super(deploymentEditorExtension, widgetFactory);
        this.setHeadingText(TestUIPlugin.getString("W_DEPLOYMENT"));
    }

    public void dispose() {
        if (this.artifactsSection != null) {
            this.artifactsSection.dispose();
            this.artifactsSection = null;
        }
        if (this.locationsSection != null) {
            this.locationsSection.dispose();
            this.locationsSection = null;
        }
        if (this.mapSection != null) {
            this.mapSection.dispose();
            this.mapSection = null;
        }
        if (this.createPairButton != null) {
            this.createPairButton.dispose();
            this.createPairButton = null;
        }
        super.dispose();
    }

    protected void createEditorFormContents(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 10;
        gridLayout.horizontalSpacing = 15;
        parent.setLayout((Layout)gridLayout);
        Composite artifactsColumn = this.createColumn(parent);
        Composite locationsColumn = this.createColumn(parent);
        IAction[] artifactButtonActions = this.createArifactSectionButtonActions();
        this.artifactsSection = new ExtensibleEObjectTreeSection(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), artifactButtonActions);
        this.registerSection(this.artifactsSection);
        this.artifactsSection.setHeaderText(TestUIPlugin.getString("W_ARTIFACTS"));
        this.artifactsSection.setCollapsable(true);
        Control control = this.artifactsSection.createControl(artifactsColumn, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.artifactsSection.setEditable(true);
        int i = 0;
        while (i < artifactButtonActions.length) {
            IAction action = artifactButtonActions[i];
            if (action != null) {
                if (action instanceof ChildrenSelectionAction) {
                    ((ChildrenSelectionAction)action).setStructuredViewer((StructuredViewer)this.artifactsSection.getTreeViewer());
                } else if (action instanceof OpenArtifactAction) {
                    ((OpenArtifactAction)action).setStructuredViewer((StructuredViewer)this.artifactsSection.getTreeViewer());
                }
            }
            ++i;
        }
        IAction[] locationButtonActions = this.createLocationSectionButtonActions();
        this.locationsSection = new ExtensibleEObjectTreeSection(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), locationButtonActions);
        this.registerSection(this.locationsSection);
        this.locationsSection.setHeaderText(TestUIPlugin.getString("W_LOCS"));
        this.locationsSection.setCollapsable(true);
        control = this.locationsSection.createControl(locationsColumn, this.getWidgetFactory());
        control.setLayoutData((Object)new GridData(1810));
        this.locationsSection.setEditable(true);
        int i2 = 0;
        while (i2 < locationButtonActions.length) {
            IAction action = locationButtonActions[i2];
            if (action != null) {
                if (action instanceof ChildrenSelectionAction) {
                    ((ChildrenSelectionAction)action).setStructuredViewer((StructuredViewer)this.locationsSection.getTreeViewer());
                } else if (action instanceof OpenLocationAction) {
                    ((OpenLocationAction)action).setStructuredViewer((StructuredViewer)this.locationsSection.getTreeViewer());
                }
            }
            ++i2;
        }
        this.createPairButton = new Button(parent, 8);
        GridData buttonData = new GridData();
        buttonData.horizontalAlignment = 3;
        this.createPairButton.setLayoutData((Object)buttonData);
        this.createPairButton.setToolTipText(TestUIPlugin.getString("BTN_CREATE_PAIR"));
        this.createPairButton.setImage(TestUIImages.INSTANCE.getImageDescriptor("downArrow.gif").createImage());
        this.createPairButton.setEnabled(false);
        this.createPairButton.addSelectionListener((SelectionListener)this);
        Composite blankCell = new Composite(parent, 524288);
        blankCell.setBackground(parent.getBackground());
        Composite southComposite = this.getFactory().createComposite(parent);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        southComposite.setLayoutData((Object)gridData);
        GridLayout southLayout = new GridLayout();
        southLayout.numColumns = 1;
        southComposite.setLayout((Layout)southLayout);
        IAction[] mapButtonActions = this.createMapSectionButtonActions();
        this.mapSection = new ExtensibleEObjectTableSection(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_ArtifactLocations(), 2, mapButtonActions);
        this.mapSection.setContentProvider((IContentProvider)new EObjectTableContentProvider(this, (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_ArtifactLocations()){

            public Object[] getElements(Object inputElement) {
                ArrayList<CFGArtifactLocationPair> resolvedEls = new ArrayList<CFGArtifactLocationPair>();
                Object[] elements = super.getElements(inputElement);
                int i = 0;
                while (i < elements.length) {
                    CFGArtifactLocationPair pair;
                    if (elements[i] instanceof CFGArtifactLocationPair && !(pair = (CFGArtifactLocationPair)elements[i]).getArtifact().eIsProxy() && !pair.getLocation().eIsProxy()) {
                        resolvedEls.add(pair);
                    }
                    ++i;
                }
                return resolvedEls.toArray();
            }
        });
        this.mapSection.setLabelProvider(new TableLabelProviderAdapter(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof CFGArtifactLocationPair) {
                    if (columnIndex == 0) {
                        return ((CFGArtifactLocationPair)element).getArtifact().getName();
                    }
                    if (columnIndex == 1) {
                        return ((CFGArtifactLocationPair)element).getLocation().getName();
                    }
                }
                return "";
            }
        });
        this.registerSection(this.mapSection);
        this.mapSection.setHeaderText(TestUIPlugin.getString("EDT_DEP_PAIR"));
        this.mapSection.setCollapsable(true);
        control = this.mapSection.createControl(southComposite, this.getWidgetFactory());
        GridData mapData = new GridData(1808);
        mapData.grabExcessHorizontalSpace = true;
        mapData.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)mapData);
        int i3 = 0;
        while (i3 < mapButtonActions.length) {
            IAction action = mapButtonActions[i3];
            if (action != null && action instanceof ChildrenSelectionAction) {
                ((ChildrenSelectionAction)action).setStructuredViewer((StructuredViewer)this.mapSection.getTableViewer());
            }
            ++i3;
        }
    }

    protected IAction[] createLocationSectionButtonActions() {
        IAction[] buttonActions = new IAction[5];
        this.addLocationAction = new AddLocationAction();
        buttonActions[0] = this.addLocationAction;
        buttonActions[1] = new RemoveFeatureChildrenAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations(), false);
        buttonActions[2] = new MoveFeatureChildrenUpAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations());
        buttonActions[3] = new MoveFeatureChildrenDownAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_RefLocations());
        buttonActions[4] = new OpenLocationAction();
        return buttonActions;
    }

    protected IAction[] createArifactSectionButtonActions() {
        IAction[] buttonActions = new IAction[5];
        this.addArtifactAction = new AddArtifactAction();
        buttonActions[0] = this.addArtifactAction;
        buttonActions[1] = new RemoveFeatureChildrenAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts(), false);
        buttonActions[2] = new MoveFeatureChildrenUpAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts());
        buttonActions[3] = new MoveFeatureChildrenDownAction(this.getEditorObject(), (EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_Artifacts());
        buttonActions[4] = new OpenArtifactAction();
        return buttonActions;
    }

    protected IAction[] createMapSectionButtonActions() {
        IAction[] buttonActions = new IAction[3];
        buttonActions[0] = new RemoveChildrenAction(false);
        buttonActions[1] = new MoveChildrenUpAction();
        ((MoveChildrenUpAction)buttonActions[1]).setEStructuralFeature((EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_ArtifactLocations());
        buttonActions[2] = new MoveChildrenDownAction();
        ((MoveChildrenDownAction)buttonActions[2]).setEStructuralFeature((EStructuralFeature)Common_TestprofilePackage.eINSTANCE.getTPFDeployment_ArtifactLocations());
        return buttonActions;
    }

    protected EObject getEditorObject() {
        return ((ConfigurableObjectEditorExtension)this.getBaseEditorExtension()).getEditorObject();
    }

    public void load() {
        TPFDeployment deployment = (TPFDeployment)this.getEditorObject();
        this.addArtifactAction.setDeployment(deployment);
        this.addLocationAction.setDeployment(deployment);
        this.artifactsSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.artifactsSection.setInput(deployment);
        this.artifactsSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.locationsSection.getTreeViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        this.locationsSection.setInput(deployment);
        this.locationsSection.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)this);
        this.mapSection.setInput(deployment);
    }

    public ISelection getSelection() {
        return this.mapSection.getTableViewer().getSelection();
    }

    public void updateTitle() {
        String title = ((IWorkbenchAdapter)((IAdaptable)this.getEditorObject()).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = ArtifactLocationMapForm.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)).getLabel((Object)this.getEditorObject());
        if (title != null) {
            this.getBaseEditorExtension().getHyadesEditorPart().setTitle(title);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection artifactSelection = this.artifactsSection.getStructuredSelection();
        IStructuredSelection locationSelection = this.locationsSection.getStructuredSelection();
        if (artifactSelection.size() == 1 && locationSelection.size() == 1) {
            if (this.pairExists((CFGArtifact)artifactSelection.getFirstElement(), (CFGLocation)locationSelection.getFirstElement())) {
                this.createPairButton.setEnabled(false);
                return;
            }
            this.createPairButton.setEnabled(true);
        } else {
            this.createPairButton.setEnabled(false);
        }
        if (event.getSource() == this.locationsSection.getTreeViewer() || event.getSource() == this.artifactsSection.getTreeViewer()) {
            UIUtil.getActiveWorkbenchPage().activate((IWorkbenchPart)this.getBaseEditorExtension().getHyadesEditorPart());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.createPairButton) {
            IStructuredSelection artifactSelection = this.artifactsSection.getStructuredSelection();
            IStructuredSelection locationSelection = this.locationsSection.getStructuredSelection();
            if (artifactSelection.size() == 1 && locationSelection.size() == 1) {
                if (this.pairExists((CFGArtifact)artifactSelection.getFirstElement(), (CFGLocation)locationSelection.getFirstElement())) {
                    return;
                }
                CFGArtifact artifact = (CFGArtifact)artifactSelection.getFirstElement();
                CFGLocation location = (CFGLocation)locationSelection.getFirstElement();
                CFGArtifactLocationPair pair = Common_ConfigurationFactory.eINSTANCE.createCFGArtifactLocationPair();
                pair.setArtifact(artifact);
                pair.setLocation(location);
                TPFDeployment deployment = (TPFDeployment)this.getEditorObject();
                deployment.getArtifactLocations().add((Object)pair);
                this.createPairButton.setEnabled(false);
            }
        }
    }

    private boolean pairExists(CFGArtifact art, CFGLocation loc) {
        TPFDeployment deployment = (TPFDeployment)this.getEditorObject();
        EList list = deployment.getArtifactLocations();
        if (!list.isEmpty()) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                CFGArtifactLocationPair pair = (CFGArtifactLocationPair)it.next();
                CFGArtifact artifact = pair.getArtifact();
                CFGLocation location = pair.getLocation();
                if (artifact != art || location != loc) continue;
                return true;
            }
        }
        return false;
    }

    public void selectReveal(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof CFGArtifact) {
            this.artifactsSection.selectReveal(selection);
        } else if (obj instanceof CFGLocation) {
            this.locationsSection.selectReveal(selection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

