/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.editor.form.base;

import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.ModifiedTextCellEditor;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TablePart;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class EditableTablePart
extends TablePart {
    private boolean editable;

    public EditableTablePart(String[] buttonLabels) {
        super(buttonLabels);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
        TableViewer tableViewer = (TableViewer)super.createStructuredViewer(parent, style, factory);
        if (this.editable) {
            Table table = tableViewer.getTable();
            CellEditor[] editors = new CellEditor[]{new ModifiedTextCellEditor((Composite)table)};
            String[] properties = new String[]{"name"};
            tableViewer.setCellEditors(editors);
            tableViewer.setCellModifier((ICellModifier)new NameModifier());
            tableViewer.setColumnProperties(properties);
            table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000B) {
                        EditableTablePart.this.activateEditMode();
                    }
                }
            });
        }
        return tableViewer;
    }

    protected void activateEditMode() {
        TableViewer viewer = this.getTableViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        if (selection.size() == 1 && !viewer.isCellEditorActive()) {
            viewer.editElement(selection.getFirstElement(), 0);
        }
    }

    protected void entryModified(Object entry, String value) {
    }

    class NameModifier
    implements ICellModifier {
        NameModifier() {
        }

        public boolean canModify(Object object, String property) {
            return true;
        }

        public void modify(Object object, String property, Object value) {
            EditableTablePart.this.entryModified(object, value.toString());
        }

        public Object getValue(Object object, String property) {
            return object.toString();
        }
    }
}

