/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.launch.tabs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.providers.ExecutionHistoryLocationProvider;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider;
import org.eclipse.hyades.test.ui.launch.extensions.IExecutionHistoryDefaultsProvider2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;

public class ExecutionHistoryTab
extends AbstractLaunchConfigurationTab {
    private TreeViewer tree;
    private Text nameText;
    private Button override;
    protected boolean userHasChosenName;
    protected boolean userHasChosenOverrideState;
    protected boolean userHasChosenLocation;
    private static final String PROPERTY_USER_HAS_CHOSEN_NAME = TestUIPlugin.getID() + "internal.launch.history.name_chosen";
    private static final String PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE = TestUIPlugin.getID() + "internal.launch.history.override_chosen";
    private static final String PROPERTY_USER_HAS_CHOSEN_LOCATION = TestUIPlugin.getID() + "internal.launch.history.location_chosen";

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label lblName = new Label(composite, 0);
        GridData gdl = new GridData(32);
        gdl.horizontalSpan = 2;
        lblName.setLayoutData((Object)gdl);
        lblName.setText(TestUIPlugin.getString("ExecutionHistoryTab.name"));
        this.nameText = new Text(composite, 2048);
        GridData gdt = new GridData(768);
        gdt.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)gdt);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                ExecutionHistoryTab.this.userHasChosenName = true;
            }
        });
        this.override = new Button(composite, 32);
        this.override.setText(TestUIPlugin.getString("ExecutionHistoryTab.override"));
        this.override.setToolTipText(TestUIPlugin.getString("ExecutionHistoryTab.overrideTooltip"));
        this.override.setSelection(false);
        this.override.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionHistoryTab.this.userHasChosenOverrideState = true;
            }
        });
        GridData gdl3 = new GridData(32);
        gdl3.horizontalSpan = 2;
        this.override.setLayoutData((Object)gdl3);
        Label lblLocation = new Label(composite, 0);
        GridData gdl2 = new GridData(32);
        gdl2.horizontalSpan = 2;
        lblLocation.setLayoutData((Object)gdl2);
        lblLocation.setText(TestUIPlugin.getString("ExecutionHistoryTab.location"));
        this.createLocationSelector(composite);
        this.setControl((Control)composite);
    }

    private void createLocationSelector(Composite composite) {
        GridData grid = new GridData(1808);
        grid.widthHint = composite.getClientArea().width / 2;
        grid.heightHint = composite.getClientArea().height / 2;
        this.tree = new TreeViewer(composite);
        this.tree.getControl().setLayoutData((Object)grid);
        ExecutionHistoryLocationProvider provider = new ExecutionHistoryLocationProvider();
        this.tree.setContentProvider((IContentProvider)provider);
        this.tree.setLabelProvider((IBaseLabelProvider)provider);
        this.tree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExecutionHistoryTab.this.updateLaunchConfigurationDialog();
                ExecutionHistoryTab.this.userHasChosenLocation = true;
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(configuration, this.computeDefaultName((ILaunchConfiguration)configuration));
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden(configuration, this.computeDefaultOverrideState((ILaunchConfiguration)configuration));
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(configuration, this.computeDefaultLocation((ILaunchConfiguration)configuration));
    }

    private IExecutionHistoryDefaultsProvider2 getExecutionHistoryDefaultsProvider2(ILaunchConfiguration configuration) {
        IExecutionHistoryDefaultsProvider2 defaultsProvider2;
        String launchConfigurationType = null;
        try {
            launchConfigurationType = configuration.getType().getIdentifier();
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
        if (launchConfigurationType != null && (defaultsProvider2 = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider2(launchConfigurationType)) != null) {
            return defaultsProvider2;
        }
        return null;
    }

    private String computeDefaultName(ILaunchConfiguration configuration) {
        String name = null;
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = this.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            name = defaultsProvider2.getDefaultName(configuration);
        }
        if (name == null) {
            TPFTest test = null;
            try {
                test = TestLaunchConfigurationFacade.getTest(configuration);
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
            IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
            if (defaultsProvider != null) {
                name = defaultsProvider.getDefaultName(test);
            }
            if (name == null) {
                name = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultName(test);
            }
        }
        return name;
    }

    private boolean computeDefaultOverrideState(ILaunchConfiguration configuration) {
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = this.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            return defaultsProvider2.getDefaultOverrideState(configuration);
        }
        TPFTest test = null;
        try {
            test = TestLaunchConfigurationFacade.getTest(configuration);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
        IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
        return defaultsProvider.getDefaultOverrideState(test);
    }

    private IContainer computeDefaultLocation(ILaunchConfiguration configuration) {
        IContainer location = null;
        IExecutionHistoryDefaultsProvider2 defaultsProvider2 = this.getExecutionHistoryDefaultsProvider2(configuration);
        if (defaultsProvider2 != null) {
            location = defaultsProvider2.getDefaultLocation(configuration);
        }
        if (location == null) {
            TPFTest test = null;
            try {
                test = TestLaunchConfigurationFacade.getTest(configuration);
            }
            catch (CoreException e) {
                TestUIPlugin.logError(e);
            }
            IExecutionHistoryDefaultsProvider defaultsProvider = LaunchConfigurationExtensionsManager.getInstance().getExecutionHistoryDefaultsProvider(test);
            location = defaultsProvider.getDefaultLocation(test);
            if (location == null) {
                location = LaunchConfigurationExtensionsManager.getInstance().getDefaultExecutionHistoryDefaultsProvider().getDefaultLocation(test);
            }
            if (location == null) {
                location = ExecutionHistoryTab.getContext();
            }
        }
        return location;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.userHasChosenName = this.getUserHasChosenName(configuration);
            this.userHasChosenOverrideState = this.getUserHasChosenOverrideState(configuration);
            this.userHasChosenLocation = this.getUserHasChosenLocation(configuration);
            String name = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
            if (name == null || !this.userHasChosenName) {
                this.nameText.setText(this.computeDefaultName(configuration));
                this.userHasChosenName = false;
            } else {
                this.nameText.setText(name);
            }
            boolean overrideState = !this.userHasChosenOverrideState ? this.computeDefaultOverrideState(configuration) : ExecutionHistoryLaunchConfigurationFacade.isExecutionHistoryOverriden(configuration);
            this.override.setSelection(overrideState);
            IContainer location = ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
            if (location == null || !this.userHasChosenLocation) {
                location = this.computeDefaultLocation(configuration);
            }
            if (location != null) {
                StructuredSelection sel = new StructuredSelection((Object)location);
                this.tree.setSelection((ISelection)sel, true);
            }
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String name = this.getExecutionHistoryName();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryName(configuration, name);
        boolean overrideState = this.getOverrideState();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryOverriden(configuration, overrideState);
        IContainer location = this.getSelectedLocation();
        ExecutionHistoryLaunchConfigurationFacade.setExecutionHistoryLocation(configuration, location);
        this.setUserHasChosenName(configuration, this.userHasChosenName);
        this.setUserHasChosenOverrideState(configuration, this.userHasChosenOverrideState);
        this.setUserHasChosenLocation(configuration, this.userHasChosenLocation);
    }

    public String getName() {
        return TestUIPlugin.getString("ExecutionHistoryTab.tabName");
    }

    public Image getImage() {
        return TestUIImages.INSTANCE.getImage("launch_execresultstab.gif");
    }

    private String getExecutionHistoryName() {
        return this.nameText.getText();
    }

    public boolean getOverrideState() {
        return this.override.getSelection();
    }

    private IContainer getSelectedLocation() {
        Object obj;
        ISelection selection = this.tree.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof IContainer) {
            return (IContainer)obj;
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        String name = this.getExecutionHistoryName();
        if (name == null || name.equals("")) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_ExecutionHistoryTab.invalidName"));
            return false;
        }
        IContainer location = this.getSelectedLocation();
        if (location == null) {
            this.setErrorMessage(TestUIPlugin.getString("_ERROR_ExecutionHistoryTab.invalidLocation"));
            return false;
        }
        return true;
    }

    public static IContainer getContext() {
        try {
            IProject project;
            IStructuredSelection ss;
            Object obj;
            ISelection selection;
            IWorkbenchPage page = TestUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null && (selection = page.getSelection()) instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IResource && (project = ((IResource)obj).getProject()) != null) {
                return project;
            }
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
        }
        return null;
    }

    private boolean getUserHasChosenName(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_USER_HAS_CHOSEN_NAME, false);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    private boolean getUserHasChosenOverrideState(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE, false);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    private boolean getUserHasChosenLocation(ILaunchConfiguration configuration) {
        try {
            return configuration.getAttribute(PROPERTY_USER_HAS_CHOSEN_LOCATION, false);
        }
        catch (CoreException e) {
            TestUIPlugin.logError(e);
            return true;
        }
    }

    private void setUserHasChosenName(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_USER_HAS_CHOSEN_NAME, value);
    }

    private void setUserHasChosenOverrideState(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_USER_HAS_CHOSEN_OVERRIDE_STATE, value);
    }

    private void setUserHasChosenLocation(ILaunchConfigurationWorkingCopy configuration, boolean value) {
        configuration.setAttribute(PROPERTY_USER_HAS_CHOSEN_LOCATION, value);
    }
}

