/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.delegates;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.harness.TestExecutionHarness;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.test.ui.launch.configurations.DeploymentLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.ExecutionHistoryLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.configurations.TestLaunchConfigurationFacade;
import org.eclipse.hyades.test.ui.launch.delegates.AbstractLaunchConfigurationDelegate;
import org.eclipse.hyades.test.ui.util.ArtifactUtil;

public class BasicTestLaunchConfigurationDelegate
extends AbstractLaunchConfigurationDelegate {
    protected TPFTest getLaunchedTest(ILaunchConfiguration configuration) throws CoreException {
        TPFTest test = TestLaunchConfigurationFacade.getTest(configuration);
        if (test != null) {
            EObject obj = EMFUtil.getEObjectInResourceSet((EObject)test, (ResourceSet)new ResourceSetImpl());
            return obj == null ? null : (TPFTest)obj;
        }
        return null;
    }

    protected TPFDeployment getDeployment(ILaunchConfiguration configuration) throws CoreException {
        TPFDeployment depl = DeploymentLaunchConfigurationFacade.getDeployment(configuration);
        if (depl != null) {
            EObject obj = EMFUtil.getEObjectInResourceSet((EObject)depl, (ResourceSet)new ResourceSetImpl());
            depl = (TPFDeployment)obj;
            ArtifactUtil.adjustDefaultLocation(depl, this.getLaunchedTest(configuration));
            return depl;
        }
        return null;
    }

    protected String getTestExecutionHistoryName(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryName(configuration);
    }

    protected IContainer getTestExecutionHistoryLocation(ILaunchConfiguration configuration) throws CoreException {
        return ExecutionHistoryLaunchConfigurationFacade.getExecutionHistoryLocation(configuration);
    }

    protected Object getLaunchedElement(ILaunchConfiguration configuration) throws CoreException {
        return this.getLaunchedTest(configuration);
    }

    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
        IContainer tehLocation;
        String tehName;
        super.validate(configuration, mode);
        if (this.getDeployment(configuration) == null) {
            this.reportProblem("The configuration does not provide a Deployment");
        }
        if ((tehName = this.getTestExecutionHistoryName(configuration)) == null || tehName.equals("")) {
            this.reportProblem("The configuration does not provide a Test Execution History Name");
        }
        if ((tehLocation = this.getTestExecutionHistoryLocation(configuration)) == null) {
            this.reportProblem("The configuration does not provide a Test Execution History Location");
        } else if (!tehLocation.exists()) {
            this.reportProblem("The Test Execution History Location described by the configuration does not exist");
        }
    }

    public IExecutor invokeTestExecutionHarness(ILaunchConfiguration configuration, String mode, StringBuffer errorMessages) throws CoreException {
        TPFTest test = this.getLaunchedTest(configuration);
        TPFTestSuite testSuite = null;
        TPFTest subTest = null;
        if (test instanceof TPFTestCase) {
            subTest = test;
            testSuite = ((TPFTestCase)subTest).getTestSuite();
        } else if (test instanceof TPFTestSuite) {
            testSuite = (TPFTestSuite)test;
            subTest = test;
        }
        TPFDeployment deployment = this.getDeployment(configuration);
        String tehName = this.getTestExecutionHistoryName(configuration);
        String tehLocation = this.getTestExecutionHistoryLocation(configuration).getFullPath().toString();
        String port = TestUIPlugin.getInstance().getPreferenceStore().getString("localhost_port");
        TestExecutionHarness teh = new TestExecutionHarness();
        IExecutor executor = teh.launchTest((ITestSuite)testSuite, (ITest)subTest, deployment, port, tehLocation, tehName, true, false, errorMessages);
        SaveManager.getInstance().start(TestUIPlugin.getInstance().getPreferenceStore().getLong("saveInterval"));
        return executor;
    }
}

