/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.testgen.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.IProperty;
import org.eclipse.hyades.models.common.facades.behavioral.IPropertyGroup;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonPlugin;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;
import org.eclipse.hyades.test.http.TestHttpPlugin;
import org.eclipse.hyades.test.http.internal.util.RequestHelper;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.hyades.ui.internal.util.JavaUtil;
import org.eclipse.hyades.ui.util.IDisposable;

public class TRCContext
implements IDisposable {
    private RequestHelper requestHelper;
    private List resources;
    private IPath testSuiteFolderPath;
    private String testSuiteBaseName;
    private ITestSuite currentTestSuite;
    private int testCaseCounter;
    private ITestCase currentTestCase;
    private ILoop currentLoop;
    private ILoop currentPage;
    public static final String GLOBAL_LASTRECV = "__global";
    private LinkedList pageList;
    private int pageNumber = 0;
    private HashMap lastRecvHashMap = new HashMap();

    public TRCContext() {
        this.requestHelper = new RequestHelper();
        this.pageList = new LinkedList();
        this.lastRecvHashMap.put(GLOBAL_LASTRECV, new Integer(-1));
    }

    public RequestHelper getRequestHelper() {
        return this.requestHelper;
    }

    public void setOutputFolder(IPath iPath) {
        this.testSuiteFolderPath = iPath;
    }

    public void setTestSuiteBaseName(String string) {
        this.testSuiteBaseName = string;
    }

    public ITestSuite newTestSuiteContext() {
        this.currentTestSuite = this.createTestSuite();
        this.currentLoop = this.createLoop();
        this.currentTestSuite.getImplementor().getBlock().getActions().add(this.currentLoop);
        return this.currentTestSuite;
    }

    public ITestCase newTestCaseContext(String string) {
        this.currentTestCase = this.createTestCase(this.currentTestSuite, this.currentPage, string);
        this.requestHelper.setTestCase(this.currentTestCase);
        return this.currentTestCase;
    }

    public void finish() {
        this.saveResources();
        this.dispose();
    }

    public void dispose() {
        if (this.requestHelper != null) {
            this.requestHelper.dispose();
        }
        if (this.resources != null) {
            this.resources.clear();
        }
    }

    private ITestSuite createTestSuite() {
        String string;
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        IPath iPath = this.testSuiteFolderPath.append(this.testSuiteBaseName).addFileExtension("testsuite");
        URI uRI = URI.createPlatformResourceURI((String)iPath.toString());
        Resource resource = EMFUtil.getResourceFactory((String)"testsuite").createResource(uRI);
        this.resources.add(resource);
        ITestSuite iTestSuite = HyadesFactory.INSTANCE.createTestSuite(resource);
        iTestSuite.setType("org.eclipse.hyades.test.http.junit.testSuite");
        iTestSuite.setName(this.testSuiteBaseName);
        if (iTestSuite.getImplementor() == null) {
            HyadesFactory.INSTANCE.createImplementor((ITest)iTestSuite, false);
        }
        if ((string = JavaUtil.getValidClassName((String)iTestSuite.getName(), (boolean)true)) == null) {
            string = "Test";
        }
        iTestSuite.getImplementor().setResource("test." + string);
        return iTestSuite;
    }

    private ITestCase createTestCase(ITestSuite iTestSuite, ILoop iLoop, String string) {
        String string2 = ++this.testCaseCounter + " " + string;
        ITestCase iTestCase = TestCommonUtil.createTestCase((ITestSuite)iTestSuite, (String)"org.eclipse.hyades.test.http.junit.testCase", (boolean)false, (String)string2);
        ITestInvocation iTestInvocation = HyadesFactory.INSTANCE.createTestInvocation((ITest)iTestCase);
        iLoop.getBlock().getActions().add(iTestInvocation);
        String string3 = TestJavaPlugin.getString((String)"W_LWR_INV");
        String string4 = iTestCase.getName();
        if (string4 == null) {
            iTestInvocation.setName(TestCommonUtil.getUniqueName((String)string3, (List)iLoop.getBlock().getActions()));
        } else {
            iTestInvocation.setName(TestCommonPlugin.getString((String)"NME_CONCAT_SEP", (String[])new String[]{string4, string3}));
        }
        return iTestCase;
    }

    private ILoop createLoop() {
        return this.createLoop(TestJavaPlugin.getString((String)"W_LOOP") + " " + 1, 1);
    }

    private void saveResources() {
        Iterator iterator = this.resources.iterator();
        while (iterator.hasNext()) {
            try {
                EMFUtil.save((Resource)((Resource)iterator.next()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public LinkedList getPageList() {
        return this.pageList;
    }

    public void setPageList(LinkedList linkedList) {
        this.pageList = linkedList;
    }

    public ILoop createNewPage(int n) {
        this.currentPage = this.createPage(n);
        this.currentLoop.getBlock().getActions().add(this.currentPage);
        return this.currentPage;
    }

    public ILoop createNewPage(String string) {
        this.currentPage = this.createPage(TestHttpPlugin.getString((String)"Page") + " " + string);
        this.currentLoop.getBlock().getActions().add(this.currentPage);
        return this.currentPage;
    }

    private ILoop createLoop(String string, int n) {
        ILoop iLoop = HyadesFactory.INSTANCE.createLoop();
        iLoop.setName(string);
        iLoop.getCondition().setConstraint(Integer.toString(n));
        return iLoop;
    }

    private ILoop createPage(int n) {
        return this.createPage(TestHttpPlugin.getString((String)"Page") + " " + Integer.toString(n));
    }

    private ILoop createPage(String string) {
        ILoop iLoop = this.createLoop(string, 1);
        IPropertyGroup iPropertyGroup = iLoop.getActionProperties();
        List list = iPropertyGroup.getProperties();
        IProperty iProperty = HyadesFactory.INSTANCE.createProperty();
        iProperty.setName("HTTPPAGE");
        iProperty.setValue("true");
        list.add(iProperty);
        return iLoop;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int n) {
        this.pageNumber = n;
    }

    public HashMap getLastRecvHashMap() {
        return this.lastRecvHashMap;
    }

    public void setLastRecvHashMap(HashMap hashMap) {
        this.lastRecvHashMap = hashMap;
    }
}

