/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.report.svg;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;

public class DayHelper {

    public static class DataDay
    implements Comparable {
        private String day;
        private Hashtable executionVerdictByTestcase;

        public DataDay(String day) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                this.day = format.format(format.parse(day));
                if (!this.day.equals(day)) {
                    throw new ParseException("Invalid date format.", 0);
                }
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe.getMessage());
            }
            this.executionVerdictByTestcase = new Hashtable();
        }

        public String getDay() {
            return this.day;
        }

        public void addVerdict(TPFTestSuite testSuite, TPFVerdict verdict) {
            this.executionVerdictByTestcase.put(testSuite, verdict);
        }

        public TPFVerdict getVerdict(TPFTestSuite testSuite) {
            return (TPFVerdict)this.executionVerdictByTestcase.get(testSuite);
        }

        public Iterator testcaseIterator() {
            return this.executionVerdictByTestcase.keySet().iterator();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && object instanceof DataDay) {
                return this.hashCode() == object.hashCode();
            }
            return false;
        }

        public int hashCode() {
            return this.day.hashCode();
        }

        public int compareTo(Object object) {
            DataDay graphDay = (DataDay)object;
            if (this.equals(graphDay)) {
                return 0;
            }
            if (graphDay == null) {
                return 1;
            }
            return this.hashCode() - graphDay.hashCode() > 0 ? 1 : -1;
        }
    }

    public static class GraphDay
    implements Cloneable {
        public static final int EXPECTED_ATTEMPT = -109;
        public static final int EXPECTED_ERROR = -108;
        public static final int EXPECTED_PASS = -107;
        public static final int EXPECTED_FAIL = -106;
        public static final int EXPECTED_INCONCLUSIVE = -105;
        public static final int ATTEMPT = -104;
        public static final int ERROR = -103;
        public static final int PASS = -102;
        public static final int FAIL = -101;
        public static final int INCONCLUSIVE = -100;
        private static boolean hasExpectedAttempt = false;
        private static boolean hasExpectedError = false;
        private static boolean hasExpectedPass = false;
        private static boolean hasExpectedFail = false;
        private static boolean hasExpectedInconclusive = false;
        private static boolean hasAttempt = false;
        private static boolean hasError = false;
        private static boolean hasPass = false;
        private static boolean hasFail = false;
        private static boolean hasInconclusive = false;
        private String day;
        private int expectedAttempt;
        private int expectedError;
        private int expectedPass;
        private int expectedFail;
        private int expectedInconclusive;
        private int attempt;
        private int error;
        private int pass;
        private int fail;
        private int inconclusive;

        public GraphDay(String day) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                this.day = format.format(format.parse(day));
                if (!this.day.equals(day)) {
                    throw new ParseException("Invalid date format.", 0);
                }
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe.getMessage());
            }
        }

        public static void reset() {
            hasExpectedAttempt = false;
            hasExpectedError = false;
            hasExpectedPass = false;
            hasExpectedFail = false;
            hasExpectedInconclusive = false;
            hasAttempt = false;
            hasError = false;
            hasPass = false;
            hasFail = false;
            hasInconclusive = false;
        }

        public String getDay() {
            return this.day;
        }

        public String getDayOfMonth() {
            return this.day.substring("yyyyMM".length());
        }

        public String getFormattedDay() {
            String day = this.getDay();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            try {
                Date dateObj = formatter.parse(day);
                DateFormat df = DateFormat.getDateInstance(3);
                return df.format(dateObj);
            }
            catch (ParseException pe) {
                return day;
            }
        }

        public int getStatistic(int flag) {
            switch (flag) {
                case -109: {
                    return this.expectedAttempt;
                }
                case -108: {
                    return this.expectedError;
                }
                case -107: {
                    return this.expectedPass;
                }
                case -106: {
                    return this.expectedFail;
                }
                case -105: {
                    return this.expectedInconclusive;
                }
                case -104: {
                    return this.attempt;
                }
                case -103: {
                    return this.error;
                }
                case -102: {
                    return this.pass;
                }
                case -101: {
                    return this.fail;
                }
                case -100: {
                    return this.inconclusive;
                }
            }
            return -1;
        }

        public static boolean hasStatistic(int flag) {
            switch (flag) {
                case -109: {
                    return hasExpectedAttempt;
                }
                case -108: {
                    return hasExpectedError;
                }
                case -107: {
                    return hasExpectedPass;
                }
                case -106: {
                    return hasExpectedFail;
                }
                case -105: {
                    return hasExpectedInconclusive;
                }
                case -104: {
                    return hasAttempt;
                }
                case -103: {
                    return hasError;
                }
                case -102: {
                    return hasPass;
                }
                case -101: {
                    return hasFail;
                }
                case -100: {
                    return hasInconclusive;
                }
            }
            return false;
        }

        public void addStatistic(int flag, int value) {
            switch (flag) {
                case -109: {
                    this.expectedAttempt += value;
                    hasExpectedAttempt = this.expectedAttempt > 0;
                    break;
                }
                case -108: {
                    this.expectedError += value;
                    hasExpectedError = this.expectedError > 0;
                    break;
                }
                case -107: {
                    this.expectedPass += value;
                    hasExpectedPass = this.expectedPass > 0;
                    break;
                }
                case -106: {
                    this.expectedFail += value;
                    hasExpectedFail = this.expectedFail > 0;
                    break;
                }
                case -105: {
                    this.expectedInconclusive += value;
                    hasExpectedInconclusive = this.expectedInconclusive > 0;
                    break;
                }
                case -103: {
                    this.error += value;
                    hasError = this.error > 0;
                    break;
                }
                case -104: {
                    this.attempt += value;
                    hasAttempt = this.attempt > 0;
                    break;
                }
                case -102: {
                    this.pass += value;
                    hasPass = this.pass > 0;
                    break;
                }
                case -101: {
                    this.fail += value;
                    hasFail = this.fail > 0;
                    break;
                }
                case -100: {
                    this.inconclusive += value;
                    hasInconclusive = this.inconclusive > 0;
                }
            }
        }

        public GraphDay incrementDay() {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                format.parse(this.day);
                format.getCalendar().add(5, 1);
                this.day = format.format(format.getCalendar().getTime());
            }
            catch (ParseException pe) {
                throw new RuntimeException(pe.getMessage());
            }
            return this;
        }

        public Object clone() {
            GraphDay graphDay = new GraphDay(this.day);
            graphDay.expectedAttempt = this.expectedAttempt;
            graphDay.expectedError = this.expectedError;
            graphDay.expectedPass = this.expectedPass;
            graphDay.expectedFail = this.expectedFail;
            graphDay.expectedInconclusive = this.expectedInconclusive;
            graphDay.attempt = this.attempt;
            graphDay.error = this.error;
            graphDay.pass = this.pass;
            graphDay.fail = this.fail;
            graphDay.inconclusive = this.inconclusive;
            return graphDay;
        }
    }
}

