/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.java;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class TestJavaPlugin
extends AbstractUIPlugin {
    private static TestJavaPlugin instance;
    private ResourceBundleManager resourceBundleManager;

    public TestJavaPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        instance = this;
    }

    public static TestJavaPlugin getInstance() {
        return instance;
    }

    public void startup() throws CoreException {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getDescriptor().getResourceBundle());
        this.resourceBundleManager.add(HyadesUIPlugin.getInstance().getResourceBundle());
        this.resourceBundleManager.add(TestUIPlugin.getInstance().getResourceBundle());
        super.startup();
        try {
            TestJavaImages.INSTANCE.initialize(new URL(this.getDescriptor().getInstallURL(), "icons/full/"), this.getImageRegistry());
        }
        catch (Exception exception) {
            TestJavaPlugin.logError(exception);
        }
    }

    public void shutdown() throws CoreException {
        this.resourceBundleManager.dispose();
        instance = null;
        super.shutdown();
    }

    public ResourceBundle getResourceBundle() {
        return this.getDescriptor().getResourceBundle();
    }

    public static String getID() {
        return instance.getDescriptor().getUniqueIdentifier();
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(1, TestJavaPlugin.getID(), 0, throwable.toString(), throwable);
        TestJavaPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static void logError(String string) {
        TestJavaPlugin.logError(new Throwable(string));
    }

    public static void logInfo(String string) {
        Status status = new Status(3, TestJavaPlugin.getID(), 0, string, new Throwable(string));
        TestJavaPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static String getString(String string) throws NullPointerException, MissingResourceException {
        return TestJavaPlugin.instance.resourceBundleManager.getString(string);
    }

    public static String getString(String string, String string2) throws NullPointerException, MissingResourceException {
        return TestJavaPlugin.instance.resourceBundleManager.getString(string, string2);
    }

    public static String getString(String string, String[] stringArray) throws NullPointerException, MissingResourceException {
        return TestJavaPlugin.instance.resourceBundleManager.getString(string, stringArray);
    }
}

