/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.manual.internal.codegen;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.test.common.internal.codegen.Helper;
import org.eclipse.hyades.test.common.util.XMLUtil;

class GenTestSuite {
    protected final String NL = System.getProperties().getProperty("line.separator");
    protected final String TEXT_1 = "\t\t" + this.NL;
    protected final String TEXT_2 = this.NL + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + this.NL + "<testScript>";
    protected final String TEXT_3 = this.NL + "<verdicts>";
    protected final String TEXT_4 = this.NL + "<verdict";
    protected final String TEXT_5 = "/>";
    protected final String TEXT_6 = this.NL + "</verdicts>" + this.NL + "</testScript>";

    GenTestSuite() {
    }

    public String generate(ITestSuite iTestSuite, Helper helper) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.TEXT_1);
        class Util {
            private Set generatedTestSuites;
            private StringBuffer stringBuffer;
            private final /* synthetic */ Helper val$helper;

            public Util(StringBuffer stringBuffer, Helper helper) {
                this.val$helper = helper;
                this.stringBuffer = stringBuffer;
            }

            public void dispose() {
                if (this.generatedTestSuites != null) {
                    this.generatedTestSuites.clear();
                }
            }

            public void createXMLAttribute(String string, String string2) {
                if (string == null || string2 == null) {
                    return;
                }
                this.stringBuffer.append(XMLUtil.createXMLAttribute((String)string, (String)string2, (boolean)false));
            }

            public void generate(ITestSuite iTestSuite) {
                ITestCase iTestCase;
                Iterator iterator;
                if (this.generatedTestSuites == null) {
                    this.generatedTestSuites = new HashSet();
                } else if (this.generatedTestSuites.contains(iTestSuite)) {
                    return;
                }
                this.generatedTestSuites.add(iTestSuite);
                this.stringBuffer.append(GenTestSuite.this.NL).append("<testSuite");
                this.createXMLAttribute("id", iTestSuite.getId());
                this.createXMLAttribute("name", iTestSuite.getName());
                this.createXMLAttribute("location", this.val$helper.getFilePath((Object)iTestSuite));
                this.createXMLAttribute("description", iTestSuite.getDescription());
                boolean bl = false;
                List list = iTestSuite.getITestCases();
                if (!list.isEmpty()) {
                    bl = true;
                    this.stringBuffer.append(">");
                    this.stringBuffer.append(GenTestSuite.this.NL).append("<testCases>");
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iTestCase = (ITestCase)iterator.next();
                        this.stringBuffer.append(GenTestSuite.this.NL).append("<testCase");
                        this.createXMLAttribute("id", iTestCase.getId());
                        this.createXMLAttribute("name", iTestCase.getName());
                        this.createXMLAttribute("description", iTestCase.getDescription());
                        this.stringBuffer.append("/>");
                    }
                    this.stringBuffer.append(GenTestSuite.this.NL).append("</testCases>");
                }
                if (!(list = iTestSuite.getIReferencedSuites()).isEmpty()) {
                    bl = true;
                    this.stringBuffer.append(">");
                    this.stringBuffer.append(GenTestSuite.this.NL).append("<referencedTestSuites>");
                    bl = true;
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.generate((ITestSuite)iterator.next());
                    }
                    this.stringBuffer.append(GenTestSuite.this.NL).append("</referencedTestSuites>");
                }
                if (iTestSuite.getImplementor() != null && !(list = iTestSuite.getImplementor().getBlock().getActions()).isEmpty()) {
                    bl = true;
                    this.stringBuffer.append(">");
                    this.stringBuffer.append(GenTestSuite.this.NL).append("<behavior>");
                    bl = true;
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        iTestCase = (IAction)iterator.next();
                        if (iTestCase instanceof ITestInvocation) {
                            this.generate((ITestInvocation)iTestCase);
                            continue;
                        }
                        if (!(iTestCase instanceof ILoop)) continue;
                        this.generate((ILoop)iTestCase);
                    }
                    this.stringBuffer.append(GenTestSuite.this.NL).append("</behavior>");
                }
                if (bl) {
                    this.stringBuffer.append(GenTestSuite.this.NL).append("</testSuite>");
                } else {
                    this.stringBuffer.append("/>");
                }
            }

            public void generate(ITestInvocation iTestInvocation) {
                this.stringBuffer.append(GenTestSuite.this.NL).append("<testInvocation");
                this.createXMLAttribute("id", iTestInvocation.getId());
                this.createXMLAttribute("name", iTestInvocation.getName());
                this.createXMLAttribute("synchronous", new Boolean(iTestInvocation.isSynchronous()).toString());
                if (iTestInvocation.getInvokedTest() != null) {
                    this.createXMLAttribute("testId", iTestInvocation.getInvokedTest().getId());
                }
                this.createXMLAttribute("description", iTestInvocation.getDescription());
                this.stringBuffer.append("/>");
            }

            public void generate(ILoop iLoop) {
                this.stringBuffer.append(GenTestSuite.this.NL).append("<loop");
                this.createXMLAttribute("id", iLoop.getId());
                this.createXMLAttribute("name", iLoop.getName());
                this.createXMLAttribute("synchronous", new Boolean(iLoop.isSynchronous()).toString());
                this.createXMLAttribute("iterations", iLoop.getCondition().getConstraint());
                this.createXMLAttribute("description", iLoop.getDescription());
                List list = iLoop.getBlock().getActions();
                if (!list.isEmpty()) {
                    this.stringBuffer.append(">");
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        IAction iAction = (IAction)iterator.next();
                        if (iAction instanceof ITestInvocation) {
                            this.generate((ITestInvocation)iAction);
                            continue;
                        }
                        if (!(iAction instanceof ILoop)) continue;
                        this.generate((ILoop)iAction);
                    }
                    this.stringBuffer.append(GenTestSuite.this.NL).append("</loop>");
                } else {
                    this.stringBuffer.append("/>");
                }
            }
        }
        Util util = new Util(stringBuffer, helper);
        stringBuffer.append(this.TEXT_2);
        util.generate(iTestSuite);
        stringBuffer.append(this.TEXT_3);
        Iterator iterator = TPFVerdict.VALUES.iterator();
        while (iterator.hasNext()) {
            TPFVerdict tPFVerdict = (TPFVerdict)iterator.next();
            String string = XMLUtil.createXMLAttribute((String)"label", (String)tPFVerdict.getLabel(), (boolean)false).toString();
            String string2 = XMLUtil.createXMLAttribute((String)"value", (String)Integer.toString(tPFVerdict.getValue()), (boolean)false).toString();
            String string3 = XMLUtil.createXMLAttribute((String)"isDefault", (String)new Boolean(tPFVerdict.getValue() == 1).toString(), (boolean)false).toString();
            stringBuffer.append(this.TEXT_4);
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append(string3);
            stringBuffer.append("/>");
        }
        util.dispose();
        stringBuffer.append(this.TEXT_6);
        return stringBuffer.toString();
    }
}

