/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.harness;

import java.net.InetAddress;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.execution.harness.IExecutionHarnessDataProcessor2;
import org.eclipse.hyades.internal.execution.local.common.DataServerListener;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.loaders.common.ExecutionContext;
import org.eclipse.hyades.loaders.hierarchy.IgnoredXMLFragmentLoader;
import org.eclipse.hyades.loaders.util.InvalidXMLException;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

public class XMLExecutionDataProcessor
extends XMLLoader
implements DataServerListener,
IExecutionHarnessDataProcessor2 {
    private final String START_TAG = "<EXECUTION>";
    private final String XML_VERSION_TAG = "<?xml version=\"1.0\"?>";
    public static final String IID = "org.eclipse.hyades.execution.harness.XMLExecutionDataProcessor";
    private ITest test = null;
    private Agent controlAgent = null;
    private Process process = null;
    private static HashMap contextMap = new HashMap();
    private String hostName;
    private String executionResultName;
    private boolean overrideExistingExcResult = false;
    private String executionResultLocation;
    private String portNumber;

    public XMLExecutionDataProcessor() {
        super((TRCMonitor)null);
    }

    protected boolean isIgnoredElement() {
        if (this.startDocument) {
            if (this.currentElementName == null) {
                return true;
            }
            if (this.currentElementName.equals("EXECUTION")) {
                return true;
            }
            this.startDocument = false;
        }
        return false;
    }

    protected boolean isValidTag(String buf) {
        return !buf.startsWith("<EXECUTION>") && !buf.startsWith("<?xml version=\"1.0\"?>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataServerExited() {
        ExecutionContext eContext;
        ExecutionContext executionContext = eContext = (ExecutionContext)this.context.getCustomData().get(ExecutionContext.root);
        synchronized (executionContext) {
            if (eContext.decrementAgentCount() == 0) {
                Thread contextCleaner = new Thread(){

                    public void run() {
                        try {
                            1.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        eContext.cleanUp();
                        contextMap.remove(XMLExecutionDataProcessor.this.executionResultLocation + "/" + XMLExecutionDataProcessor.this.executionResultName);
                    }
                };
                contextCleaner.setName("context cleanup");
                contextCleaner.start();
            }
        }
        this.cleanUp();
    }

    public void incommingData(byte[] buffer, int length, InetAddress peer) {
        try {
            super.loadEvent(buffer, length);
        }
        catch (InvalidXMLException e) {
            // empty catch block
        }
    }

    public void incommingData(char[] buffer, int length, InetAddress peer) {
        byte[] newBuffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            newBuffer[i] = (byte)buffer[i];
        }
        this.incommingData(newBuffer, newBuffer.length, peer);
    }

    public void invalidDataType(byte[] data, int length, InetAddress peer) {
    }

    public void waitingForData() {
    }

    public void init() {
        this.defaultLoader = new IgnoredXMLFragmentLoader();
        if (!(this.getTest() instanceof TPFTestSuite)) {
            return;
        }
        ExecutionContext eContext = (ExecutionContext)contextMap.get(this.executionResultLocation + "/" + this.executionResultName);
        if (eContext == null) {
            TPFTestSuite suite = (TPFTestSuite)this.getTest();
            eContext = new ExecutionContext(suite, suite.getId(), this.executionResultLocation, this.executionResultName, this.overrideExistingExcResult);
            contextMap.put(this.executionResultLocation + "/" + this.executionResultName, eContext);
        }
        eContext.incrementAgentCount();
        this.context.getCustomData().put(ExecutionContext.root, eContext);
    }

    public IConfigurationElement getConfigElement() {
        return null;
    }

    public String getID() {
        return IID;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void setConfigElement(IConfigurationElement theElement) {
    }

    public ITest getTest() {
        return this.test;
    }

    public Agent getControlAgent() {
        return this.controlAgent;
    }

    public void setControlAgent(Agent agent) {
        this.controlAgent = agent;
    }

    public void setInitData(ITest test, String hostName, String executionResultName, String executionResultLocation, String portNumber) {
        this.setInitData(test, hostName, executionResultName, executionResultLocation, false, portNumber);
    }

    public void setInitData(ITest theTest, String hostName, String executionResultName, String executionResultLocation, boolean overwriteExistingResults, String portNumber) {
        this.test = theTest;
        this.hostName = hostName;
        this.executionResultName = executionResultName;
        this.overrideExistingExcResult = overwriteExistingResults;
        this.executionResultLocation = executionResultLocation;
        this.portNumber = portNumber;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }
}

