/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class CSVBufferedReader
extends BufferedReader {
    private static Character LINEFEED = new Character('\n');
    private static Character DOUBLEQUOTE = new Character('\"');
    private static Character CARRIAGERETURN = new Character('\r');

    public CSVBufferedReader(Reader in) {
        super(in);
    }

    public String readLine() throws IOException {
        String line = null;
        boolean keepReading = true;
        boolean inQuoteRegion = false;
        int quoteCount = 0;
        int charIntVal = this.read();
        Character character = null;
        if (charIntVal != -1) {
            character = new Character((char)charIntVal);
        }
        while (charIntVal != -1 && keepReading) {
            if (DOUBLEQUOTE.compareTo(character) == 0) {
                ++quoteCount;
            }
            if (!(inQuoteRegion = quoteCount != 0 && quoteCount % 2 != 0) && LINEFEED.compareTo(character) == 0) {
                keepReading = false;
            }
            if (!keepReading) continue;
            if (inQuoteRegion || CARRIAGERETURN.compareTo(character) != 0) {
                if (line == null) {
                    line = new String();
                }
                line = line + new String(character.toString());
            }
            if ((charIntVal = this.read()) == -1) continue;
            character = new Character((char)charIntVal);
        }
        return line;
    }
}

