/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.hyades.ui.sample.svg.generator.DOMDataRetriever;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputConstants;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommonDataRetriever
extends DOMDataRetriever
implements IDataInputProcessingExceptionCodes,
IDataInputConstants {
    CommonDataRetriever() {
    }

    public int getNumberOfDatasets(Document dataDocument) throws DataInputProcessingException {
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        int number = this.getNumberOfElements(dataDocument, "dataSet");
        return number;
    }

    public Hashtable getConfigurationAttributes(Document configDocument, Document dataDocument) throws DataInputProcessingException {
        Document document;
        Document document2 = document = configDocument != null ? configDocument : dataDocument;
        if (document == null) {
            this.throwException((short)114, "");
        }
        Hashtable properties = this.getAttributesFromSingleElement(document, "configuration");
        return properties;
    }

    public String[] getLegendLabels(Document dataDocument) throws DataInputProcessingException {
        Vector labels;
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        if ((labels = this.getAttributeFromElements(dataDocument, "dataSet", "label")) == null) {
            this.throwException((short)118, "dataSet");
        }
        int labelsSize = labels.size();
        String[] result = new String[labelsSize];
        Vector positions = this.getAttributeFromElements(dataDocument, "dataSet", "position");
        if (positions == null) {
            int i = 0;
            while (i < labelsSize) {
                result[i] = (String)labels.get(i);
                ++i;
            }
            return result;
        }
        if (labelsSize != positions.size()) {
            this.throwException((short)107, "dataSet");
        }
        int i = 0;
        while (i < labelsSize) {
            short position = 0;
            try {
                position = Short.parseShort((String)positions.get(i));
            }
            catch (Exception exc) {
                this.throwException((short)102, "dataSet");
            }
            if (position > labelsSize - 1 || position < 0) {
                this.throwException((short)125, "dataSet");
            }
            String test = null;
            try {
                test = result[position];
            }
            catch (Exception e) {
                // empty catch block
            }
            if (test != null) {
                this.throwException((short)101, "dataSet");
            }
            result[position] = (String)labels.get(i);
            ++i;
        }
        return result;
    }

    public String getTimestamp(Document dataDocument) throws DataInputProcessingException {
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        String timestamp = this.getAttributeFromSingleElement(dataDocument, "dataUpdate", "timestamp");
        return timestamp;
    }

    public DataRange getDataRange(Document dataDocument, String location) throws DataInputProcessingException {
        String t;
        NodeList ranges = dataDocument.getElementsByTagName("dataRange");
        Element range = null;
        int length = ranges.getLength();
        if (location == null || location.equals("")) {
            if (length <= 0) {
                return null;
            }
            range = (Element)ranges.item(0);
        } else {
            int i = 0;
            while (i < length) {
                Element r = (Element)ranges.item(i);
                if (r.getAttribute("location").equals(location)) {
                    range = r;
                    break;
                }
                ++i;
            }
        }
        if (range == null) {
            return null;
        }
        DataRange axis = new DataRange(location);
        if (range.hasAttribute("id")) {
            axis.setId(range.getAttribute("id"));
        }
        if (range.hasAttribute("label")) {
            axis.setLabel(range.getAttribute("label"));
        }
        if (range.hasAttribute("type") && (t = range.getAttribute("type")) != null) {
            if (t.equals("continuum")) {
                axis.setType(0);
            } else if (t.equals("categorization")) {
                axis.setType(1);
            }
        }
        NodeList markers = range.getElementsByTagName("segmentMarker");
        int size = markers.getLength();
        TreeSet<SegmentMarker> sortedMarkers = new TreeSet<SegmentMarker>(new Comparator(){

            public int compare(Object o1, Object o2) {
                double d2;
                SegmentMarker sm1 = (SegmentMarker)o1;
                SegmentMarker sm2 = (SegmentMarker)o2;
                double d1 = sm1.getValue();
                return d1 == (d2 = sm2.getValue()) ? 0 : (d1 < d2 ? -1 : 1);
            }
        });
        int i = 0;
        while (i < size) {
            Element e = (Element)markers.item(i);
            SegmentMarker sm = new SegmentMarker(e.getAttribute("value"));
            if (e.hasAttribute("label")) {
                sm.setLabel(e.getAttribute("label"));
            }
            if (e.hasAttribute("type")) {
                String type = e.getAttribute("type");
                if (type.equals("tick")) {
                    sm.setType(0);
                } else if (type.equals("line")) {
                    sm.setType(1);
                }
            }
            sortedMarkers.add(sm);
            ++i;
        }
        SegmentMarker[] sm = new SegmentMarker[size];
        int i2 = 0;
        Iterator j = sortedMarkers.iterator();
        while (j.hasNext()) {
            sm[i2] = (SegmentMarker)j.next();
            ++i2;
        }
        axis.setSegmentMarkers(sm);
        return axis;
    }

    private DataPoint[] getDatapointsFromList(NodeList dataPoints) throws DataInputProcessingException {
        if (dataPoints == null) {
            return null;
        }
        int n = dataPoints.getLength();
        TreeSet<DataPoint> sortedDatapoints = new TreeSet<DataPoint>(new Comparator(){

            public int compare(Object o1, Object o2) {
                double d2;
                DataPoint dp1 = (DataPoint)o1;
                DataPoint dp2 = (DataPoint)o2;
                double d1 = dp1.getValue1();
                return d1 == (d2 = dp2.getValue1()) ? 0 : (d1 < d2 ? -1 : 1);
            }
        });
        int i = 0;
        while (i < n) {
            NodeList l;
            Element dpe = (Element)dataPoints.item(i);
            String value2String = dpe.getAttribute("value2");
            DataPoint dp = dpe.hasAttribute("value1") ? new DataPoint(dpe.getAttribute("value1"), value2String) : new DataPoint(value2String);
            if (dpe.hasAttribute("type")) {
                String type = dpe.getAttribute("type");
                if (type.equals("actual")) {
                    dp.setType(0);
                } else if (type.equals("hole")) {
                    dp.setType(1);
                }
            }
            if (dpe.hasAttribute("label")) {
                dp.setLabel(dpe.getAttribute("label"));
            }
            if ((l = dpe.getElementsByTagName("image")).getLength() > 0) {
                String s;
                Element image = (Element)l.item(0);
                if (image.hasAttribute("type")) {
                    dp.setImageType(image.getAttribute("type"));
                }
                if (image.hasAttribute("uri")) {
                    dp.setImageURI(image.getAttribute("uri"));
                }
                if (image.hasAttribute("code")) {
                    dp.setImageCode(image.getAttribute("code"));
                }
                if (image.hasAttribute("width")) {
                    s = image.getAttribute("width");
                    int w = Integer.parseInt(s);
                    if (w < 0) {
                        this.throwException((short)127, s);
                    } else {
                        dp.setImageWidth(w);
                    }
                }
                if (image.hasAttribute("height")) {
                    s = image.getAttribute("height");
                    int h = Integer.parseInt(s);
                    if (h < 0) {
                        this.throwException((short)128, s);
                    } else {
                        dp.setImageHeight(h);
                    }
                }
            }
            sortedDatapoints.add(dp);
            ++i;
        }
        DataPoint[] result = new DataPoint[n];
        int i2 = 0;
        Iterator j = sortedDatapoints.iterator();
        while (j.hasNext()) {
            result[i2] = (DataPoint)j.next();
            ++i2;
        }
        return result;
    }

    private DataSet getDataSet(Element ds, int position) throws DataInputProcessingException {
        DataSet dataset = new DataSet(position);
        if (ds.hasAttribute("label")) {
            dataset.setLabel(ds.getAttribute("label"));
        }
        if (ds.hasAttribute("flyoverLabel")) {
            dataset.setFlyoverLabel(ds.getAttribute("flyoverLabel"));
        }
        if (ds.hasAttribute("dataRange1Ref")) {
            dataset.setDataRange1Ref(ds.getAttribute("dataRange1Ref"));
        }
        if (ds.hasAttribute("dataRange2Ref")) {
            dataset.setDataRange2Ref(ds.getAttribute("dataRange2Ref"));
        }
        if (ds.hasAttribute("total")) {
            double total = Double.parseDouble(ds.getAttribute("total"));
            if (total >= 0.0) {
                dataset.setTotal(total);
            } else {
                throw new DataInputProcessingException(102, "total");
            }
        }
        dataset.setDataPoints(this.getDatapointsFromList(ds.getElementsByTagName("dataPoint")));
        return dataset;
    }

    public DataSet getDatasetWithPosition(Document dataDocument, String position) throws DataInputProcessingException {
        Element ds;
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        if ((ds = this.getElementWithAttribute(dataDocument, "dataSet", "position", position)) == null) {
            ds = this.getElementWithDocOrderOrdinal(dataDocument, "dataSet", position);
        }
        if (ds == null) {
            this.throwException((short)124, "dataSet");
        }
        return this.getDataSet(ds, Integer.parseInt(position));
    }

    public DataSet getFirstDataset(Document dataDocument) throws DataInputProcessingException {
        Element ds;
        if (dataDocument == null) {
            this.throwException((short)114, "");
        }
        if ((ds = this.getFirstElement(dataDocument, "dataSet")) == null) {
            this.throwException((short)124, "dataPoint");
        }
        return this.getDataSet(ds, 0);
    }

    protected void throwException(short code, String element) throws DataInputProcessingException {
        DataInputProcessingException e = new DataInputProcessingException(code, element);
        throw e;
    }
}

