/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.sample.svg.generator;

import java.io.Serializable;
import java.util.Date;
import org.eclipse.hyades.ui.sample.svg.generator.DataInputProcessingException;
import org.eclipse.hyades.ui.sample.svg.generator.DataPoint;
import org.eclipse.hyades.ui.sample.svg.generator.DataRange;
import org.eclipse.hyades.ui.sample.svg.generator.DataSet;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicAttributes;
import org.eclipse.hyades.ui.sample.svg.generator.GraphicDocumentProperties;
import org.eclipse.hyades.ui.sample.svg.generator.IDataInputProcessingExceptionCodes;
import org.eclipse.hyades.ui.sample.svg.generator.IGraphicDocumentStyle;
import org.eclipse.hyades.ui.sample.svg.generator.SVGXYChart;
import org.eclipse.hyades.ui.sample.svg.generator.SegmentMarker;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGStackBarChart
extends SVGXYChart
implements IGraphicDocumentStyle,
IDataInputProcessingExceptionCodes,
Serializable {
    public SVGStackBarChart() {
        this.graphicType = "stack";
    }

    public Document generateGraphicDocument(GraphicDocumentProperties input) throws DataInputProcessingException {
        double maxAlloableLegendWidth;
        double maxLengthOfLegendLableWidth;
        double maxAllowableYMarkerWidth;
        GraphicAttributes graphicAttrs = this.createGraphicAttributes(input);
        Document newDataDocument = graphicAttrs.getDataDocument();
        String rangeMaxValue = null;
        int numberOfDatasets = 0;
        int gridXOffset = 60;
        int halfGridXOffset = gridXOffset / 2;
        int gridYOffset = 50;
        try {
            this.xAxis = this.dataRetriever.getDataRange(newDataDocument, "S");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        try {
            this.yAxis = this.dataRetriever.getDataRange(newDataDocument, "W");
        }
        catch (DataInputProcessingException e) {
            e.setWidgetType(this.getGraphicType());
            throw e;
        }
        if (this.xAxis == null || this.yAxis == null) {
            throw new DataInputProcessingException("", 126, "dataRange", this.getGraphicType());
        }
        if (this.xAxis.getType() != 1 || this.yAxis.getType() != 0) {
            throw new DataInputProcessingException("", 129, "dataRange", this.getGraphicType());
        }
        this.xMarkers = this.xAxis.getSegmentMarkers();
        this.yMarkers = this.yAxis.getSegmentMarkers();
        if (this.yMarkers != null && this.yMarkers.length > 0) {
            rangeMaxValue = this.yMarkers[this.yMarkers.length - 1].getValueString();
        }
        numberOfDatasets = this.dataRetriever.getNumberOfDatasets(newDataDocument);
        this.dataSets = new DataSet[numberOfDatasets];
        int i = 0;
        while (i < numberOfDatasets) {
            this.dataSets[i] = this.dataRetriever.getDatasetWithPosition(newDataDocument, Integer.toString(i));
            ++i;
        }
        this.legendFlyOverLabels = this.getLegendFlyOverLabels(this.dataSets);
        double maxLengthOfYmarkerWidth = this.getMaxLengthOfYmarker(this.yMarkers, graphicAttrs);
        if (maxLengthOfYmarkerWidth > (maxAllowableYMarkerWidth = (double)(graphicAttrs.getGraphicWidth() / 4))) {
            maxLengthOfYmarkerWidth = maxAllowableYMarkerWidth;
        }
        if ((maxLengthOfLegendLableWidth = this.getMaxLengthOfLegendLabel(graphicAttrs, this.dataSets)) > (maxAlloableLegendWidth = (double)(graphicAttrs.getGraphicWidth() / 3))) {
            maxLengthOfLegendLableWidth = maxAlloableLegendWidth;
        }
        if (graphicAttrs.isLegendSuppressed()) {
            maxLengthOfLegendLableWidth = 0.0;
        }
        int xAxisLength = (int)((double)graphicAttrs.getGraphicWidth() - (maxLengthOfLegendLableWidth + maxLengthOfYmarkerWidth + (double)gridXOffset));
        int xLabelRowCount = this.getNumberOfAxisLabels(graphicAttrs, xAxisLength, this.xAxis);
        int yAxisLength = (int)((double)graphicAttrs.getGraphicHeight() - (double)gridYOffset * 2.5 - (double)(xLabelRowCount * 10));
        Document generatedDocument = this.createSvgDocument(newDataDocument.getImplementation(), Short.toString(graphicAttrs.getGraphicWidth()), Short.toString(graphicAttrs.getGraphicHeight()));
        Element svgRoot = generatedDocument.getDocumentElement();
        this.registerEventHandler(svgRoot, "onload", "init(evt)");
        this.addDefinitions(generatedDocument, graphicAttrs, numberOfDatasets);
        this.addJavaScriptFunctions(generatedDocument, graphicAttrs, numberOfDatasets, gridXOffset, gridYOffset, xAxisLength, yAxisLength);
        if (!graphicAttrs.isOutlineSuppressed()) {
            this.addOutline(generatedDocument, graphicAttrs);
        }
        if (!graphicAttrs.isTimestampSuppressed()) {
            try {
                String timestamp = this.dataRetriever.getTimestamp(newDataDocument);
                Date date = GraphicAttributes.parseISO8601Date(timestamp);
                this.addTimeStamp(generatedDocument, graphicAttrs, date == null ? timestamp : graphicAttrs.formatDate(date));
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        if (!graphicAttrs.isTitlebarSuppressed()) {
            this.addTitleBar(generatedDocument, graphicAttrs);
        } else {
            gridYOffset = super.resetGridOffsetForCenter(graphicAttrs.getGraphicHeight(), yAxisLength, 3.0);
        }
        if (!graphicAttrs.isUserPreferencesSuppressed() && graphicAttrs.getSvgFormatOnly()) {
            this.addPreferenceIcon(generatedDocument, graphicAttrs);
        }
        gridXOffset = halfGridXOffset + (int)maxLengthOfYmarkerWidth;
        this.evenlyDistributeSegmentMarkers(this.xAxis);
        this.addGrid(generatedDocument, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addAxisLabels(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis);
        this.addTitles(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, xLabelRowCount, rangeMaxValue);
        Element gTextBoxElement = generatedDocument.createElement("g");
        this.addDataSets(generatedDocument, graphicAttrs, svgRoot, xAxisLength, yAxisLength, gridXOffset, gridYOffset, this.xAxis, this.yAxis, this.dataSets);
        if (!graphicAttrs.isLegendSuppressed()) {
            try {
                String[] legendLabels = this.dataRetriever.getLegendLabels(newDataDocument);
                this.addLegend(generatedDocument, graphicAttrs, gTextBoxElement, legendLabels, this.legendFlyOverLabels, (int)maxLengthOfYmarkerWidth + xAxisLength + halfGridXOffset, gridYOffset);
            }
            catch (DataInputProcessingException e) {
                e.setWidgetType(this.graphicType);
                throw e;
            }
        }
        svgRoot.appendChild(gTextBoxElement);
        return generatedDocument;
    }

    private void addAllBarValues(Document generatedDocument, GraphicAttributes attrs, Element gValueElement, int xAxisLength, int yAxisLength, DataRange xAxis, DataRange yAxis, double barWidth, double[] accumulatedYValues) {
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        double yMax = yAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        int i = 0;
        while (i < xsms.length) {
            double yValue = accumulatedYValues[i];
            if (!(yValue < yMin) && !(yValue > yMax)) {
                double y = (double)yAxisLength * (yMax - yValue) / (yMax - yMin);
                double x = xsms[i].getPosition() * (double)xAxisLength;
                String label = attrs.formatNumber(yValue);
                double ypos = yValue >= 0.0 ? y - 5.0 : y + 12.0;
                this.addLabel(generatedDocument, attrs, gValueElement, label, "dataValues, anchorAtMiddle", x, ypos, 0);
            }
            ++i;
        }
    }

    private void addBarSet(Document generatedDocument, GraphicAttributes attrs, Element oneBarSetElement, Element gToggleElement, int barsetNumber, double xAxisLength, int yAxisLength, DataRange xAxis, DataRange yAxis, double barWidth, double[] accumulatedYValues, DataSet dataSet) throws DataInputProcessingException {
        SegmentMarker[] xsms = xAxis.getSegmentMarkers();
        double yMax = yAxis.getMaxValue();
        double yMin = yAxis.getMinValue();
        int boxcount = 0;
        int i = 0;
        while (i < xsms.length) {
            DataPoint dp = dataSet.findDataPoint(xsms[i].getValue());
            if (dp != null && dp.getType() != 1) {
                double height;
                double dataValue = dp.getValue2();
                double yValue = dataValue + accumulatedYValues[i];
                double lastYValue = accumulatedYValues[i];
                accumulatedYValues[i] = yValue;
                if (lastYValue < yMin) {
                    lastYValue = yMin;
                }
                if (lastYValue > yMax) {
                    lastYValue = yMax;
                }
                if (yValue < yMin) {
                    yValue = yMin;
                }
                if (yValue > yMax) {
                    yValue = yMax;
                }
                double y = (double)yAxisLength * (yMax - yValue) / (yMax - yMin);
                double y0 = (double)yAxisLength * (yMax - lastYValue) / (yMax - yMin);
                double x = xsms[i].getPosition() * xAxisLength - barWidth / 2.0;
                double upperY = y < y0 ? y : y0;
                double d = height = y < y0 ? y0 - y : y - y0;
                if (!(height <= 0.0)) {
                    Element newElement = generatedDocument.createElement("rect");
                    newElement.setAttribute("x", Double.toString(x));
                    newElement.setAttribute("y", Double.toString(upperY));
                    newElement.setAttribute("width", Double.toString(barWidth));
                    newElement.setAttribute("height", Double.toString(height));
                    oneBarSetElement.appendChild(newElement);
                    String label = dp.getDisplayLabel(attrs);
                    double boxXPos = x + barWidth + 2.0;
                    double boxYPos = upperY;
                    double boxWidth = 16.0 + (double)(label.length() - 1) * 6.0;
                    double boxHeight = 18.0;
                    this.addEachTextBox(generatedDocument, attrs, gToggleElement, boxXPos, boxYPos, boxWidth, boxHeight, label, barsetNumber, boxcount++);
                }
            }
            ++i;
        }
    }

    private void addDataSets(Document generatedDocument, GraphicAttributes attrs, Element parent, int xAxisLength, int yAxisLength, int gridXOffset, int gridYOffset, DataRange xAxis, DataRange yAxis, DataSet[] dataSets) throws DataInputProcessingException {
        int numberOfSegments = xAxis.getSegmentMarkers().length;
        double barWidth = numberOfSegments > 0 ? (double)(xAxisLength / numberOfSegments / 2) : 0.0;
        double[] accumulatedYValues = new double[numberOfSegments];
        int i = 0;
        while (i < numberOfSegments) {
            accumulatedYValues[i] = 0.0;
            ++i;
        }
        Element gValueElement = generatedDocument.createElement("g");
        String stylesheetClass = "dataValues anchorAtMiddle";
        gValueElement.setAttribute("id", "exactValues");
        gValueElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
        gValueElement.setAttribute("visibility", "hidden");
        gValueElement.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
        parent.appendChild(gValueElement);
        int i2 = 0;
        while (i2 < dataSets.length) {
            Element oneBarSetElement = generatedDocument.createElement("g");
            oneBarSetElement.setAttribute("id", "dataColour" + i2);
            oneBarSetElement.setAttribute("class", "shape" + i2);
            oneBarSetElement.setAttribute("transform", "translate(" + gridXOffset + "," + gridYOffset + ")");
            oneBarSetElement.setAttribute("onclick", "toggleVisibility(\"exactValues\")");
            parent.appendChild(oneBarSetElement);
            Element gToggleElement = generatedDocument.createElement("g");
            String boxStylesheetClass = "dataValues anchorAtMiddle";
            gToggleElement.setAttribute("id", "textbox" + i2);
            gValueElement.appendChild(gToggleElement);
            this.addBarSet(generatedDocument, attrs, oneBarSetElement, gToggleElement, i2, xAxisLength, yAxisLength, xAxis, yAxis, barWidth, accumulatedYValues, dataSets[i2]);
            ++i2;
        }
        this.addAllBarValues(generatedDocument, attrs, gValueElement, xAxisLength, yAxisLength, xAxis, yAxis, barWidth, accumulatedYValues);
    }

    private void addDefaultInternalStylesheet(Document generatedDocument, GraphicAttributes attrs, Element parent, int sets) {
        StringBuffer styleRules = new StringBuffer(" .st1{fill-rule:nonzero;clip-rule:nonzero;stroke:#000000;stroke-miterlimit:4;} .outline{stroke-width:0.75pt; stroke:#666666; fill:#ffffff;} .keyline{stroke-width:0.75pt; stroke:#666666;} .graphTitle {font-weight:bold; font-style:normal; font-size:11pt; fill:#000000; stroke-width:0.75pt;} .labelsValues {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000;} .dataValues {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000;} .timeStamp {font-weight:normal; font-style:normal; font-size:8pt; fill:#000000; text-anchor:end; opacity:0.5} .legendTitle {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; text-anchor:start; opacity:0.6} .legendData {font-weight:normal; font-style:normal; font-size:9pt; text-anchor:start; fill:#000000;} .anchorAtEnd {text-anchor: end;} .anchorAtStart {text-anchor: start;} .anchorAtMiddle {text-anchor: middle;}");
        styleRules.append(" .grid{stroke-width:0.75pt; stroke:#000000;} .gridline{stroke-width:0.75pt; stroke:#cccccc;} .griddashline{stroke-width:0.75pt; stroke:#cccccc; stroke-dasharray:2; fill:none;} .axisLines{fill:none;} .axisTicks{fill:none;} .solidLine{fill:none;stroke:#CCCCCC;stroke-width:1;} .dashLine{fill:none;stroke:#CCCCCC;stroke-width:1;stroke-dasharray:2;} .catOutline{fill:none;} .catColor{fill:#003399;stroke:none;} .exactValuesBox{fill:#FFFFCC;stroke:#999999;stroke-width:1;} .xyTitleLabels {font-weight:normal; font-style:normal; font-size:10pt; fill:#000000; opacity:0.6}");
        String[] palette = (String[])attrs.getGraphicColorPalette().get(attrs.getGraphicColorPaletteName());
        int paletteLength = palette.length;
        boolean hasLegend = !attrs.isLegendSuppressed();
        int i = 0;
        int j = 0;
        while (i < sets) {
            j = (i + 1) % paletteLength;
            j = j == 0 ? paletteLength - 1 : j - 1;
            styleRules.append(" .dataset" + i + "{stroke-width:0.75pt; stroke:" + palette[j] + ";}");
            if (hasLegend) {
                styleRules.append(" .shape" + i + "{stroke:none; fill:" + palette[j] + ";}");
            }
            ++i;
        }
        CDATASection newCDATASection = generatedDocument.createCDATASection(styleRules.toString());
        Element newElement = generatedDocument.createElement("style");
        newElement.setAttribute("id", "defaultStyleRules");
        newElement.setAttribute("type", "text/css");
        newElement.appendChild(newCDATASection);
        parent.appendChild(newElement);
    }

    protected void addDefinitions(Document generatedDocument, GraphicAttributes attrs, int numberOfDatasets) {
        Element defsElement = super.addDefinitions(generatedDocument, attrs);
        this.addDefaultInternalStylesheet(generatedDocument, attrs, defsElement, numberOfDatasets);
    }

    private void addExactValue(Document generatedDocument, GraphicAttributes attrs, Element parent, double x, double y, String value) {
        this.addLabel(generatedDocument, attrs, parent, value, "dataValues, anchorAtMiddle", x, y, 0);
    }

    private GraphicAttributes createGraphicAttributes(GraphicDocumentProperties input) throws DataInputProcessingException {
        GraphicAttributes graphicAttrs = new GraphicAttributes();
        graphicAttrs.setGraphicWidth("450");
        graphicAttrs.setPreferencesPage("prefs_stackedbar.htm");
        graphicAttrs.setPreferencesPageWidth("430");
        graphicAttrs.setPreferencesPageHeight("435");
        graphicAttrs.setConfigDocument(input.getConfigDocument());
        graphicAttrs.setDataDocument(input.getDataDocument());
        this.getConfigAttributes(graphicAttrs);
        graphicAttrs.setAttributesFrom(input);
        return graphicAttrs;
    }
}

