/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.editor.extension;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.DefaultTestContextOverviewContribution;
import org.eclipse.hyades.test.ui.editor.form.TestCasesForm;
import org.eclipse.hyades.test.ui.editor.form.TestContextOverview;
import org.eclipse.hyades.test.ui.editor.form.base.IHasEStructuralFeature;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TestSuiteEditorExtension
extends BaseEditorExtension {
    public static final String EXTENSION_ID = "org.eclipse.hyades.test.ui.editor.extension.TestSuite";
    private WidgetFactory widgetFactory = new WidgetFactory();
    private EditorForm[] forms = new EditorForm[]{new TestContextOverview(this, this.widgetFactory, new DefaultTestContextOverviewContribution()), new TestCasesForm(this, this.widgetFactory)};

    public void dispose() {
        int i = 0;
        while (this.forms != null && i < this.forms.length) {
            if (this.forms[i] != null) {
                this.forms[i].dispose();
                this.forms[i] = null;
            }
            ++i;
        }
        super.dispose();
    }

    public TPFTestSuite getTestSuite() {
        return (TPFTestSuite)this.getHyadesEditorPart().getEditorObject();
    }

    public final void createPages() {
        IHyadesEditorPart hyadesEditorPart = this.getHyadesEditorPart();
        int i = 0;
        while (this.forms != null && i < this.forms.length) {
            hyadesEditorPart.addPage(this.forms[i].createControl());
            hyadesEditorPart.setPageText(i, this.forms[i].getHeadingText());
            ++i;
        }
    }

    public void refreshContent(Object data) {
        int i = 0;
        while (this.forms != null && i < this.forms.length) {
            if (this.forms[i] != null) {
                this.forms[i].load();
            }
            ++i;
        }
    }

    public IStructuredSelection getSelection() {
        StructuredSelection selection = null;
        int index = this.getHyadesEditorPart().getActivePage();
        if (index > -1 && this.forms != null && index < this.forms.length) {
            selection = (IStructuredSelection)this.forms[index].getCurrentSelection();
        }
        if (selection == null) {
            selection = StructuredSelection.EMPTY;
        }
        return selection;
    }

    public boolean pageActivated(int index) {
        if (index > -1 && this.forms != null && index < this.forms.length) {
            return this.forms[index].activated();
        }
        return false;
    }

    public void setSelection(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            Object object = structuredSelection.getFirstElement();
            if (object == this.getTestSuite()) {
                // empty if block
            }
            boolean notFound = true;
            int i = 0;
            while (notFound && this.forms != null && i < this.forms.length) {
                Class cl;
                if (this.forms[i] instanceof IHasEStructuralFeature && (cl = ((IHasEStructuralFeature)((Object)this.forms[i])).getStructuralFeature().getEType().getInstanceClass()).isAssignableFrom(object.getClass())) {
                    notFound = false;
                    this.forms[i].selectReveal((ISelection)structuredSelection);
                    this.getHyadesEditorPart().setActivePage(i);
                }
                ++i;
            }
        }
    }

    public EditorForm[] getForms() {
        return this.forms;
    }

    public WidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    public void setForms(EditorForm[] forms) {
        this.forms = forms;
    }
}

