/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.action;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTableSection;
import org.eclipse.hyades.test.ui.internal.action.AddTestSuiteChildAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class AddDatapoolAction
extends AddTestSuiteChildAction {
    private TPFTestSuite testSuite;
    private ExtensibleEObjectTableSection table;

    public AddDatapoolAction() {
        super(TestUIPlugin.getString("label.Add"));
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (selection == null) {
            return false;
        }
        TPFTestSuite tmp = this.getTestSuite(selection);
        if (tmp != null) {
            this.testSuite = tmp;
        }
        return this.testSuite != null;
    }

    public void run() {
        if (this.testSuite == null) {
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        FileDialog fd = new FileDialog(shell);
        fd.setFilterExtensions(new String[]{"*.datapool", "*.*"});
        fd.open();
        Path datapoolPath = new Path(fd.getFilterPath() + '/' + fd.getFileName());
        File file = datapoolPath.toFile();
        if (file == null || !file.exists()) {
            return;
        }
        Common_DatapoolFactoryImpl factory = new Common_DatapoolFactoryImpl();
        DPLDatapool dataPool = (DPLDatapool)factory.loadForEdit(file, false);
        if (this.testSuite.getDatapools() == null) {
            return;
        }
        if (!this.testSuite.getDatapools().contains((Object)dataPool)) {
            this.testSuite.getDatapools().add((Object)dataPool);
        }
        this.table.initialize(this.testSuite);
    }

    public void setTable(ExtensibleEObjectTableSection table) {
        this.table = table;
    }
}

