/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.TestUIPlugin;

public class EMFUtil {
    public static final Map RESOURCE_OPTIONS = new HashMap();
    private static ResourceSet resourceSet = new ResourceSetImpl();
    private static Resource resourceBeingSaved;

    public EMFUtil() {
        RESOURCE_OPTIONS.put("DECLARE_XML", Boolean.TRUE);
        RESOURCE_OPTIONS.put("SKIP_ESCAPE", Boolean.FALSE);
    }

    public static void save(Resource resource) throws Exception {
        if (resource == null) {
            throw new IllegalArgumentException(TestUIPlugin.getString("_ERROR_ARG_NULL", "resource"));
        }
        boolean isModified = resource.isModified();
        try {
            try {
                resourceBeingSaved = resource;
                resource.save(RESOURCE_OPTIONS);
            }
            catch (Exception e) {
                resource.setModified(isModified);
                throw e;
            }
            Object var4_2 = null;
            resourceBeingSaved = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            resourceBeingSaved = null;
            throw throwable;
        }
    }

    public static void unloadIfNeeded(URI uri) {
        Resource resource = EMFUtil.getResourceSet().getResource(uri, false);
        if (resource != null && resourceBeingSaved == null) {
            resource.unload();
        }
    }

    public static EObject getEObject(ResourceSet rs, EObject eObject, boolean load) {
        ResourceSet localRS = rs;
        if (localRS == null) {
            localRS = resourceSet;
        }
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        if (localRS.equals(resource.getResourceSet())) {
            return eObject;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if ((resource = localRS.getResource(resource.getURI(), load)) == null) {
            return null;
        }
        eObject = resource.getEObject(uriFragment);
        if (eObject == null) {
            return null;
        }
        return eObject;
    }

    public static EObject[] getEObjects(ResourceSet rs, IFile file) {
        if (file == null) {
            return new EObject[0];
        }
        return EMFUtil.getEObjects(rs, file.getFullPath().toString());
    }

    public static EObject[] getEObjects(ResourceSet rs, String fullPath) {
        Resource resource;
        if (fullPath == null) {
            return new EObject[0];
        }
        ResourceSet localRS = rs;
        if (localRS == null) {
            localRS = resourceSet;
        }
        if ((resource = localRS.getResource(URI.createPlatformResourceURI((String)fullPath), false)) == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static EObject[] getEObjects(URI fileURI, boolean load) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource res = rs.getResource(fileURI, load);
        EList list = res.getContents();
        EObject[] eObjects = new EObject[list.size()];
        int i = 0;
        while (i < list.size()) {
            eObjects[i] = (EObject)list.get(i);
            ++i;
        }
        return eObjects;
    }

    public static EObject[] load(ResourceSet rs, IFile file) {
        if (file == null) {
            return new EObject[0];
        }
        return EMFUtil.load(rs, file.getFullPath().toString());
    }

    public static EObject[] load(ResourceSet rs, String fullPath) {
        if (fullPath == null) {
            return new EObject[0];
        }
        URI uri = URI.createPlatformResourceURI((String)fullPath);
        return EMFUtil.load(rs, uri);
    }

    public static EObject[] load(ResourceSet rs, URI uri) {
        if (uri == null) {
            return new EObject[0];
        }
        Resource resource = null;
        try {
            resource = rs != null ? rs.getResource(uri, true) : resourceSet.getResource(uri, true);
        }
        catch (Exception e) {
            TestUIPlugin.logError(e);
        }
        if (resource == null) {
            return new EObject[0];
        }
        return (EObject[])resource.getContents().toArray((Object[])new EObject[resource.getContents().size()]);
    }

    public static Resource.Factory getResourceFactory(String fileExtension) {
        Resource.Factory factory;
        if (fileExtension != null && (factory = (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(fileExtension)) != null) {
            return factory;
        }
        return (Resource.Factory)Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get("*");
    }

    public static IFile getWorkspaceFile(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        return EMFUtil.getWorkspaceFile(eObject.eResource());
    }

    public static IFile getWorkspaceFile(Resource resource) {
        String filePath = EMFUtil.getWorkspaceFilePath(resource);
        if (filePath == null) {
            return null;
        }
        IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember(filePath);
        if (workspaceResource == null || workspaceResource.getType() != 1) {
            return null;
        }
        return (IFile)workspaceResource;
    }

    public static String getWorkspaceFilePath(Resource resource) {
        if (resource == null) {
            return null;
        }
        String uriToString = resource.getURI().toString();
        if (!uriToString.startsWith("platform:/resource")) {
            return null;
        }
        return uriToString.substring("platform:/resource".length());
    }

    public static Resource getResource(ResourceSet rs, IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString());
        return EMFUtil.getResource(rs, uri, false);
    }

    public static Resource getResource(ResourceSet rs, URI uri, boolean load) {
        ResourceSet localRS = rs;
        if (localRS == null) {
            localRS = resourceSet;
        }
        return localRS.getResource(uri, load);
    }

    public static EObject reload(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return eObject;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if (resource.isLoaded()) {
            resource.unload();
        }
        try {
            resource.load(RESOURCE_OPTIONS);
        }
        catch (IOException e) {
            TestUIPlugin.logError(e);
            return null;
        }
        return resource.getEObject(uriFragment);
    }

    public static Resource[] remove(EObject eObject) {
        if (eObject == null) {
            return new Resource[0];
        }
        if (eObject.eResource() == null) {
            EcoreUtil.remove((EObject)eObject);
            return new Resource[0];
        }
        Resource resource = eObject.eResource();
        Set changedResources = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((EObject)eObject, (ResourceSet)resource.getResourceSet());
        changedResources.add(resource);
        if (eObject.eContainer() != null) {
            EcoreUtil.remove((EObject)eObject);
        }
        return changedResources.toArray(new Resource[changedResources.size()]);
    }

    public static Resource[] remove(Resource resource) {
        if (resource == null) {
            return new Resource[0];
        }
        Set changedResources = org.eclipse.hyades.models.hierarchy.util.EMFUtil.delete((Resource)resource);
        return changedResources.toArray(new Resource[changedResources.size()]);
    }

    public static void addAdapter(Iterator objectIterator, Adapter adapter) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().add((Object)adapter);
        }
    }

    public static void removeAdapter(Iterator objectIterator, Adapter adapter) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().remove((Object)adapter);
        }
    }

    public static void removeAdapters(Iterator objectIterator) {
        while (objectIterator.hasNext()) {
            Object object = objectIterator.next();
            if (!(object instanceof Notifier)) continue;
            ((Notifier)object).eAdapters().clear();
        }
    }

    public static ResourceSet getResourceSet() {
        return resourceSet;
    }

    public static Resource getResource(ResourceSet rs, EObject object) {
        ResourceSet localRS = rs;
        if (localRS == null) {
            localRS = resourceSet;
        }
        EList resources = localRS.getResources();
        Iterator it1 = resources.iterator();
        while (it1.hasNext()) {
            Resource res = (Resource)it1.next();
            EList resContent = res.getContents();
            Iterator it2 = resContent.iterator();
            while (it2.hasNext()) {
                if (!object.equals(it2.next())) continue;
                return res;
            }
        }
        return null;
    }

    public static EObject getEObjectInResourceSet(EObject object, ResourceSet rs) {
        URI uri = object.eResource().getURI();
        String uriFragment = object.eResource().getURIFragment(object);
        Resource res = rs.getResource(uri, true);
        EObject obj = res.getEObject(uriFragment);
        return obj;
    }
}

