/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ArtifactSelectionPage
extends WizardPage
implements SelectionListener,
ICheckStateListener {
    private Button filterButton;
    private CheckboxTreeViewer assetViewer;
    private EObjectResourceContentProvider contentProvider;
    private String[] fileExtensions = this.getSupportedFileExtensions();
    private Image fileImage;
    private EObject[] selectedEObjects;
    private EObject[] checkedEObjects;
    private Vector checkedObjects;

    protected ArtifactSelectionPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gridData = GridDataUtil.createFill();
        composite.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite);
        this.assetViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.assetViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.assetViewer.expandToLevel(2);
        this.setControl((Control)composite);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection selection = this.assetViewer.getSelection();
            this.assetViewer.refresh();
            if (!selection.isEmpty()) {
                this.assetViewer.setSelection(selection, true);
            }
        }
        if (e.widget == this.assetViewer.getControl()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        ISelection selection = this.assetViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            Iterator it = ((IStructuredSelection)selection).iterator();
            Vector<EObject> objects = new Vector<EObject>();
            while (it.hasNext()) {
                Object element = it.next();
                if (!(element instanceof EObject)) continue;
                objects.add((EObject)element);
            }
            this.selectedEObjects = new EObject[objects.size()];
            int i = 0;
            while (i < objects.size()) {
                this.selectedEObjects[i] = (EObject)objects.get(i);
                ++i;
            }
        }
    }

    public EObject[] getSelectedObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }

    public IFile[] getSelectedFiles() {
        if (this.selectedEObjects == null) {
            return new IFile[0];
        }
        IFile[] selectedFiles = new IFile[this.selectedEObjects.length];
        int i = 0;
        while (i < this.selectedEObjects.length) {
            selectedFiles[i] = EMFUtil.getWorkspaceFile(this.selectedEObjects[i]);
            ++i;
        }
        return selectedFiles;
    }

    public EObject[] getCheckedObjects() {
        if (this.checkedEObjects == null) {
            this.checkedEObjects = new EObject[0];
        }
        return this.checkedEObjects;
    }

    public IFile[] getCheckedFiles() {
        if (this.checkedEObjects == null) {
            return new IFile[0];
        }
        IFile[] checkedFiles = new IFile[this.checkedEObjects.length];
        int i = 0;
        while (i < this.checkedEObjects.length) {
            checkedFiles[i] = EMFUtil.getWorkspaceFile(this.checkedEObjects[i]);
            ++i;
        }
        return checkedFiles;
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67618);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.assetViewer = new CheckboxTreeViewer(tree);
        this.assetViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.assetViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.assetViewer.addCheckStateListener((ICheckStateListener)this);
        this.contentProvider.setFilter(2);
        ViewerSorter sorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.assetViewer.setSorter(sorter);
        return this.assetViewer;
    }

    private String[] getSupportedFileExtensions() {
        return new String[]{"testsuite", "testcomponent", "sut", "datapool"};
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (this.checkedObjects == null) {
            this.checkedObjects = new Vector();
        }
        Object element = event.getElement();
        if (event.getChecked()) {
            if (this.checkedObjects.contains(element)) {
                return;
            }
            this.checkedObjects.add(element);
        } else if (this.checkedObjects.contains(element)) {
            this.checkedObjects.remove(element);
        } else {
            return;
        }
        EObject[] modifiedList = new EObject[this.checkedObjects.size()];
        int i = 0;
        while (i < this.checkedObjects.size()) {
            modifiedList[i] = (EObject)this.checkedObjects.get(i);
            ++i;
        }
        this.checkedEObjects = modifiedList;
    }
}

