/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.edit.datapool.IDatapool;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.datapool.internal.util.GridDataUtil;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceContentProvider;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class DatapoolExportSelectionPage
extends WizardPage
implements SelectionListener {
    IDatapool datapool = null;
    private TreeViewer assetViewer;
    Button filterButton = null;
    private EObjectResourceContentProvider contentProvider;
    private String[] fileExtensions = this.getSupportedFileExtensions();
    private Image fileImage;

    protected DatapoolExportSelectionPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData gridData = GridDataUtil.createFill();
        composite.setLayoutData((Object)gridData);
        this.filterButton = new Button(composite, 32);
        this.filterButton.setText(TestUIPlugin.getString("SHOW_FOLDERS"));
        this.filterButton.addSelectionListener((SelectionListener)this);
        this.createViewer(composite);
        this.assetViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        ((Tree)this.assetViewer.getControl()).addSelectionListener((SelectionListener)this);
        this.assetViewer.expandToLevel(2);
        this.setControl((Control)composite);
    }

    public IDatapool getDatapool() {
        return this.datapool;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.filterButton) {
            this.contentProvider.setFilter(this.filterButton.getSelection() ? 4 : 2);
            ISelection selection = this.assetViewer.getSelection();
            this.assetViewer.refresh();
            if (!selection.isEmpty()) {
                this.assetViewer.setSelection(selection, true);
            }
        }
        if (e.widget == this.assetViewer.getControl()) {
            this.setSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        this.contentProvider = new EObjectResourceContentProvider(this.fileExtensions);
        this.assetViewer = new TreeViewer(tree);
        this.assetViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.assetViewer.setLabelProvider((IBaseLabelProvider)new EObjectResourceLabelProvider(true, this.fileImage));
        this.contentProvider.setFilter(2);
        ViewerSorter sorter = new ViewerSorter(){

            public void sort(Viewer viewer, Object[] elements) {
                if (elements.length > 0) {
                    super.sort(viewer, elements);
                }
            }

            public int category(Object element) {
                if (element instanceof IResource) {
                    return 0;
                }
                return 10;
            }
        };
        this.assetViewer.setSorter(sorter);
        return this.assetViewer;
    }

    private void setSelection() {
        Object selectedObject;
        ISelection selection = this.assetViewer.getSelection();
        if (selection != null && !selection.isEmpty() && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof IDatapool) {
            this.datapool = (IDatapool)selectedObject;
            if (this.datapool != null) {
                this.setPageComplete(true);
                this.getContainer().updateButtons();
            }
        }
    }

    private String[] getSupportedFileExtensions() {
        return new String[]{"datapool"};
    }
}

