/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.action.AddArtifactAction;
import org.eclipse.hyades.test.ui.internal.action.AddDeploymentChildAction;
import org.eclipse.hyades.test.ui.internal.action.AddLocationAction;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DeploymentObjectPage
extends WizardPage
implements SelectionListener,
ISelectionChangedListener {
    private String pageName;
    protected TreeViewer objectViewer;
    private TPFDeployment deployment;
    private Object input;
    private Object type;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    protected DeploymentObjectPage(String pageName, TPFDeployment deployment, Object type) {
        super(pageName);
        this.pageName = pageName;
        this.deployment = deployment;
        this.type = type;
        if (type instanceof CFGLocation) {
            this.input = deployment.getRefLocations();
        }
        if (type instanceof CFGArtifact) {
            this.input = deployment.getArtifacts();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.createViewer(composite);
        Composite buttonComposite = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data = new GridData(1040);
        buttonComposite.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComposite.setLayout((Layout)layout);
        this.createButtons(buttonComposite);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.upButton.addSelectionListener((SelectionListener)this);
        this.downButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)composite);
    }

    protected StructuredViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 67588);
        GridData gridData = GridDataUtil.createFill();
        gridData.heightHint = 150;
        tree.setLayoutData((Object)gridData);
        ObjectContentProvider contentProvider = new ObjectContentProvider();
        this.objectViewer = new TreeViewer(tree);
        this.objectViewer.setContentProvider((IContentProvider)contentProvider);
        this.objectViewer.setLabelProvider((IBaseLabelProvider)new ObjectLabelProvider(true));
        this.objectViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.objectViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = DeploymentObjectPage.this.pageName;
            }
        });
        if (this.deployment != null) {
            this.objectViewer.setInput(this.input);
        }
        return this.objectViewer;
    }

    private void createButtons(Composite parent) {
        this.addButton = new Button(parent, 8);
        this.addButton.setText(TestUIPlugin.getString("label.Add"));
        GridData data = GridDataUtil.createHorizontalFill();
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(true);
        this.removeButton = new Button(parent, 8);
        this.removeButton.setText(TestUIPlugin.getString("label.Remove"));
        data = GridDataUtil.createHorizontalFill();
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.upButton = new Button(parent, 8);
        this.upButton.setText(TestUIPlugin.getString("LBL_UP"));
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.upButton.setLayoutData((Object)data);
        this.upButton.setEnabled(false);
        this.downButton = new Button(parent, 8);
        this.downButton.setText(TestUIPlugin.getString("LBL_DOWN"));
        data = GridDataUtil.createHorizontalFill();
        data.verticalAlignment = 8;
        this.downButton.setLayoutData((Object)data);
        this.downButton.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        ISelection selection = this.objectViewer.getSelection();
        Object sel = null;
        if (selection != null && !selection.isEmpty()) {
            sel = ((IStructuredSelection)selection).getFirstElement();
        }
        if (event.widget == this.addButton) {
            AddDeploymentChildAction addAction;
            if (this.type instanceof CFGArtifact) {
                addAction = new AddArtifactAction();
                addAction.setDeployment(this.deployment);
                ((AddArtifactAction)addAction).run();
            }
            if (this.type instanceof CFGLocation) {
                addAction = new AddLocationAction();
                addAction.setDeployment(this.deployment);
                ((AddLocationAction)addAction).run();
            }
            this.objectViewer.refresh();
        } else if (event.widget == this.removeButton) {
            if (sel != null && sel instanceof CFGArtifact) {
                this.deployment.getArtifacts().remove((Object)((CFGArtifact)sel));
            }
            if (sel != null && sel instanceof CFGLocation) {
                this.deployment.getRefLocations().remove((Object)((CFGLocation)sel));
            }
            this.objectViewer.refresh();
        } else if (event.widget == this.upButton) {
            int index = -1;
            if (sel != null && sel instanceof CFGArtifact) {
                index = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)sel));
                this.deployment.getArtifacts().move(index, index - 1);
            }
            if (sel != null && sel instanceof CFGLocation) {
                index = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)sel));
                this.deployment.getRefLocations().move(index, index - 1);
            }
            this.objectViewer.refresh();
            if (index - 1 == 0) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(true);
            }
        } else if (event.widget == this.downButton) {
            int index = -1;
            int maxIndex = -1;
            if (sel != null && sel instanceof CFGArtifact) {
                index = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)sel));
                maxIndex = this.deployment.getArtifacts().size() - 1;
                this.deployment.getArtifacts().move(index, index + 1);
            }
            if (sel != null && sel instanceof CFGLocation) {
                index = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)sel));
                maxIndex = this.deployment.getRefLocations().size() - 1;
                this.deployment.getRefLocations().move(index, index + 1);
            }
            this.objectViewer.refresh();
            if (index + 1 == maxIndex) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(false);
            }
        }
    }

    public void setDeployment(TPFDeployment deployment) {
        this.deployment = deployment;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        boolean enable = !this.objectViewer.getSelection().isEmpty();
        boolean enableUp = false;
        boolean enableDown = false;
        ISelection selection = this.objectViewer.getSelection();
        Object sel = null;
        if (selection != null && !selection.isEmpty()) {
            sel = ((IStructuredSelection)selection).getFirstElement();
            int index = -1;
            int maxIndex = -1;
            if (sel != null && sel instanceof CFGArtifact) {
                maxIndex = this.deployment.getArtifacts().size() - 1;
                index = this.deployment.getArtifacts().indexOf((Object)((CFGArtifact)sel));
            }
            if (sel != null && sel instanceof CFGLocation) {
                maxIndex = this.deployment.getArtifacts().size() - 1;
                index = this.deployment.getRefLocations().indexOf((Object)((CFGLocation)sel));
            }
            if (index != 0) {
                enableUp = true;
            }
            if (index != maxIndex) {
                enableDown = true;
            }
        }
        this.removeButton.setEnabled(enable);
        this.upButton.setEnabled(enable && enableUp);
        this.downButton.setEnabled(enable && enableDown);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ObjectLabelProvider
    extends LabelProvider {
        private boolean useImages;

        public ObjectLabelProvider(boolean useImages) {
            this.useImages = useImages;
        }

        public Image getImage(Object element) {
            IWorkbenchAdapter adapter;
            if (!this.useImages || element == null) {
                return null;
            }
            if (element instanceof CFGArtifact) {
                return TestUIImages.INSTANCE.getImage("artifact_obj.gif");
            }
            if (element instanceof CFGLocation) {
                return TestUIImages.INSTANCE.getImage("location_obj.gif");
            }
            if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentObjectPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                return adapter.getImageDescriptor(element).createImage();
            }
            return null;
        }

        public String getText(Object element) {
            IWorkbenchAdapter adapter;
            if (element == null) {
                return "";
            }
            String text = null;
            if (element instanceof CFGArtifact) {
                text = ((CFGArtifact)element).getName();
            } else if (element instanceof CFGLocation) {
                text = ((CFGLocation)element).getName();
            } else if (element instanceof IAdaptable && (adapter = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = DeploymentObjectPage.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) != null) {
                text = adapter.getLabel(element);
            }
            if (text == null) {
                text = element.toString();
            }
            return text;
        }

        public void dispose() {
            super.dispose();
        }
    }

    private class ObjectContentProvider
    implements ITreeContentProvider {
        private ArrayList list = new ArrayList();

        public void dispose() {
            this.list.clear();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = new Object[]{};
            if (inputElement == null) {
                return elements;
            }
            if (inputElement instanceof EList) {
                int listSize = ((EList)inputElement).size();
                elements = new Object[listSize];
                int i = 0;
                while (i < listSize) {
                    elements[i] = ((EList)inputElement).get(i);
                    ++i;
                }
            }
            return elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

