/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.internal.wizard.selection;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.dialog.EObjectResourceSelectionDialog;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;

public class WizardResourceSelectionPage
extends WizardSelectionPage
implements SelectionListener,
ModifyListener {
    private IWorkbench workbench;
    private IStructuredSelection structuredSelection;
    private IWizardNode newFileWizardNode;
    private String fileExtension;
    private Image fileImage;
    private Button useExistButton;
    private Button createNewButton;
    private Button browseButton;
    private Text existFileText;
    private boolean isValid;
    private EObject[] selectedEObjects;

    public WizardResourceSelectionPage(String pageName, IWorkbench workbench, IStructuredSelection structuredSelection, String fileExtension, Image fileImage, IWizardNode newFileWizardNode) {
        super(pageName);
        this.workbench = workbench;
        this.structuredSelection = structuredSelection;
        this.fileExtension = fileExtension;
        this.fileImage = fileImage;
        this.newFileWizardNode = newFileWizardNode;
        this.isValid = false;
        this.setTitle(TestUIPlugin.getString("DLG_RESOURCE_SEL"));
        this.setMessage(TestUIPlugin.getString("DLG_RESOURCE_DSC"));
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 32);
        group.setLayout((Layout)new GridLayout(1, false));
        this.useExistButton = new Button((Composite)group, 16);
        this.useExistButton.setText(TestUIPlugin.getString("DLG_RESOURCE_USE_EXST"));
        this.useExistButton.setSelection(true);
        this.useExistButton.addSelectionListener((SelectionListener)this);
        Composite browseContainer = new Composite((Composite)group, 0);
        browseContainer.setLayoutData((Object)new GridData(768));
        GridLayout browseLayout = new GridLayout();
        browseLayout.numColumns = 3;
        browseContainer.setLayout((Layout)browseLayout);
        Label label = new Label(browseContainer, 0);
        label.setText(TestUIPlugin.getString("DLG_RESOURCE_EXST"));
        this.existFileText = new Text(browseContainer, 2048);
        this.existFileText.setLayoutData((Object)new GridData(768));
        this.existFileText.addModifyListener((ModifyListener)this);
        this.browseButton = new Button(browseContainer, 8);
        this.browseButton.setText(TestUIPlugin.getString("BTN_BROWSE"));
        this.browseButton.addSelectionListener((SelectionListener)this);
        this.createNewButton = new Button((Composite)group, 16);
        this.createNewButton.setText(TestUIPlugin.getString("DLG_RESOURCE_NEW"));
        this.createNewButton.setLayoutData((Object)new GridData(512));
        this.createNewButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)group);
    }

    protected IWizardNode getNewFileWizardNode() {
        IWizard wizard;
        if (this.newFileWizardNode != null && !this.newFileWizardNode.isContentCreated() && (wizard = this.newFileWizardNode.getWizard()) instanceof IWorkbenchWizard) {
            ((IWorkbenchWizard)wizard).init(this.workbench, this.structuredSelection);
            wizard.addPages();
        }
        return this.newFileWizardNode;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        EObjectResourceSelectionDialog fileDialog;
        int ret;
        if (e.widget == this.useExistButton) {
            if (this.isValid()) {
                this.setPageComplete(true);
            }
            this.existFileText.setEnabled(true);
            this.browseButton.setEnabled(true);
            this.browseButton.setFocus();
            super.setSelectedNode(null);
        } else if (e.widget == this.createNewButton) {
            this.setPageComplete(false);
            this.existFileText.setEnabled(false);
            this.browseButton.setEnabled(false);
            super.setSelectedNode(this.getNewFileWizardNode());
        } else if (e.widget == this.browseButton && (ret = (fileDialog = new EObjectResourceSelectionDialog(Display.getCurrent().getActiveShell(), TestUIPlugin.getString("DLG_RESOURCE_SEL"), new String[]{this.fileExtension}, this.fileImage)).open()) == 0) {
            this.selectedEObjects = fileDialog.getSelectedObjects();
            IFile[] files = fileDialog.getSelectedFiles();
            if (files != null && files.length > 0) {
                String selectedFiles = "";
                int i = 0;
                while (i < files.length) {
                    selectedFiles = selectedFiles + files[i].getFullPath().toString();
                    if (i < files.length - 1) {
                        selectedFiles = selectedFiles + ", ";
                    }
                    ++i;
                }
                this.existFileText.removeModifyListener((ModifyListener)this);
                this.existFileText.setText(selectedFiles);
                this.isValid = true;
                this.setPageComplete(true);
                this.existFileText.addModifyListener((ModifyListener)this);
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.existFileText) {
            String existFile = this.existFileText.getText();
            if (existFile != null && existFile.length() > 0) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                Vector<EObject> objects = new Vector<EObject>();
                StringTokenizer tokenizer = new StringTokenizer(existFile, ",");
                while (tokenizer.hasMoreTokens()) {
                    String path = tokenizer.nextToken();
                    IResource resource = root.findMember(path);
                    if (resource == null || !resource.exists() || !this.fileExtension.equals(resource.getFileExtension())) {
                        this.setErrorMessage(path + TestUIPlugin.getString("_ERROR_DLG_RESOURCE_INVLD"));
                        break;
                    }
                    this.setErrorMessage(null);
                    URI uri = URI.createPlatformResourceURI((String)((IFile)resource).getFullPath().toString());
                    EObject[] eObjects = EMFUtil.getEObjects(uri, true);
                    if (eObjects == null && eObjects.length <= 0) continue;
                    int i = 0;
                    while (i < eObjects.length) {
                        objects.add(eObjects[i]);
                        ++i;
                    }
                }
                if (objects.size() > 0) {
                    this.selectedEObjects = new EObject[objects.size()];
                    int i = 0;
                    while (i < objects.size()) {
                        this.selectedEObjects[i] = (EObject)objects.get(i);
                        ++i;
                    }
                    this.isValid = true;
                    this.setPageComplete(true);
                    return;
                }
            }
            this.selectedEObjects = null;
            this.isValid = false;
            this.setPageComplete(false);
        }
    }

    private boolean isValid() {
        return this.isValid;
    }

    public EObject[] getSelectedEObjects() {
        if (this.selectedEObjects == null) {
            this.selectedEObjects = new EObject[0];
        }
        return this.selectedEObjects;
    }
}

