/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.configurations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

public class AbstractLaunchConfigurationFacade {
    protected static final String PROPERTY_PREFIX = "org.eclipse.hyades.test.ui.launch";

    protected static void storeEMFReference(ILaunchConfigurationWorkingCopy configuration, String property, EObject eObject) {
        String uriFragment;
        String uri;
        if (eObject == null) {
            uri = "";
            uriFragment = "";
        } else {
            Assert.isNotNull((Object)eObject.eResource());
            uri = eObject.eResource().getURI().toString();
            uriFragment = eObject.eResource().getURIFragment(eObject);
        }
        configuration.setAttribute(property + "URI", uri);
        configuration.setAttribute(property + "URIFragment", uriFragment);
    }

    protected static EObject resolveEMFReference(ILaunchConfiguration configuration, String property) throws CoreException {
        return AbstractLaunchConfigurationFacade.resolveEMFReference(configuration, property, EMFUtil.getResourceSet());
    }

    protected static EObject resolveEMFReference(ILaunchConfiguration configuration, String property, ResourceSet resourceSet) throws CoreException {
        String uriString = configuration.getAttribute(property + "URI", (String)null);
        String uriFragment = configuration.getAttribute(property + "URIFragment", (String)null);
        if (uriString == null || uriString.equals("")) {
            return null;
        }
        URI uri = URI.createURI((String)uriString);
        try {
            Resource res = resourceSet.getResource(uri, true);
            if (res == null) {
                return null;
            }
            return res.getEObject(uriFragment);
        }
        catch (Throwable t) {
            TestUIPlugin.logError(t);
            return null;
        }
    }

    protected static void storeEMFReferences(ILaunchConfigurationWorkingCopy configuration, String property, List list) {
        ArrayList<String> uriList = new ArrayList<String>();
        ArrayList<String> uriFragmentList = new ArrayList<String>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof EObject)) continue;
            EObject eObject = (EObject)obj;
            if (eObject == null) {
                uriList.add("");
                uriFragmentList.add("");
                continue;
            }
            Assert.isNotNull((Object)eObject.eResource());
            uriList.add(eObject.eResource().getURI().toString());
            uriFragmentList.add(eObject.eResource().getURIFragment(eObject));
        }
        configuration.setAttribute(property + "URI", uriList);
        configuration.setAttribute(property + "URIFragment", uriFragmentList);
    }

    protected static List resolveEMFReferences(ILaunchConfiguration configuration, String property) throws CoreException {
        return AbstractLaunchConfigurationFacade.resolveEMFReferences(configuration, property, EMFUtil.getResourceSet());
    }

    protected static List resolveEMFReferences(ILaunchConfiguration configuration, String property, ResourceSet resourceSet) throws CoreException {
        ArrayList<EObject> ret = new ArrayList<EObject>();
        List uriList = configuration.getAttribute(property + "URI", new ArrayList());
        List uriFragmentList = configuration.getAttribute(property + "URIFragment", new ArrayList());
        if (uriFragmentList.isEmpty() || uriList.isEmpty()) {
            return new ArrayList();
        }
        int i = 0;
        int max = uriList.size();
        while (i < max) {
            String uriString = (String)uriList.get(i);
            if (uriString != null && !uriString.equals("")) {
                URI uri = URI.createURI((String)((String)uriList.get(i)));
                try {
                    EObject obj;
                    Resource res = resourceSet.getResource(uri, true);
                    if (res != null && (obj = res.getEObject((String)uriFragmentList.get(i))) != null) {
                        ret.add(obj);
                    }
                }
                catch (Throwable t) {
                    TestUIPlugin.logError(t);
                }
            }
            ++i;
        }
        return ret;
    }

    protected static IContainer getContainerProperty(ILaunchConfiguration configuration, String property) throws CoreException {
        IResource res;
        String location = configuration.getAttribute(property, (String)null);
        if (location != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember(location)) != null && res instanceof IContainer) {
            return (IContainer)res;
        }
        return null;
    }

    protected static void setContainerProperty(ILaunchConfigurationWorkingCopy configuration, String property, IContainer value) {
        String container = null;
        if (value != null) {
            container = value.getFullPath().toString();
        }
        configuration.setAttribute(property, container);
    }
}

