/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.ui.launch.delegates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.launch.extensions.LaunchConfigurationExtensionsManager;
import org.eclipse.hyades.test.ui.internal.launch.processes.TestExecutionProcess;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler;
import org.eclipse.hyades.test.ui.launch.extensions.IRunHandler2;

public abstract class AbstractLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    private List problems;
    private ResourceSet resourceSet;

    protected abstract Object getLaunchedElement(ILaunchConfiguration var1) throws CoreException;

    protected void validate(ILaunchConfiguration configuration, String mode) throws CoreException {
        Object launchedElement = this.getLaunchedElement(configuration);
        if (launchedElement == null) {
            this.reportProblem("The configuration does not provide a Launchable Test Element");
        }
    }

    protected abstract IExecutor invokeTestExecutionHarness(ILaunchConfiguration var1, String var2, StringBuffer var3) throws CoreException;

    protected void reportProblem(String description) {
        this.problems.add(description);
    }

    protected void resetFields() {
        this.problems = new ArrayList();
        this.resourceSet = null;
    }

    protected ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        return this.resourceSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(TestUIPlugin.getString("BasicTestLaunchConfigurationDelegate.monitorLaunchingTest"), 3);
        try {
            this.resetFields();
            this.validate(configuration, mode);
            if (this.problems.size() > 0) {
                MultiStatus status = new MultiStatus(TestUIPlugin.getID(), 0, TestUIPlugin.getString("_EXC_AbstractLaunchConfigurationDelegate.configurationProblems"), null);
                Iterator it = this.problems.iterator();
                while (it.hasNext()) {
                    String problem = (String)it.next();
                    Status subStatus = new Status(4, TestUIPlugin.getID(), 0, problem, null);
                    status.add((IStatus)subStatus);
                }
                throw new CoreException((IStatus)status);
            }
            IRunHandler runHandler = LaunchConfigurationExtensionsManager.getInstance().getRunHandler(this.getLaunchedElement(configuration));
            if (runHandler != null) {
                try {
                    runHandler.preRun(configuration, mode, launch, this.getResourceSet(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (Throwable t) {
                    Status status = new Status(4, TestUIPlugin.getID(), 0, TestUIPlugin.getString("_EXC_AbstractLaunchConfigurationDelegate.preRunHandlerException"), t);
                    throw new CoreException((IStatus)status);
                }
            }
            StringBuffer errorMessages = new StringBuffer();
            IExecutor executor = null;
            try {
                executor = this.invokeTestExecutionHarness(configuration, mode, errorMessages);
                if (errorMessages.length() > 0) {
                    Status status = new Status(4, TestUIPlugin.getID(), 0, TestUIPlugin.getString("_EXC_AbstractLaunchConfigurationDelegate.testHarnessProblems") + errorMessages, null);
                    throw new CoreException((IStatus)status);
                }
                monitor.worked(1);
            }
            catch (Throwable t) {
                Status status = new Status(4, TestUIPlugin.getID(), 0, TestUIPlugin.getString("_EXC_AbstractLaunchConfigurationDelegate.testHarnessProblems") + t.getClass().getName(), t);
                throw new CoreException((IStatus)status);
            }
            if (executor != null) {
                launch.addProcess((IProcess)new TestExecutionProcess(executor, launch, this.getResourceSet()));
                if (runHandler != null && runHandler instanceof IRunHandler2) {
                    ((IRunHandler2)runHandler).postLaunch(launch, executor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }
}

